/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.codegen.calls.ScalarOperatorGens$;
import org.apache.flink.table.planner.functions.aggfunctions.AvgAggFunction;
import org.apache.flink.table.planner.functions.aggfunctions.Count1AggFunction;
import org.apache.flink.table.planner.functions.aggfunctions.CountAggFunction;
import org.apache.flink.table.planner.functions.aggfunctions.MaxAggFunction;
import org.apache.flink.table.planner.functions.aggfunctions.MinAggFunction;
import org.apache.flink.table.planner.functions.aggfunctions.SumAggFunction;
import org.apache.flink.table.planner.plan.utils.AggregateInfo;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class ProjectionCodeGenerator$ {
    public static ProjectionCodeGenerator$ MODULE$;

    static {
        new ProjectionCodeGenerator$();
    }

    public GeneratedExpression generateProjectionExpression(CodeGeneratorContext ctx, RowType inType, RowType outType, int[] inputMapping, Class<? extends RowData> outClass, String inputTerm, String outRecordTerm, String outRecordWriterTerm, boolean reusedOutRecord) {
        ExprCodeGenerator exprGenerator = new ExprCodeGenerator(ctx, false).bindInput((LogicalType)inType, inputTerm, (Option<int[]>)Option$.MODULE$.apply((Object)inputMapping));
        GeneratedExpression[] accessExprs = (GeneratedExpression[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(inputMapping)).map((Function1 & Serializable & scala.Serializable)idx -> GenerateUtils$.MODULE$.generateFieldAccess(ctx, (LogicalType)inType, inputTerm, BoxesRunTime.unboxToInt((Object)idx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)));
        GeneratedExpression expression = exprGenerator.generateResultExpression((Seq<GeneratedExpression>)Predef$.MODULE$.wrapRefArray((Object[])accessExprs), outType, outClass, outRecordTerm, (Option<String>)Option$.MODULE$.apply((Object)outRecordWriterTerm), reusedOutRecord, exprGenerator.generateResultExpression$default$7());
        String initCode = GenerateUtils$.MODULE$.generateRecordStatement((LogicalType)outType, outClass, outRecordTerm, (Option<String>)new Some((Object)outRecordWriterTerm), ctx);
        String outRowInitCode = reusedOutRecord ? GeneratedExpression$.MODULE$.NO_CODE() : initCode;
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(31).append("\n         |").append(outRowInitCode).append("\n         |").append(expression.code()).append("\n        ").toString())).stripMargin();
        return new GeneratedExpression(outRecordTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, (LogicalType)outType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedProjection generateProjection(CodeGeneratorContext ctx, String name, RowType inType, RowType outType, int[] inputMapping, Class<? extends RowData> outClass, String inputTerm, String outRecordTerm, String outRecordWriterTerm, boolean reusedOutRecord) {
        String className = CodeGenUtils$.MODULE$.newName(name);
        Class<Projection> baseClass = Projection.class;
        GeneratedExpression expression = this.generateProjectionExpression(ctx, inType, outType, inputMapping, outClass, inputTerm, outRecordTerm, outRecordWriterTerm, reusedOutRecord);
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(318).append("\n         |public class ").append(className).append(" implements ").append(baseClass.getCanonicalName()).append("<").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(", ").append(outClass.getCanonicalName()).append("> {\n         |\n         |  ").append(ctx.reuseMemberCode()).append("\n         |\n         |  public ").append(className).append("(Object[] references) throws Exception {\n         |    ").append(ctx.reuseInitCode()).append("\n         |  }\n         |\n         |  @Override\n         |  public ").append(outClass.getCanonicalName()).append(" apply(").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" ").append(inputTerm).append(") {\n         |    ").append(ctx.reuseLocalVariableCode(ctx.reuseLocalVariableCode$default$1())).append("\n         |    ").append(expression.code()).append("\n         |    return ").append(expression.resultTerm()).append(";\n         |  }\n         |}\n        ").toString())).stripMargin();
        return new GeneratedProjection(className, code, (Object[])ctx.references().toArray(ClassTag$.MODULE$.AnyRef()), ctx.tableConfig());
    }

    public String genAdaptiveLocalHashAggValueProjectionCode(CodeGeneratorContext ctx, RowType inputType, Class<? extends RowData> outClass, String inputTerm, AggregateInfo[] aggInfos, int[] auxGrouping, String outRecordTerm, String outRecordWriterTerm) {
        Seq<GeneratedExpression> fieldExprs = this.genAdaptiveLocalHashAggValueProjectionExpr(ctx, inputType, inputTerm, aggInfos, auxGrouping);
        String binaryRowWriter = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(BinaryRowWriter.class));
        String typeTerm = outClass.getCanonicalName();
        ctx.addReusableMember(new StringBuilder(18).append("private ").append(typeTerm).append(" ").append(outRecordTerm).append("= new ").append(typeTerm).append("(").append(fieldExprs.size()).append(");").toString());
        ctx.addReusableMember(new StringBuilder(19).append("private ").append(binaryRowWriter).append(" ").append(outRecordWriterTerm).append(" = new ").append(binaryRowWriter).append("(").append(outRecordTerm).append(");").toString());
        Map fieldExprIdxToOutputRowPosMap = ((TraversableOnce)fieldExprs.indices().map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        String setFieldsCode = ((TraversableOnce)((TraversableLike)fieldExprs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeneratedExpression fieldExpr = (GeneratedExpression)tuple2._1();
            int index = tuple2._2$mcI$sp();
            int pos = BoxesRunTime.unboxToInt((Object)fieldExprIdxToOutputRowPosMap.getOrElse((Object)BoxesRunTime.boxToInteger((int)index), (Function0 & Serializable & scala.Serializable)() -> {
                throw new CodeGenException(new StringBuilder(26).append("Illegal field expr index: ").append(index).toString());
            }));
            String string = CodeGenUtils$.MODULE$.rowSetField(ctx, BinaryRowData.class, outRecordTerm, ((Object)BoxesRunTime.boxToInteger((int)pos)).toString(), fieldExpr, (Option<String>)Option$.MODULE$.apply((Object)outRecordWriterTerm));
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String writer = outRecordWriterTerm;
        String resetWriter = new StringBuilder(9).append(writer).append(".reset();").toString();
        String completeWriter = new StringBuilder(12).append(writer).append(".complete();").toString();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(36).append("\n       |").append(resetWriter).append("\n       |").append(setFieldsCode).append("\n       |").append(completeWriter).append("\n        ").toString())).stripMargin();
    }

    public Class<? extends RowData> genAdaptiveLocalHashAggValueProjectionCode$default$3() {
        return BinaryRowData.class;
    }

    public String genAdaptiveLocalHashAggValueProjectionCode$default$4() {
        return CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM();
    }

    public String genAdaptiveLocalHashAggValueProjectionCode$default$7() {
        return CodeGenUtils$.MODULE$.DEFAULT_OUT_RECORD_TERM();
    }

    public String genAdaptiveLocalHashAggValueProjectionCode$default$8() {
        return CodeGenUtils$.MODULE$.DEFAULT_OUT_RECORD_WRITER_TERM();
    }

    public Seq<GeneratedExpression> genAdaptiveLocalHashAggValueProjectionExpr(CodeGeneratorContext ctx, RowType inputType, String inputTerm, AggregateInfo[] aggInfos, int[] auxGrouping) {
        ArrayBuffer fieldExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGrouping)).foreach((Function1 & Serializable & scala.Serializable)i -> fieldExprs.$plus$eq((Object)ProjectionCodeGenerator$.MODULE$.reuseFieldExprForAggFunc(ctx, (LogicalType)inputType, inputTerm, BoxesRunTime.unboxToInt((Object)i))));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfos)).map((Function1 & Serializable & scala.Serializable)aggInfo -> {
            ArrayBuffer arrayBuffer;
            UserDefinedFunction userDefinedFunction = aggInfo.function();
            if (userDefinedFunction instanceof SumAggFunction) {
                SumAggFunction sumAggFunction = (SumAggFunction)userDefinedFunction;
                arrayBuffer = fieldExprs.$plus$eq((Object)MODULE$.genValueProjectionForSumAggFunc(ctx, (LogicalType)inputType, inputTerm, sumAggFunction.getResultType().getLogicalType(), Predef$.MODULE$.Integer2int(aggInfo.agg().getArgList().get(0))));
            } else {
                boolean bl = userDefinedFunction instanceof MaxAggFunction ? true : userDefinedFunction instanceof MinAggFunction;
                if (bl) {
                    arrayBuffer = fieldExprs.$plus$eq((Object)MODULE$.reuseFieldExprForAggFunc(ctx, (LogicalType)inputType, inputTerm, Predef$.MODULE$.Integer2int(aggInfo.agg().getArgList().get(0))));
                } else if (userDefinedFunction instanceof AvgAggFunction) {
                    AvgAggFunction avgAggFunction = (AvgAggFunction)userDefinedFunction;
                    fieldExprs.$plus$eq((Object)MODULE$.genValueProjectionForSumAggFunc(ctx, (LogicalType)inputType, inputTerm, avgAggFunction.getSumType().getLogicalType(), Predef$.MODULE$.Integer2int(aggInfo.agg().getArgList().get(0))));
                    arrayBuffer = fieldExprs.$plus$eq((Object)MODULE$.genValueProjectionForCountAggFunc(ctx, inputTerm, Predef$.MODULE$.Integer2int(aggInfo.agg().getArgList().get(0))));
                } else if (userDefinedFunction instanceof CountAggFunction) {
                    arrayBuffer = fieldExprs.$plus$eq((Object)MODULE$.genValueProjectionForCountAggFunc(ctx, inputTerm, Predef$.MODULE$.Integer2int(aggInfo.agg().getArgList().get(0))));
                } else if (userDefinedFunction instanceof Count1AggFunction) {
                    arrayBuffer = fieldExprs.$plus$eq((Object)MODULE$.genValueProjectionForCount1AggFunc(ctx));
                } else {
                    throw new MatchError((Object)userDefinedFunction);
                }
            }
            return arrayBuffer;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ArrayBuffer.class)));
        return fieldExprs;
    }

    public String genAdaptiveLocalHashAggValueProjectionExpr$default$3() {
        return CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM();
    }

    public GeneratedExpression genValueProjectionForSumAggFunc(CodeGeneratorContext ctx, LogicalType inputType, String inputTerm, LogicalType targetType, int index) {
        GeneratedExpression fieldExpr = this.reuseFieldExprForAggFunc(ctx, inputType, inputTerm, index);
        return ScalarOperatorGens$.MODULE$.generateCast(ctx, fieldExpr, targetType, true);
    }

    public GeneratedExpression reuseFieldExprForAggFunc(CodeGeneratorContext ctx, LogicalType inputType, String inputTerm, int index) {
        GeneratedExpression generatedExpression;
        Option<GeneratedExpression> option = ctx.getReusableInputUnboxingExprs(inputTerm, index);
        if (None$.MODULE$.equals(option)) {
            generatedExpression = GenerateUtils$.MODULE$.generateFieldAccess(ctx, inputType, inputTerm, index);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            GeneratedExpression expr = (GeneratedExpression)some.value();
            generatedExpression = new GeneratedExpression(expr.resultTerm(), expr.nullTerm(), GeneratedExpression$.MODULE$.NO_CODE(), expr.resultType(), GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            throw new MatchError(option);
        }
        return generatedExpression;
    }

    public GeneratedExpression genValueProjectionForCountAggFunc(CodeGeneratorContext ctx, String inputTerm, int index) {
        String string;
        Option<GeneratedExpression> option = ctx.getReusableInputUnboxingExprs(inputTerm, index);
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(11).append(inputTerm).append(".isNullAt(").append(index).append(")").toString();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            GeneratedExpression expr = (GeneratedExpression)some.value();
            string = expr.nullTerm();
        } else {
            throw new MatchError(option);
        }
        String fieldNullCode = string;
        Seq<String> seq = ctx.addReusableLocalVariables((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"long", (Object)"field"), new Tuple2((Object)"boolean", (Object)"isNull")}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String fieldTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)fieldTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String fieldTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String inputCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("\n         |").append(fieldTerm2).append(" = 0L;\n         |if (!").append(fieldNullCode).append(") {\n         |  ").append(fieldTerm2).append(" = 1L;\n         |}\n           ").toString())).stripMargin().trim();
        return new GeneratedExpression(fieldTerm2, nullTerm2, inputCode, (LogicalType)new BigIntType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression genValueProjectionForCount1AggFunc(CodeGeneratorContext ctx) {
        Seq<String> seq = ctx.addReusableLocalVariables((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"long", (Object)"field"), new Tuple2((Object)"boolean", (Object)"isNull")}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String fieldTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)fieldTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String fieldTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String inputCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(28).append("\n         |").append(fieldTerm2).append(" = 1L;\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(fieldTerm2, nullTerm2, inputCode, (LogicalType)new BigIntType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedProjection generateProjection(CodeGeneratorContext ctx, String name, RowType inputType, RowType outputType, int[] inputMapping) {
        CodeGeneratorContext x$3 = ctx;
        String x$4 = name;
        RowType x$5 = inputType;
        RowType x$6 = outputType;
        int[] x$7 = inputMapping;
        String x$8 = CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM();
        Class<? extends RowData> x$9 = this.generateProjection$default$6();
        String x$10 = this.generateProjection$default$8();
        String x$11 = this.generateProjection$default$9();
        boolean x$12 = this.generateProjection$default$10();
        return this.generateProjection(x$3, x$4, x$5, x$6, x$7, x$9, x$8, x$10, x$11, x$12);
    }

    public GeneratedProjection generateProjection(CodeGeneratorContext ctx, String name, RowType inputType, RowType outputType, int[] inputMapping, Class<? extends RowData> outClass) {
        return this.generateProjection(ctx, name, inputType, outputType, inputMapping, outClass, CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM(), this.generateProjection$default$8(), this.generateProjection$default$9(), this.generateProjection$default$10());
    }

    public Class<? extends RowData> generateProjection$default$6() {
        return BinaryRowData.class;
    }

    public String generateProjection$default$7() {
        return CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM();
    }

    public String generateProjection$default$8() {
        return CodeGenUtils$.MODULE$.DEFAULT_OUT_RECORD_TERM();
    }

    public String generateProjection$default$9() {
        return CodeGenUtils$.MODULE$.DEFAULT_OUT_RECORD_WRITER_TERM();
    }

    public boolean generateProjection$default$10() {
        return true;
    }

    public Class<? extends RowData> generateProjectionExpression$default$5() {
        return BinaryRowData.class;
    }

    public String generateProjectionExpression$default$6() {
        return CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM();
    }

    public String generateProjectionExpression$default$7() {
        return CodeGenUtils$.MODULE$.DEFAULT_OUT_RECORD_TERM();
    }

    public String generateProjectionExpression$default$8() {
        return CodeGenUtils$.MODULE$.DEFAULT_OUT_RECORD_WRITER_TERM();
    }

    public boolean generateProjectionExpression$default$9() {
        return true;
    }

    private ProjectionCodeGenerator$() {
        MODULE$ = this;
    }
}

