/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.math.BigDecimal;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.calcite.shaded.org.checkerframework.dataflow.qual.Pure;

public class SqlNumericLiteral
extends SqlLiteral {
    private @Nullable Integer prec;
    private @Nullable Integer scale;
    private boolean isExact;

    protected SqlNumericLiteral(BigDecimal value, @Nullable Integer prec, @Nullable Integer scale, boolean isExact, SqlParserPos pos) {
        super(value, isExact ? SqlTypeName.DECIMAL : SqlTypeName.DOUBLE, pos);
        this.prec = prec;
        this.scale = scale;
        this.isExact = isExact;
    }

    private BigDecimal getValueNonNull() {
        return (BigDecimal)Objects.requireNonNull(this.value, "value");
    }

    public @Nullable Integer getPrec() {
        return this.prec;
    }

    @Pure
    public @Nullable Integer getScale() {
        return this.scale;
    }

    public boolean isExact() {
        return this.isExact;
    }

    @Override
    public SqlNumericLiteral clone(SqlParserPos pos) {
        return new SqlNumericLiteral(this.getValueNonNull(), this.getPrec(), this.getScale(), this.isExact, pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.literal(this.toValue());
    }

    @Override
    public String toValue() {
        BigDecimal bd = this.getValueNonNull();
        if (this.isExact) {
            return this.getValueNonNull().toString();
        }
        return Util.toScientificNotation(bd);
    }

    @Override
    public RelDataType createSqlType(RelDataTypeFactory typeFactory) {
        if (this.isExact) {
            int scaleValue = Objects.requireNonNull(this.scale, "scale");
            if (0 == scaleValue) {
                BigDecimal bd = this.getValueNonNull();
                long l = bd.longValue();
                SqlTypeName result = l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE ? SqlTypeName.INTEGER : SqlTypeName.BIGINT;
                return typeFactory.createSqlType(result);
            }
            return typeFactory.createSqlType(SqlTypeName.DECIMAL, Objects.requireNonNull(this.prec, "prec"), scaleValue);
        }
        return typeFactory.createSqlType(SqlTypeName.DOUBLE);
    }

    public boolean isInteger() {
        return this.scale != null && 0 == this.scale;
    }
}

