/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.CoerceInputsRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.flink.calcite.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.calcite.shaded.com.google.common.primitives.Booleans;
import org.apache.flink.calcite.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="CoerceInputsRule", generator="Immutables")
final class ImmutableCoerceInputsRule {
    private ImmutableCoerceInputsRule() {
    }

    @CheckReturnValue
    @Generated(from="CoerceInputsRule.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements CoerceInputsRule.Config {
        private final RelBuilderFactory relBuilderFactory;
        @javax.annotation.Nullable
        private final @Nullable String description;
        private final RelRule.OperandTransform operandSupplier;
        private final boolean coerceNames;
        private final Class<? extends RelNode> consumerRelClass;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Config(Builder builder) {
            this.description = builder.description;
            this.consumerRelClass = builder.consumerRelClass;
            if (builder.relBuilderFactory != null) {
                this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
            }
            if (builder.operandSupplier != null) {
                this.initShim.withOperandSupplier(builder.operandSupplier);
            }
            if (builder.coerceNamesIsSet()) {
                this.initShim.withCoerceNames(builder.coerceNames);
            }
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.coerceNames = this.initShim.isCoerceNames();
            this.initShim = null;
        }

        private Config(RelBuilderFactory relBuilderFactory, @javax.annotation.Nullable @Nullable String description, RelRule.OperandTransform operandSupplier, boolean coerceNames, Class<? extends RelNode> consumerRelClass) {
            this.relBuilderFactory = relBuilderFactory;
            this.description = description;
            this.operandSupplier = operandSupplier;
            this.coerceNames = coerceNames;
            this.consumerRelClass = consumerRelClass;
            this.initShim = null;
        }

        private RelBuilderFactory relBuilderFactoryInitialize() {
            return CoerceInputsRule.Config.super.relBuilderFactory();
        }

        private RelRule.OperandTransform operandSupplierInitialize() {
            return CoerceInputsRule.Config.super.operandSupplier();
        }

        private boolean isCoerceNamesInitialize() {
            return CoerceInputsRule.Config.super.isCoerceNames();
        }

        @Override
        public RelBuilderFactory relBuilderFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
        }

        @Override
        @javax.annotation.Nullable
        public @Nullable String description() {
            return this.description;
        }

        @Override
        public RelRule.OperandTransform operandSupplier() {
            InitShim shim = this.initShim;
            return shim != null ? shim.operandSupplier() : this.operandSupplier;
        }

        @Override
        public boolean isCoerceNames() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isCoerceNames() : this.coerceNames;
        }

        @Override
        public Class<? extends RelNode> consumerRelClass() {
            return this.consumerRelClass;
        }

        @Override
        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return new Config(newValue, this.description, this.operandSupplier, this.coerceNames, this.consumerRelClass);
        }

        @Override
        public final Config withDescription(@javax.annotation.Nullable @Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new Config(this.relBuilderFactory, value, this.operandSupplier, this.coerceNames, this.consumerRelClass);
        }

        @Override
        public final Config withOperandSupplier(RelRule.OperandTransform value) {
            if (this.operandSupplier == value) {
                return this;
            }
            RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
            return new Config(this.relBuilderFactory, this.description, newValue, this.coerceNames, this.consumerRelClass);
        }

        @Override
        public final Config withCoerceNames(boolean value) {
            if (this.coerceNames == value) {
                return this;
            }
            return new Config(this.relBuilderFactory, this.description, this.operandSupplier, value, this.consumerRelClass);
        }

        @Override
        public final Config withConsumerRelClass(Class<? extends RelNode> value) {
            if (this.consumerRelClass == value) {
                return this;
            }
            Class<? extends RelNode> newValue = Objects.requireNonNull(value, "consumerRelClass");
            return new Config(this.relBuilderFactory, this.description, this.operandSupplier, this.coerceNames, newValue);
        }

        public boolean equals(@javax.annotation.Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier) && this.coerceNames == another.coerceNames && this.consumerRelClass.equals(another.consumerRelClass);
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + this.relBuilderFactory.hashCode();
            h2 += (h2 << 5) + Objects.hashCode(this.description);
            h2 += (h2 << 5) + this.operandSupplier.hashCode();
            h2 += (h2 << 5) + Booleans.hashCode(this.coerceNames);
            h2 += (h2 << 5) + this.consumerRelClass.hashCode();
            return h2;
        }

        public String toString() {
            return MoreObjects.toStringHelper("Config").omitNullValues().add("relBuilderFactory", this.relBuilderFactory).add("description", this.description).add("operandSupplier", this.operandSupplier).add("coerceNames", this.coerceNames).add("consumerRelClass", this.consumerRelClass).toString();
        }

        public static Config copyOf(CoerceInputsRule.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="CoerceInputsRule.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_CONSUMER_REL_CLASS = 1L;
            private static final long OPT_BIT_COERCE_NAMES = 1L;
            private long initBits = 1L;
            private long optBits;
            @javax.annotation.Nullable
            private RelBuilderFactory relBuilderFactory;
            @javax.annotation.Nullable
            private @Nullable String description;
            @javax.annotation.Nullable
            private RelRule.OperandTransform operandSupplier;
            private boolean coerceNames;
            @javax.annotation.Nullable
            private Class<? extends RelNode> consumerRelClass;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(RelRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(CoerceInputsRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                RelRule.Config instance;
                if (object instanceof RelRule.Config) {
                    instance = (RelRule.Config)object;
                    this.withRelBuilderFactory(instance.relBuilderFactory());
                    this.withOperandSupplier(instance.operandSupplier());
                    @Nullable String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.withDescription(descriptionValue);
                    }
                }
                if (object instanceof CoerceInputsRule.Config) {
                    instance = (CoerceInputsRule.Config)object;
                    this.withConsumerRelClass(instance.consumerRelClass());
                    this.withCoerceNames(instance.isCoerceNames());
                }
            }

            @CanIgnoreReturnValue
            public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDescription(@javax.annotation.Nullable @Nullable String description) {
                this.description = description;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withCoerceNames(boolean coerceNames) {
                this.coerceNames = coerceNames;
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withConsumerRelClass(Class<? extends RelNode> consumerRelClass) {
                this.consumerRelClass = Objects.requireNonNull(consumerRelClass, "consumerRelClass");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Config build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Config(this);
            }

            private boolean coerceNamesIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("consumerRelClass");
                }
                return "Cannot build Config, some of required attributes are not set " + attributes;
            }
        }

        @Generated(from="CoerceInputsRule.Config", generator="Immutables")
        private final class InitShim {
            private byte relBuilderFactoryBuildStage = 0;
            private RelBuilderFactory relBuilderFactory;
            private byte operandSupplierBuildStage = 0;
            private RelRule.OperandTransform operandSupplier;
            private byte coerceNamesBuildStage = 0;
            private boolean coerceNames;

            private InitShim() {
            }

            RelBuilderFactory relBuilderFactory() {
                if (this.relBuilderFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.relBuilderFactoryBuildStage == 0) {
                    this.relBuilderFactoryBuildStage = (byte)-1;
                    this.relBuilderFactory = Objects.requireNonNull(Config.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                    this.relBuilderFactoryBuildStage = 1;
                }
                return this.relBuilderFactory;
            }

            void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = relBuilderFactory;
                this.relBuilderFactoryBuildStage = 1;
            }

            RelRule.OperandTransform operandSupplier() {
                if (this.operandSupplierBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.operandSupplierBuildStage == 0) {
                    this.operandSupplierBuildStage = (byte)-1;
                    this.operandSupplier = Objects.requireNonNull(Config.this.operandSupplierInitialize(), "operandSupplier");
                    this.operandSupplierBuildStage = 1;
                }
                return this.operandSupplier;
            }

            void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = operandSupplier;
                this.operandSupplierBuildStage = 1;
            }

            boolean isCoerceNames() {
                if (this.coerceNamesBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.coerceNamesBuildStage == 0) {
                    this.coerceNamesBuildStage = (byte)-1;
                    this.coerceNames = Config.this.isCoerceNamesInitialize();
                    this.coerceNamesBuildStage = 1;
                }
                return this.coerceNames;
            }

            void withCoerceNames(boolean coerceNames) {
                this.coerceNames = coerceNames;
                this.coerceNamesBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.relBuilderFactoryBuildStage == -1) {
                    attributes.add("relBuilderFactory");
                }
                if (this.operandSupplierBuildStage == -1) {
                    attributes.add("operandSupplier");
                }
                if (this.coerceNamesBuildStage == -1) {
                    attributes.add("coerceNames");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

