/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.statemachine;

import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.source.util.ratelimit.RateLimiterStrategy;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.datagen.source.DataGeneratorSource;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.connector.kafka.source.KafkaSource;
import org.apache.flink.connector.kafka.source.enumerator.initializer.OffsetsInitializer;
import org.apache.flink.connector.kafka.source.reader.deserializer.KafkaRecordDeserializationSchema;
import org.apache.flink.contrib.streaming.state.EmbeddedRocksDBStateBackend;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.hashmap.HashMapStateBackend;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.streaming.examples.statemachine.dfa.State;
import org.apache.flink.streaming.examples.statemachine.event.Alert;
import org.apache.flink.streaming.examples.statemachine.event.Event;
import org.apache.flink.streaming.examples.statemachine.generator.EventsGeneratorFunction;
import org.apache.flink.streaming.examples.statemachine.kafka.EventDeSerializationSchema;
import org.apache.flink.util.Collector;

public class StateMachineExample {
    public static void main(String[] args) throws Exception {
        DataStreamSource events;
        String checkpointDir;
        System.out.println("Usage with built-in data generator: StateMachineExample [--error-rate <probability-of-invalid-transition>] [--sleep <sleep-per-record-in-ms> | --rps <records-per-second>]");
        System.out.println("Usage with Kafka: StateMachineExample --kafka-topic <topic> [--brokers <brokers>]");
        System.out.println("Options for both the above setups: ");
        System.out.println("\t[--backend <hashmap|rocks>]");
        System.out.println("\t[--checkpoint-dir <filepath>]");
        System.out.println("\t[--incremental-checkpoints <true|false>]");
        System.out.println("\t[--output <filepath> OR null for stdout]");
        System.out.println();
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.enableCheckpointing(2000L);
        String stateBackend = params.get("backend", "memory");
        if ("hashmap".equals(stateBackend)) {
            checkpointDir = params.get("checkpoint-dir");
            env.setStateBackend((StateBackend)new HashMapStateBackend());
            env.getCheckpointConfig().setCheckpointStorage(checkpointDir);
        } else if ("rocks".equals(stateBackend)) {
            checkpointDir = params.get("checkpoint-dir");
            boolean incrementalCheckpoints = params.getBoolean("incremental-checkpoints", false);
            env.setStateBackend((StateBackend)new EmbeddedRocksDBStateBackend(incrementalCheckpoints));
            env.getCheckpointConfig().setCheckpointStorage(checkpointDir);
        }
        if (params.has("kafka-topic")) {
            String kafkaTopic = params.get("kafka-topic");
            String brokers = params.get("brokers", "localhost:9092");
            System.out.printf("Reading from kafka topic %s @ %s\n", kafkaTopic, brokers);
            System.out.println();
            KafkaSource<Event> source = KafkaSource.builder().setBootstrapServers(brokers).setGroupId("stateMachineExample").setTopics(kafkaTopic).setDeserializer(KafkaRecordDeserializationSchema.valueOnly(new EventDeSerializationSchema())).setStartingOffsets(OffsetsInitializer.latest()).build();
            events = env.fromSource(source, WatermarkStrategy.noWatermarks(), "StateMachineExampleSource");
        } else {
            double errorRate = params.getDouble("error-rate", 0.0);
            int sleep = params.getInt("sleep", 1);
            double recordsPerSecond = params.getDouble("rps", StateMachineExample.rpsFromSleep(sleep, env.getParallelism()));
            System.out.printf("Using standalone source with error rate %f and %.1f records per second\n", errorRate, recordsPerSecond);
            System.out.println();
            EventsGeneratorFunction generatorFunction = new EventsGeneratorFunction(errorRate);
            DataGeneratorSource<Event> eventGeneratorSource = new DataGeneratorSource<Event>(generatorFunction, Long.MAX_VALUE, RateLimiterStrategy.perSecond((double)recordsPerSecond), TypeInformation.of(Event.class));
            events = env.fromSource(eventGeneratorSource, WatermarkStrategy.noWatermarks(), "Events Generator Source");
        }
        String outputFile = params.get("output");
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        SingleOutputStreamOperator alerts = events.keyBy(Event::sourceAddress).flatMap((FlatMapFunction)new StateMachineMapper());
        if (outputFile == null) {
            alerts.print();
        } else {
            alerts.sinkTo((Sink)((FileSink.DefaultRowFormatBuilder)FileSink.forRowFormat((Path)new Path(outputFile), (Encoder)new SimpleStringEncoder()).withRollingPolicy((RollingPolicy)DefaultRollingPolicy.builder().withMaxPartSize(MemorySize.ofMebiBytes((long)1L)).withRolloverInterval(Duration.ofSeconds(10L)).build())).build()).setParallelism(1).name("output");
        }
        env.execute("State machine job");
    }

    private static double rpsFromSleep(int sleep, int parallelism) {
        return 1000.0 / (double)sleep * (double)parallelism;
    }

    static class StateMachineMapper
    extends RichFlatMapFunction<Event, Alert> {
        private ValueState<State> currentState;

        StateMachineMapper() {
        }

        public void open(Configuration conf) {
            this.currentState = this.getRuntimeContext().getState(new ValueStateDescriptor("state", State.class));
        }

        public void flatMap(Event evt, Collector<Alert> out) throws Exception {
            State nextState;
            State state = (State)((Object)this.currentState.value());
            if (state == null) {
                state = State.Initial;
            }
            if ((nextState = state.transition(evt.type())) == State.InvalidTransition) {
                out.collect((Object)new Alert(evt.sourceAddress(), state, evt.type()));
            } else if (nextState.isTerminal()) {
                this.currentState.clear();
            } else {
                this.currentState.update((Object)nextState);
            }
        }
    }
}

