/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.context;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.cli.ExecutionConfigAccessor;
import org.apache.flink.client.cli.ProgramOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultContext.class);
    private final Configuration flinkConfig;
    private final List<URL> dependencies;

    public DefaultContext(Map<String, String> flinkConfig, List<URL> dependencies) {
        this(Configuration.fromMap(flinkConfig), dependencies);
    }

    public DefaultContext(Configuration flinkConfig, List<URL> dependencies) {
        this.flinkConfig = flinkConfig;
        this.dependencies = dependencies;
    }

    public Configuration getFlinkConfig() {
        return this.flinkConfig;
    }

    public List<URL> getDependencies() {
        return this.dependencies;
    }

    private static Options collectCommandLineOptions(List<CustomCommandLine> commandLines) {
        Options customOptions = new Options();
        for (CustomCommandLine customCommandLine : commandLines) {
            customCommandLine.addGeneralOptions(customOptions);
            customCommandLine.addRunOptions(customOptions);
        }
        return CliFrontendParser.mergeOptions((Options)CliFrontendParser.getRunCommandOptions(), (Options)customOptions);
    }

    private static Configuration createExecutionConfig(CommandLine commandLine, Options commandLineOptions, List<CustomCommandLine> availableCommandLines, List<URL> dependencies) throws FlinkException {
        LOG.debug("Available commandline options: {}", (Object)commandLineOptions);
        List options = Stream.of(commandLine.getOptions()).map(o -> o.getOpt() + "=" + o.getValue()).collect(Collectors.toList());
        LOG.debug("Instantiated commandline args: {}, options: {}", (Object)commandLine.getArgList(), options);
        CustomCommandLine activeCommandLine = DefaultContext.findActiveCommandLine(availableCommandLines, commandLine);
        LOG.debug("Available commandlines: {}, active commandline: {}", availableCommandLines, (Object)activeCommandLine);
        Configuration executionConfig = activeCommandLine.toConfiguration(commandLine);
        try {
            ProgramOptions programOptions = ProgramOptions.create((CommandLine)commandLine);
            ExecutionConfigAccessor executionConfigAccessor = ExecutionConfigAccessor.fromProgramOptions((ProgramOptions)programOptions, dependencies);
            executionConfigAccessor.applyToConfiguration(executionConfig);
        }
        catch (CliArgsException e) {
            throw new SqlGatewayException("Invalid deployment run options.", e);
        }
        LOG.info("Execution config: {}", (Object)executionConfig);
        return executionConfig;
    }

    private static CustomCommandLine findActiveCommandLine(List<CustomCommandLine> availableCommandLines, CommandLine commandLine) {
        for (CustomCommandLine cli : availableCommandLines) {
            if (!cli.isActive(commandLine)) continue;
            return cli;
        }
        throw new SqlGatewayException("Could not find a matching deployment.");
    }

    public static DefaultContext load(Configuration dynamicConfig, List<URL> dependencies, boolean discoverExecutionConfig, boolean discoverPythonJar) {
        String flinkConfigDir = CliFrontend.getConfigurationDirectoryFromEnv();
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)flinkConfigDir);
        configuration.addAll(dynamicConfig);
        List commandLines = CliFrontend.loadCustomCommandLines((Configuration)configuration, (String)flinkConfigDir);
        FileSystem.initialize((Configuration)configuration, (PluginManager)PluginUtils.createPluginManagerFromRootFolder((Configuration)configuration));
        if (discoverPythonJar) {
            dependencies = new ArrayList<URL>(dependencies);
            dependencies.addAll(DefaultContext.discoverPythonDependencies());
        }
        if (discoverExecutionConfig) {
            Options commandLineOptions = DefaultContext.collectCommandLineOptions(commandLines);
            try {
                CommandLine deploymentCommandLine = CliFrontendParser.parse((Options)commandLineOptions, (String[])new String[0], (boolean)true);
                configuration.addAll(DefaultContext.createExecutionConfig(deploymentCommandLine, commandLineOptions, commandLines, dependencies));
            }
            catch (Exception e) {
                throw new SqlGatewayException("Could not load available CLI with Environment Deployment entry.", e);
            }
        }
        return new DefaultContext(configuration, dependencies);
    }

    private static List<URL> discoverPythonDependencies() {
        try {
            URL location = Class.forName("org.apache.flink.python.PythonFunctionRunner", false, Thread.currentThread().getContextClassLoader()).getProtectionDomain().getCodeSource().getLocation();
            if (Paths.get(location.toURI()).toFile().isFile()) {
                return Collections.singletonList(location);
            }
        }
        catch (ClassNotFoundException | URISyntaxException e) {
            LOG.warn("Failed to find flink-python jar." + e);
        }
        return Collections.emptyList();
    }
}

