/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;

@Internal
public final class MultiStateKeyIterator<K>
implements CloseableIterator<K> {
    private final List<? extends StateDescriptor<?, ?>> descriptors;
    private final KeyedStateBackend<K> backend;
    private final Iterator<K> internal;
    private final CloseableRegistry registry;
    private K currentKey;

    public MultiStateKeyIterator(List<? extends StateDescriptor<?, ?>> descriptors, KeyedStateBackend<K> backend) {
        this.descriptors = (List)Preconditions.checkNotNull(descriptors);
        this.backend = (KeyedStateBackend)Preconditions.checkNotNull(backend);
        this.registry = new CloseableRegistry();
        this.internal = descriptors.stream().map(descriptor -> backend.getKeys(descriptor.getName(), (Object)VoidNamespace.INSTANCE)).peek(stream -> {
            try {
                this.registry.registerCloseable(stream::close);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read keys from configured StateBackend", e);
            }
        }).flatMap(stream -> stream).iterator();
    }

    public boolean hasNext() {
        return this.internal.hasNext();
    }

    public K next() {
        this.currentKey = this.internal.next();
        return this.currentKey;
    }

    public void remove() {
        if (this.currentKey == null) {
            return;
        }
        for (StateDescriptor<?, ?> descriptor : this.descriptors) {
            try {
                State state = this.backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, descriptor);
                state.clear();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to drop partitioned state from state backend", e);
            }
        }
    }

    public void close() throws Exception {
        this.registry.close();
    }
}

