/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.join;

import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.AscendingTimestampsWatermarks;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssignerSupplier;
import org.apache.flink.api.common.eventtime.WatermarkGenerator;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.examples.join.WindowJoinSampleData;

public class WindowJoin {
    public static void main(String[] args) throws Exception {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        long windowSize = params.getLong("windowSize", 2000L);
        long rate = params.getLong("rate", 3L);
        boolean fileOutput = params.has("output");
        System.out.println("Using windowSize=" + windowSize + ", data rate=" + rate);
        System.out.println("To customize example, use: WindowJoin [--windowSize <window-size-in-millis>] [--rate <elements-per-second>]");
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        SingleOutputStreamOperator grades = WindowJoinSampleData.GradeSource.getSource(env, rate).assignTimestampsAndWatermarks(IngestionTimeWatermarkStrategy.create());
        SingleOutputStreamOperator salaries = WindowJoinSampleData.SalarySource.getSource(env, rate).assignTimestampsAndWatermarks(IngestionTimeWatermarkStrategy.create());
        DataStream<Tuple3<String, Integer, Integer>> joinedStream = WindowJoin.runWindowJoin((DataStream<Tuple2<String, Integer>>)grades, (DataStream<Tuple2<String, Integer>>)salaries, windowSize);
        if (fileOutput) {
            joinedStream.sinkTo((Sink)((FileSink.DefaultRowFormatBuilder)FileSink.forRowFormat((Path)new Path(params.get("output")), (Encoder)new SimpleStringEncoder()).withRollingPolicy((RollingPolicy)DefaultRollingPolicy.builder().withMaxPartSize(MemorySize.ofMebiBytes((long)1L)).withRolloverInterval(Duration.ofSeconds(10L)).build())).build()).name("output");
        } else {
            joinedStream.print().setParallelism(1);
        }
        env.execute("Windowed Join Example");
    }

    public static DataStream<Tuple3<String, Integer, Integer>> runWindowJoin(DataStream<Tuple2<String, Integer>> grades, DataStream<Tuple2<String, Integer>> salaries, long windowSize) {
        return grades.join(salaries).where((KeySelector)new NameKeySelector()).equalTo((KeySelector)new NameKeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.milliseconds((long)windowSize))).apply((JoinFunction)new JoinFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, Tuple3<String, Integer, Integer>>(){

            public Tuple3<String, Integer, Integer> join(Tuple2<String, Integer> first, Tuple2<String, Integer> second) {
                return new Tuple3(first.f0, first.f1, second.f1);
            }
        });
    }

    private static class IngestionTimeWatermarkStrategy<T>
    implements WatermarkStrategy<T> {
        private IngestionTimeWatermarkStrategy() {
        }

        public static <T> IngestionTimeWatermarkStrategy<T> create() {
            return new IngestionTimeWatermarkStrategy<T>();
        }

        public WatermarkGenerator<T> createWatermarkGenerator(WatermarkGeneratorSupplier.Context context) {
            return new AscendingTimestampsWatermarks();
        }

        public TimestampAssigner<T> createTimestampAssigner(TimestampAssignerSupplier.Context context) {
            return (event, timestamp) -> System.currentTimeMillis();
        }
    }

    private static class NameKeySelector
    implements KeySelector<Tuple2<String, Integer>, String> {
        private NameKeySelector() {
        }

        public String getKey(Tuple2<String, Integer> value) {
            return (String)value.f0;
        }
    }
}

