/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.fs.gs.GSFileSystem;
import org.apache.flink.fs.gs.GSFileSystemOptions;
import org.apache.flink.fs.gs.utils.ConfigUtils;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSFileSystemFactory
implements FileSystemFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSFileSystemFactory.class);
    public static final String SCHEME = "gs";
    @Nullable
    private org.apache.hadoop.conf.Configuration hadoopConfig;
    @Nullable
    private GSFileSystemOptions fileSystemOptions;
    @Nullable
    private Storage storage;

    public GSFileSystemFactory() {
        LOGGER.info("Creating GSFileSystemFactory");
    }

    public void configure(Configuration flinkConfig) {
        LOGGER.info("Configuring GSFileSystemFactory with Flink configuration {}", (Object)flinkConfig);
        Preconditions.checkNotNull((Object)flinkConfig);
        RuntimeConfigContext configContext = new RuntimeConfigContext();
        this.hadoopConfig = ConfigUtils.getHadoopConfiguration(flinkConfig, configContext);
        LOGGER.info("Using Hadoop configuration {}", (Object)ConfigUtils.stringifyHadoopConfig(this.hadoopConfig));
        this.fileSystemOptions = new GSFileSystemOptions(flinkConfig);
        LOGGER.info("Using file system options {}", (Object)this.fileSystemOptions);
        Optional<GoogleCredentials> credentials = ConfigUtils.getStorageCredentials(this.hadoopConfig, configContext);
        StorageOptions.Builder storageOptionsBuilder = StorageOptions.newBuilder();
        credentials.ifPresent(storageOptionsBuilder::setCredentials);
        this.storage = (Storage)storageOptionsBuilder.build().getService();
    }

    public String getScheme() {
        return SCHEME;
    }

    public FileSystem create(URI fsUri) throws IOException {
        LOGGER.info("Creating GSFileSystem for uri {} with options {}", (Object)fsUri, (Object)this.fileSystemOptions);
        Preconditions.checkNotNull((Object)fsUri);
        GoogleHadoopFileSystem googleHadoopFileSystem = new GoogleHadoopFileSystem();
        try {
            googleHadoopFileSystem.initialize(fsUri, this.hadoopConfig);
        }
        catch (IOException ex) {
            throw new IOException("Failed to initialize GoogleHadoopFileSystem", ex);
        }
        return new GSFileSystem(googleHadoopFileSystem, this.storage, this.fileSystemOptions);
    }

    private static class RuntimeConfigContext
    implements ConfigUtils.ConfigContext {
        private RuntimeConfigContext() {
        }

        @Override
        public Optional<String> getenv(String name) {
            return Optional.ofNullable(System.getenv(name));
        }

        @Override
        public org.apache.hadoop.conf.Configuration loadHadoopConfigFromDir(String configDir) {
            org.apache.hadoop.conf.Configuration hadoopConfig = new org.apache.hadoop.conf.Configuration();
            hadoopConfig.addResource(new Path(configDir, "core-default.xml"));
            hadoopConfig.addResource(new Path(configDir, "core-site.xml"));
            hadoopConfig.reloadConfiguration();
            return hadoopConfig;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public GoogleCredentials loadStorageCredentialsFromFile(String credentialsPath) {
            try (FileInputStream credentialsStream = new FileInputStream(credentialsPath);){
                GoogleCredentials googleCredentials = GoogleCredentials.fromStream(credentialsStream);
                return googleCredentials;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

