/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.security.Closeable;
import io.grpc.xds.internal.security.trust.XdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executor;

@Internal
public abstract class SslContextProvider
implements Closeable {
    protected final EnvoyServerProtoData.BaseTlsContext tlsContext;

    protected SslContextProvider(EnvoyServerProtoData.BaseTlsContext tlsContext) {
        this.tlsContext = Preconditions.checkNotNull(tlsContext, "tlsContext");
    }

    protected CommonTlsContext getCommonTlsContext() {
        return this.tlsContext.getCommonTlsContext();
    }

    protected void setClientAuthValues(SslContextBuilder sslContextBuilder, XdsTrustManagerFactory xdsTrustManagerFactory) throws CertificateException, IOException, CertStoreException {
        EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext = this.getDownstreamTlsContext();
        if (xdsTrustManagerFactory != null) {
            sslContextBuilder.trustManager(xdsTrustManagerFactory);
            sslContextBuilder.clientAuth(downstreamTlsContext.isRequireClientCertificate() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL);
        } else {
            sslContextBuilder.clientAuth(ClientAuth.NONE);
        }
    }

    public EnvoyServerProtoData.DownstreamTlsContext getDownstreamTlsContext() {
        Preconditions.checkState(this.tlsContext instanceof EnvoyServerProtoData.DownstreamTlsContext, "expected DownstreamTlsContext");
        return (EnvoyServerProtoData.DownstreamTlsContext)this.tlsContext;
    }

    public EnvoyServerProtoData.UpstreamTlsContext getUpstreamTlsContext() {
        Preconditions.checkState(this.tlsContext instanceof EnvoyServerProtoData.UpstreamTlsContext, "expected UpstreamTlsContext");
        return (EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext;
    }

    @Override
    public abstract void close();

    public abstract void addCallback(Callback var1);

    protected final void performCallback(final SslContextGetter sslContextGetter, final Callback callback) {
        Preconditions.checkNotNull(sslContextGetter, "sslContextGetter");
        Preconditions.checkNotNull(callback, "callback");
        callback.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SslContext sslContext = sslContextGetter.get();
                    callback.updateSecret(sslContext);
                }
                catch (Throwable e) {
                    callback.onException(e);
                }
            }
        });
    }

    protected static interface SslContextGetter {
        public SslContext get() throws Exception;
    }

    @VisibleForTesting
    public static abstract class Callback {
        private final Executor executor;

        protected Callback(Executor executor) {
            this.executor = executor;
        }

        @VisibleForTesting
        public Executor getExecutor() {
            return this.executor;
        }

        @VisibleForTesting
        public abstract void updateSecret(SslContext var1);

        @VisibleForTesting
        protected abstract void onException(Throwable var1);
    }
}

