/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.google.storage.v2.ReadObjectRequest;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class StorageV2ProtoUtils {
    private static final String VALIDATION_TEMPLATE = "offset >= 0 && limit >= 0 (%s >= 0 && %s >= 0)";
    private static final JsonFormat.Printer PROTO_PRINTER = JsonFormat.printer().omittingInsignificantWhitespace().preservingProtoFieldNames();

    private StorageV2ProtoUtils() {
    }

    static @NonNull ReadObjectRequest seekReadObjectRequest(@NonNull ReadObjectRequest request, @Nullable Long offset, @Nullable Long limit) {
        boolean setLimit;
        StorageV2ProtoUtils.validate(offset, limit);
        ReadObjectRequest req = request;
        boolean setOffset = offset != null && (offset > 0L || offset.longValue() != req.getReadOffset());
        boolean bl = setLimit = limit != null && (limit < Long.MAX_VALUE || limit.longValue() != req.getReadLimit());
        if (setOffset || setLimit) {
            ReadObjectRequest.Builder b = req.toBuilder();
            if (setOffset) {
                b.setReadOffset(offset);
            }
            if (setLimit) {
                b.setReadLimit(limit);
            }
            req = b.build();
        }
        return req;
    }

    private static void validate(@Nullable Long offset, @Nullable Long limit) {
        boolean limitNull;
        boolean offsetNull = offset == null;
        boolean bl = limitNull = limit == null;
        if (offsetNull && limitNull) {
            return;
        }
        if (!offsetNull) {
            Preconditions.checkArgument(0L <= offset, VALIDATION_TEMPLATE, (Object)offset, (Object)limit);
        }
        if (!limitNull) {
            Preconditions.checkArgument(0L <= limit, VALIDATION_TEMPLATE, (Object)offset, (Object)limit);
        }
    }

    static @NonNull String fmtProto(@NonNull MessageOrBuilder msg) {
        try {
            return PROTO_PRINTER.print(msg);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }
}

