/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.Binding;
import com.google.cloud.Condition;
import com.google.cloud.Policy;
import com.google.cloud.StringEnumValue;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.Cors;
import com.google.cloud.storage.HmacKey;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.NotificationInfo;
import com.google.cloud.storage.Rpo;
import com.google.cloud.storage.ServiceAccount;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.Utils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.google.iam.v1.Binding;
import com.google.iam.v1.Policy;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.Timestamp;
import com.google.storage.v2.Bucket;
import com.google.storage.v2.BucketAccessControl;
import com.google.storage.v2.CryptoKeyName;
import com.google.storage.v2.CustomerEncryption;
import com.google.storage.v2.HmacKeyMetadata;
import com.google.storage.v2.Notification;
import com.google.storage.v2.Object;
import com.google.storage.v2.ObjectAccessControl;
import com.google.storage.v2.ObjectChecksums;
import com.google.storage.v2.Owner;
import com.google.type.Date;
import com.google.type.Expr;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class GrpcConversions {
    static final GrpcConversions INSTANCE = new GrpcConversions();
    private final Conversions.Codec<Acl.Entity, String> entityCodec = Conversions.Codec.of(this::entityEncode, this::entityDecode);
    private final Conversions.Codec<Acl, ObjectAccessControl> objectAclCodec = Conversions.Codec.of(this::objectAclEncode, this::objectAclDecode);
    private final Conversions.Codec<Acl, BucketAccessControl> bucketAclCodec = Conversions.Codec.of(this::bucketAclEncode, this::bucketAclDecode);
    private final Conversions.Codec<HmacKey.HmacKeyMetadata, HmacKeyMetadata> hmacKeyMetadataCodec = Conversions.Codec.of(this::hmacKeyMetadataEncode, this::hmacKeyMetadataDecode);
    private final Conversions.Codec<ServiceAccount, com.google.storage.v2.ServiceAccount> serviceAccountCodec = Conversions.Codec.of(this::serviceAccountEncode, this::serviceAccountDecode);
    private final Conversions.Codec<Cors, Bucket.Cors> corsCodec = Conversions.Codec.of(this::corsEncode, this::corsDecode);
    private final Conversions.Codec<BucketInfo.Logging, Bucket.Logging> loggingCodec = Conversions.Codec.of(this::loggingEncode, this::loggingDecode);
    private final Conversions.Codec<BucketInfo.IamConfiguration, Bucket.IamConfig> iamConfigurationCodec = Conversions.Codec.of(this::iamConfigEncode, this::iamConfigDecode);
    private final Conversions.Codec<BucketInfo.Autoclass, Bucket.Autoclass> autoclassCodec = Conversions.Codec.of(this::autoclassEncode, this::autoclassDecode);
    private final Conversions.Codec<BucketInfo.LifecycleRule, Bucket.Lifecycle.Rule> lifecycleRuleCodec = Conversions.Codec.of(this::lifecycleRuleEncode, this::lifecycleRuleDecode);
    private final Conversions.Codec<BucketInfo, Bucket> bucketInfoCodec = Conversions.Codec.of(this::bucketInfoEncode, this::bucketInfoDecode);
    private final Conversions.Codec<BlobInfo.CustomerEncryption, CustomerEncryption> customerEncryptionCodec = Conversions.Codec.of(this::customerEncryptionEncode, this::customerEncryptionDecode);
    private final Conversions.Codec<BlobId, Object> blobIdCodec = Conversions.Codec.of(this::blobIdEncode, this::blobIdDecode);
    private final Conversions.Codec<BlobInfo, Object> blobInfoCodec = Conversions.Codec.of(this::blobInfoEncode, this::blobInfoDecode);
    private final Conversions.Codec<NotificationInfo, Notification> notificationInfoCodec = Conversions.Codec.of(this::notificationEncode, this::notificationDecode);
    private final Conversions.Codec<Policy, com.google.iam.v1.Policy> policyCodec = Conversions.Codec.of(this::policyEncode, this::policyDecode);
    private final Conversions.Codec<Binding, com.google.iam.v1.Binding> bindingCodec = Conversions.Codec.of(this::bindingEncode, this::bindingDecode);
    private final Conversions.Codec<Condition, Expr> iamConditionCodec = Conversions.Codec.of(this::conditionEncode, this::conditionDecode);
    @VisibleForTesting
    final Conversions.Codec<OffsetDateTime, Timestamp> timestampCodec = Conversions.Codec.of(odt -> Timestamp.newBuilder().setSeconds(odt.toEpochSecond()).setNanos(odt.getNano()).build(), t -> Instant.ofEpochSecond(t.getSeconds()).plusNanos(t.getNanos()).atOffset(ZoneOffset.UTC));
    @VisibleForTesting
    final Conversions.Codec<OffsetDateTime, Date> odtDateCodec = Conversions.Codec.of(odt -> {
        OffsetDateTime utc = odt.withOffsetSameInstant(ZoneOffset.UTC);
        return Date.newBuilder().setYear(utc.getYear()).setMonth(utc.getMonthValue()).setDay(utc.getDayOfMonth()).build();
    }, d -> LocalDate.of(d.getYear(), d.getMonth(), d.getDay()).atStartOfDay().atOffset(ZoneOffset.UTC));

    private GrpcConversions() {
    }

    Conversions.Codec<Acl.Entity, String> entity() {
        return this.entityCodec;
    }

    Conversions.Codec<Acl, ObjectAccessControl> objectAcl() {
        return this.objectAclCodec;
    }

    Conversions.Codec<Acl, BucketAccessControl> bucketAcl() {
        return this.bucketAclCodec;
    }

    Conversions.Codec<HmacKey.HmacKeyMetadata, HmacKeyMetadata> hmacKeyMetadata() {
        return this.hmacKeyMetadataCodec;
    }

    Conversions.Codec<ServiceAccount, com.google.storage.v2.ServiceAccount> serviceAccount() {
        return this.serviceAccountCodec;
    }

    Conversions.Codec<Cors, Bucket.Cors> cors() {
        return this.corsCodec;
    }

    Conversions.Codec<BucketInfo.Logging, Bucket.Logging> logging() {
        return this.loggingCodec;
    }

    Conversions.Codec<BucketInfo.IamConfiguration, Bucket.IamConfig> iamConfiguration() {
        return this.iamConfigurationCodec;
    }

    Conversions.Codec<BucketInfo.LifecycleRule, Bucket.Lifecycle.Rule> lifecycleRule() {
        return this.lifecycleRuleCodec;
    }

    Conversions.Codec<BucketInfo, Bucket> bucketInfo() {
        return this.bucketInfoCodec;
    }

    Conversions.Codec<BlobInfo.CustomerEncryption, CustomerEncryption> customerEncryption() {
        return this.customerEncryptionCodec;
    }

    Conversions.Codec<BlobId, Object> blobId() {
        return this.blobIdCodec;
    }

    Conversions.Codec<BlobInfo, Object> blobInfo() {
        return this.blobInfoCodec;
    }

    Conversions.Codec<NotificationInfo, Notification> notificationInfo() {
        return this.notificationInfoCodec;
    }

    Conversions.Codec<Policy, com.google.iam.v1.Policy> policyCodec() {
        return this.policyCodec;
    }

    private BucketInfo bucketInfoDecode(Bucket from) {
        List<BucketAccessControl> bucketAclList;
        List<ObjectAccessControl> defaultObjectAclList;
        List<Bucket.Cors> corsList;
        BucketInfo.BuilderImpl to = new BucketInfo.BuilderImpl((String)Utils.bucketNameCodec.decode(from.getName()));
        ((BucketInfo.Builder)to).setProject(from.getProject());
        ((BucketInfo.Builder)to).setGeneratedId(from.getBucketId());
        if (from.hasRetentionPolicy()) {
            Bucket.RetentionPolicy retentionPolicy = from.getRetentionPolicy();
            ((BucketInfo.Builder)to).setRetentionPolicyIsLocked(retentionPolicy.getIsLocked());
            if (retentionPolicy.hasRetentionPeriod()) {
                ((BucketInfo.Builder)to).setRetentionPeriodDuration((Duration)Utils.durationSecondsCodec.decode(retentionPolicy.getRetentionPeriod()));
            }
            if (retentionPolicy.hasEffectiveTime()) {
                ((BucketInfo.Builder)to).setRetentionEffectiveTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(retentionPolicy.getEffectiveTime()));
            }
        }
        Utils.ifNonNull(from.getLocation(), to::setLocation);
        Utils.ifNonNull(from.getLocationType(), to::setLocationType);
        Utils.ifNonNull(from.getMetageneration(), to::setMetageneration);
        if (from.hasBilling()) {
            Bucket.Billing billing = from.getBilling();
            ((BucketInfo.Builder)to).setRequesterPays(billing.getRequesterPays());
        }
        if (from.hasCreateTime()) {
            ((BucketInfo.Builder)to).setCreateTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getCreateTime()));
        }
        if (from.hasUpdateTime()) {
            ((BucketInfo.Builder)to).setUpdateTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getUpdateTime()));
        }
        if (from.hasEncryption()) {
            ((BucketInfo.Builder)to).setDefaultKmsKeyName(from.getEncryption().getDefaultKmsKey());
        }
        if (!from.getRpo().isEmpty()) {
            ((BucketInfo.Builder)to).setRpo(Rpo.valueOf(from.getRpo()));
        }
        if (!from.getStorageClass().isEmpty()) {
            ((BucketInfo.Builder)to).setStorageClass(StorageClass.valueOf(from.getStorageClass()));
        }
        if (from.hasVersioning()) {
            ((BucketInfo.Builder)to).setVersioningEnabled(from.getVersioning().getEnabled());
        }
        Utils.ifNonNull(from.getDefaultEventBasedHold(), to::setDefaultEventBasedHold);
        Map<String, String> labelsMap = from.getLabelsMap();
        if (!labelsMap.isEmpty()) {
            ((BucketInfo.Builder)to).setLabels(labelsMap);
        }
        if (from.hasWebsite()) {
            String notFoundPage;
            Bucket.Website website = from.getWebsite();
            String mainPageSuffix = website.getMainPageSuffix();
            if (!mainPageSuffix.isEmpty()) {
                ((BucketInfo.Builder)to).setIndexPage(mainPageSuffix);
            }
            if (!(notFoundPage = website.getNotFoundPage()).isEmpty()) {
                ((BucketInfo.Builder)to).setNotFoundPage(notFoundPage);
            }
        }
        if (from.hasLifecycle()) {
            ((BucketInfo.Builder)to).setLifecycleRules((Iterable<? extends BucketInfo.LifecycleRule>)Utils.toImmutableListOf(this.lifecycleRuleCodec::decode).apply(from.getLifecycle().getRuleList()));
        }
        if (!(corsList = from.getCorsList()).isEmpty()) {
            ((BucketInfo.Builder)to).setCors((Iterable<Cors>)Utils.toImmutableListOf(this.corsCodec::decode).apply(corsList));
        }
        if (from.hasLogging()) {
            ((BucketInfo.Builder)to).setLogging((BucketInfo.Logging)this.loggingCodec.decode(from.getLogging()));
        }
        if (from.hasOwner()) {
            ((BucketInfo.Builder)to).setOwner((Acl.Entity)this.entityCodec.decode(from.getOwner().getEntity()));
        }
        if (!(defaultObjectAclList = from.getDefaultObjectAclList()).isEmpty()) {
            ((BucketInfo.Builder)to).setDefaultAcl((Iterable<Acl>)Utils.toImmutableListOf(this.objectAclCodec::decode).apply(defaultObjectAclList));
        }
        if (!(bucketAclList = from.getAclList()).isEmpty()) {
            ((BucketInfo.Builder)to).setAcl((Iterable<Acl>)Utils.toImmutableListOf(this.bucketAclCodec::decode).apply(bucketAclList));
        }
        if (from.hasIamConfig()) {
            ((BucketInfo.Builder)to).setIamConfiguration((BucketInfo.IamConfiguration)this.iamConfigurationCodec.decode(from.getIamConfig()));
        }
        if (from.hasAutoclass()) {
            ((BucketInfo.Builder)to).setAutoclass((BucketInfo.Autoclass)this.autoclassCodec.decode(from.getAutoclass()));
        }
        if (from.hasCustomPlacementConfig()) {
            Bucket.CustomPlacementConfig customPlacementConfig = from.getCustomPlacementConfig();
            ((BucketInfo.Builder)to).setCustomPlacementConfig(BucketInfo.CustomPlacementConfig.newBuilder().setDataLocations(customPlacementConfig.getDataLocationsList()).build());
        }
        if (!from.getEtag().isEmpty()) {
            ((BucketInfo.Builder)to).setEtag(from.getEtag());
        }
        return ((BucketInfo.Builder)to).build();
    }

    private Bucket bucketInfoEncode(BucketInfo from) {
        Bucket.Builder to = Bucket.newBuilder();
        to.setName((String)Utils.bucketNameCodec.encode(from.getName()));
        Utils.ifNonNull(from.getGeneratedId(), to::setBucketId);
        if (from.getRetentionPeriodDuration() != null) {
            Bucket.RetentionPolicy.Builder retentionPolicyBuilder = to.getRetentionPolicyBuilder();
            Utils.ifNonNull(from.getRetentionPeriodDuration(), Utils.durationSecondsCodec::encode, retentionPolicyBuilder::setRetentionPeriod);
            Utils.ifNonNull(from.retentionPolicyIsLocked(), retentionPolicyBuilder::setIsLocked);
            if (from.retentionPolicyIsLocked() == Boolean.TRUE) {
                Utils.ifNonNull(from.getRetentionEffectiveTimeOffsetDateTime(), this.timestampCodec::encode, retentionPolicyBuilder::setEffectiveTime);
            }
            to.setRetentionPolicy(retentionPolicyBuilder.build());
        }
        Utils.ifNonNull(from.getLocation(), to::setLocation);
        Utils.ifNonNull(from.getLocationType(), to::setLocationType);
        Utils.ifNonNull(from.getMetageneration(), to::setMetageneration);
        if (from.requesterPays() != null) {
            Bucket.Billing.Builder billingBuilder = Bucket.Billing.newBuilder();
            Utils.ifNonNull(from.requesterPays(), billingBuilder::setRequesterPays);
            to.setBilling(billingBuilder.build());
        }
        Utils.ifNonNull(from.getCreateTimeOffsetDateTime(), this.timestampCodec::encode, to::setCreateTime);
        Utils.ifNonNull(from.getUpdateTimeOffsetDateTime(), this.timestampCodec::encode, to::setUpdateTime);
        if (from.getDefaultKmsKeyName() != null) {
            Bucket.Encryption.Builder encryptionBuilder = Bucket.Encryption.newBuilder();
            Utils.ifNonNull(from.getDefaultKmsKeyName(), encryptionBuilder::setDefaultKmsKey);
            to.setEncryption(encryptionBuilder.build());
        }
        if (from.getIndexPage() != null || from.getNotFoundPage() != null) {
            Bucket.Website.Builder websiteBuilder = Bucket.Website.newBuilder();
            Utils.ifNonNull(from.getIndexPage(), websiteBuilder::setMainPageSuffix);
            Utils.ifNonNull(from.getNotFoundPage(), websiteBuilder::setNotFoundPage);
            to.setWebsite(websiteBuilder.build());
        }
        Utils.ifNonNull(from.getRpo(), StringEnumValue::toString, to::setRpo);
        Utils.ifNonNull(from.getStorageClass(), StringEnumValue::toString, to::setStorageClass);
        if (from.versioningEnabled() != null) {
            Bucket.Versioning.Builder versioningBuilder = Bucket.Versioning.newBuilder();
            Utils.ifNonNull(from.versioningEnabled(), versioningBuilder::setEnabled);
            to.setVersioning(versioningBuilder.build());
        }
        Utils.ifNonNull(from.getDefaultEventBasedHold(), to::setDefaultEventBasedHold);
        Utils.ifNonNull(from.getLabels(), to::putAllLabels);
        List<BucketInfo.LifecycleRule> lifecycleRules = from.lifecycleRules;
        if (lifecycleRules != null) {
            Bucket.Lifecycle.Builder lifecycleBuilder = Bucket.Lifecycle.newBuilder();
            if (!lifecycleRules.isEmpty()) {
                ImmutableSet set = from.getLifecycleRules().stream().map(this.lifecycleRuleCodec::encode).collect(ImmutableSet.toImmutableSet());
                lifecycleBuilder.addAllRule(ImmutableList.copyOf(set));
            }
            to.setLifecycle(lifecycleBuilder.build());
        }
        Utils.ifNonNull(from.getLogging(), this.loggingCodec::encode, to::setLogging);
        Utils.ifNonNull(from.getCors(), Utils.toImmutableListOf(this.corsCodec::encode), to::addAllCors);
        Utils.ifNonNull(from.getOwner(), Utils.lift(this.entity()::encode).andThen(o -> Owner.newBuilder().setEntity((String)o).build()), to::setOwner);
        Utils.ifNonNull(from.getDefaultAcl(), Utils.toImmutableListOf(this.objectAclCodec::encode), to::addAllDefaultObjectAcl);
        Utils.ifNonNull(from.getAcl(), Utils.toImmutableListOf(this.bucketAclCodec::encode), to::addAllAcl);
        Utils.ifNonNull(from.getIamConfiguration(), this.iamConfigurationCodec::encode, to::setIamConfig);
        Utils.ifNonNull(from.getAutoclass(), this.autoclassCodec::encode, to::setAutoclass);
        BucketInfo.CustomPlacementConfig customPlacementConfig = from.getCustomPlacementConfig();
        if (customPlacementConfig != null && customPlacementConfig.getDataLocations() != null) {
            to.setCustomPlacementConfig(Bucket.CustomPlacementConfig.newBuilder().addAllDataLocations(customPlacementConfig.getDataLocations()).build());
        }
        Utils.ifNonNull(from.getEtag(), to::setEtag);
        return to.build();
    }

    private Bucket.Logging loggingEncode(BucketInfo.Logging from) {
        Bucket.Logging.Builder to = Bucket.Logging.newBuilder();
        if (from.getLogObjectPrefix() != null && !from.getLogObjectPrefix().isEmpty()) {
            to.setLogObjectPrefix(from.getLogObjectPrefix());
        }
        Utils.ifNonNull(from.getLogBucket(), Utils.bucketNameCodec::encode, to::setLogBucket);
        return to.build();
    }

    private BucketInfo.Logging loggingDecode(Bucket.Logging from) {
        String logBucket;
        BucketInfo.Logging.Builder to = BucketInfo.Logging.newBuilder();
        String logObjectPrefix = from.getLogObjectPrefix();
        if (!logObjectPrefix.isEmpty()) {
            to.setLogObjectPrefix(logObjectPrefix);
        }
        if (!(logBucket = from.getLogBucket()).isEmpty()) {
            to.setLogBucket((String)Utils.bucketNameCodec.decode(logBucket));
        }
        return to.build();
    }

    private Bucket.Cors corsEncode(Cors from) {
        Bucket.Cors.Builder to = Bucket.Cors.newBuilder();
        to.setMaxAgeSeconds(from.getMaxAgeSeconds());
        to.addAllResponseHeader(from.getResponseHeaders());
        Utils.ifNonNull(from.getMethods(), Utils.toImmutableListOf(java.lang.Object::toString), to::addAllMethod);
        Utils.ifNonNull(from.getOrigins(), Utils.toImmutableListOf(java.lang.Object::toString), to::addAllOrigin);
        return to.build();
    }

    private Cors corsDecode(Bucket.Cors from) {
        Cors.Builder to = Cors.newBuilder().setMaxAgeSeconds(from.getMaxAgeSeconds());
        Utils.ifNonNull(from.getMethodList(), m3 -> m3.stream().map(String::toUpperCase).map(HttpMethod::valueOf).collect(ImmutableList.toImmutableList()), to::setMethods);
        Utils.ifNonNull(from.getOriginList(), Utils.toImmutableListOf(Cors.Origin::of), to::setOrigins);
        to.setResponseHeaders(from.getResponseHeaderList());
        return to.build();
    }

    private String entityEncode(Acl.Entity from) {
        if (from instanceof Acl.RawEntity) {
            return from.getValue();
        }
        if (from instanceof Acl.User) {
            switch (from.getValue()) {
                case "allAuthenticatedUsers": {
                    return "allAuthenticatedUsers";
                }
                case "allUsers": {
                    return "allUsers";
                }
            }
        }
        return from.getType().name().toLowerCase() + "-" + from.getValue();
    }

    private Acl.Entity entityDecode(String from) {
        if (from.startsWith("user-")) {
            return new Acl.User(from.substring(5));
        }
        if (from.equals("allUsers")) {
            return Acl.User.ofAllUsers();
        }
        if (from.equals("allAuthenticatedUsers")) {
            return Acl.User.ofAllAuthenticatedUsers();
        }
        if (from.startsWith("group-")) {
            return new Acl.Group(from.substring(6));
        }
        if (from.startsWith("domain-")) {
            return new Acl.Domain(from.substring(7));
        }
        if (from.startsWith("project-")) {
            int idx = from.indexOf(45, 8);
            String team = from.substring(8, idx);
            String projectId = from.substring(idx + 1);
            return new Acl.Project(Acl.Project.ProjectRole.valueOf(team.toUpperCase()), projectId);
        }
        return new Acl.RawEntity(from);
    }

    private Acl objectAclDecode(ObjectAccessControl from) {
        Acl.Role role = Acl.Role.valueOf(from.getRole());
        Acl.Entity entity = (Acl.Entity)this.entityCodec.decode(from.getEntity());
        Acl.Builder to = Acl.newBuilder(entity, role).setId(from.getId());
        if (!from.getEtag().isEmpty()) {
            to.setEtag(from.getEtag());
        }
        return to.build();
    }

    private ObjectAccessControl objectAclEncode(Acl from) {
        ObjectAccessControl.Builder to = ObjectAccessControl.newBuilder();
        Utils.ifNonNull(from.getEntity(), this.entityCodec::encode, to::setEntity);
        Utils.ifNonNull(from.getRole(), StringEnumValue::name, to::setRole);
        Utils.ifNonNull(from.getId(), to::setId);
        Utils.ifNonNull(from.getEtag(), to::setEtag);
        return to.build();
    }

    private Acl bucketAclDecode(BucketAccessControl from) {
        Acl.Role role = Acl.Role.valueOf(from.getRole());
        Acl.Entity entity = this.entityDecode(from.getEntity());
        Acl.Builder to = Acl.newBuilder(entity, role).setId(from.getId());
        if (!from.getEtag().isEmpty()) {
            to.setEtag(from.getEtag());
        }
        return to.build();
    }

    private BucketAccessControl bucketAclEncode(Acl from) {
        BucketAccessControl.Builder to = BucketAccessControl.newBuilder().setEntity(from.getEntity().toString()).setRole(from.getRole().toString()).setId(from.getId());
        Utils.ifNonNull(from.getEtag(), to::setEtag);
        return to.build();
    }

    private Bucket.IamConfig.UniformBucketLevelAccess ublaEncode(BucketInfo.IamConfiguration from) {
        Bucket.IamConfig.UniformBucketLevelAccess.Builder to = Bucket.IamConfig.UniformBucketLevelAccess.newBuilder();
        to.setEnabled(from.isUniformBucketLevelAccessEnabled());
        if (from.isUniformBucketLevelAccessEnabled() == Boolean.TRUE) {
            Utils.ifNonNull(from.getUniformBucketLevelAccessLockedTimeOffsetDateTime(), this.timestampCodec::encode, to::setLockTime);
        }
        return to.build();
    }

    private BucketInfo.Autoclass autoclassDecode(Bucket.Autoclass from) {
        BucketInfo.Autoclass.Builder to = BucketInfo.Autoclass.newBuilder();
        to.setEnabled(from.getEnabled());
        Utils.ifNonNull(from.getToggleTime(), this.timestampCodec::decode, to::setToggleTime);
        return to.build();
    }

    private Bucket.Autoclass autoclassEncode(BucketInfo.Autoclass from) {
        Bucket.Autoclass.Builder to = Bucket.Autoclass.newBuilder();
        Utils.ifNonNull(from.getEnabled(), to::setEnabled);
        Utils.ifNonNull(from.getToggleTime(), this.timestampCodec::encode, to::setToggleTime);
        return to.build();
    }

    private Bucket.IamConfig iamConfigEncode(BucketInfo.IamConfiguration from) {
        Bucket.IamConfig.Builder to = Bucket.IamConfig.newBuilder();
        to.setUniformBucketLevelAccess(this.ublaEncode(from));
        if (from.getPublicAccessPrevention() != null) {
            Utils.ifNonNull(from.getPublicAccessPrevention().getValue(), to::setPublicAccessPrevention);
        }
        return to.build();
    }

    private BucketInfo.IamConfiguration iamConfigDecode(Bucket.IamConfig from) {
        Bucket.IamConfig.UniformBucketLevelAccess ubla = from.getUniformBucketLevelAccess();
        BucketInfo.IamConfiguration.Builder to = BucketInfo.IamConfiguration.newBuilder();
        Utils.ifNonNull(ubla.getEnabled(), to::setIsUniformBucketLevelAccessEnabled);
        if (ubla.hasLockTime()) {
            to.setUniformBucketLevelAccessLockedTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(ubla.getLockTime()));
        }
        if (!from.getPublicAccessPrevention().isEmpty()) {
            to.setPublicAccessPrevention(BucketInfo.PublicAccessPrevention.parse(from.getPublicAccessPrevention()));
        }
        return to.build();
    }

    private Bucket.Lifecycle.Rule lifecycleRuleEncode(BucketInfo.LifecycleRule from) {
        Bucket.Lifecycle.Rule.Builder to = Bucket.Lifecycle.Rule.newBuilder();
        to.setAction(this.ruleActionEncode(from.getAction()));
        to.setCondition(this.ruleConditionEncode(from.getCondition()));
        return to.build();
    }

    private Bucket.Lifecycle.Rule.Condition ruleConditionEncode(BucketInfo.LifecycleRule.LifecycleCondition from) {
        Bucket.Lifecycle.Rule.Condition.Builder to = Bucket.Lifecycle.Rule.Condition.newBuilder();
        if (from.getAge() != null) {
            to.setAgeDays(from.getAge());
        }
        if (from.getIsLive() != null) {
            to.setIsLive(from.getIsLive());
        }
        if (from.getNumberOfNewerVersions() != null) {
            to.setNumNewerVersions(from.getNumberOfNewerVersions());
        }
        if (from.getDaysSinceNoncurrentTime() != null) {
            to.setDaysSinceNoncurrentTime(from.getDaysSinceNoncurrentTime());
        }
        if (from.getDaysSinceCustomTime() != null) {
            to.setDaysSinceCustomTime(from.getDaysSinceCustomTime());
        }
        Utils.ifNonNull(from.getCreatedBeforeOffsetDateTime(), this.odtDateCodec::encode, to::setCreatedBefore);
        Utils.ifNonNull(from.getNoncurrentTimeBeforeOffsetDateTime(), this.odtDateCodec::encode, to::setNoncurrentTimeBefore);
        Utils.ifNonNull(from.getCustomTimeBeforeOffsetDateTime(), this.odtDateCodec::encode, to::setCustomTimeBefore);
        Utils.ifNonNull(from.getMatchesStorageClass(), Utils.toImmutableListOf(StringEnumValue::toString), to::addAllMatchesStorageClass);
        Utils.ifNonNull(from.getMatchesPrefix(), to::addAllMatchesPrefix);
        Utils.ifNonNull(from.getMatchesSuffix(), to::addAllMatchesSuffix);
        return to.build();
    }

    private Bucket.Lifecycle.Rule.Action ruleActionEncode(BucketInfo.LifecycleRule.LifecycleAction from) {
        Bucket.Lifecycle.Rule.Action.Builder to = Bucket.Lifecycle.Rule.Action.newBuilder().setType(from.getActionType());
        if (from.getActionType().equals("SetStorageClass")) {
            to.setStorageClass(((BucketInfo.LifecycleRule.SetStorageClassLifecycleAction)from).getStorageClass().toString());
        }
        return to.build();
    }

    private BucketInfo.LifecycleRule lifecycleRuleDecode(Bucket.Lifecycle.Rule from) {
        BucketInfo.LifecycleRule.LifecycleAction lifecycleAction;
        Bucket.Lifecycle.Rule.Action action = from.getAction();
        switch (action.getType()) {
            case "Delete": {
                lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newDeleteAction();
                break;
            }
            case "SetStorageClass": {
                lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newSetStorageClassAction(StorageClass.valueOf(action.getStorageClass()));
                break;
            }
            case "AbortIncompleteMultipartUpload": {
                lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newAbortIncompleteMPUploadAction();
                break;
            }
            default: {
                BucketInfo.log.warning("The lifecycle action " + action.getType() + " is not supported by this version of the library. Attempting to update with this rule may cause errors. Please update to the latest version of google-cloud-storage.");
                lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newLifecycleAction("Unknown action");
            }
        }
        Bucket.Lifecycle.Rule.Condition condition = from.getCondition();
        BucketInfo.LifecycleRule.LifecycleCondition.Builder conditionBuilder = BucketInfo.LifecycleRule.LifecycleCondition.newBuilder();
        if (condition.hasAgeDays()) {
            conditionBuilder.setAge(condition.getAgeDays());
        }
        if (condition.hasCreatedBefore()) {
            conditionBuilder.setCreatedBeforeOffsetDateTime((OffsetDateTime)this.odtDateCodec.nullable().decode(condition.getCreatedBefore()));
        }
        if (condition.hasIsLive()) {
            conditionBuilder.setIsLive(condition.getIsLive());
        }
        if (condition.hasNumNewerVersions()) {
            conditionBuilder.setNumberOfNewerVersions(condition.getNumNewerVersions());
        }
        if (condition.hasDaysSinceNoncurrentTime()) {
            conditionBuilder.setDaysSinceNoncurrentTime(condition.getDaysSinceNoncurrentTime());
        }
        if (condition.hasNoncurrentTimeBefore()) {
            conditionBuilder.setNoncurrentTimeBeforeOffsetDateTime((OffsetDateTime)this.odtDateCodec.decode(condition.getNoncurrentTimeBefore()));
        }
        if (condition.hasCustomTimeBefore()) {
            conditionBuilder.setCustomTimeBeforeOffsetDateTime((OffsetDateTime)this.odtDateCodec.decode(condition.getCustomTimeBefore()));
        }
        if (condition.hasDaysSinceCustomTime()) {
            conditionBuilder.setDaysSinceCustomTime(condition.getDaysSinceCustomTime());
        }
        if (!condition.getMatchesStorageClassList().isEmpty()) {
            ImmutableList<StorageClass> collect = condition.getMatchesStorageClassList().stream().map(StorageClass::valueOf).collect(ImmutableList.toImmutableList());
            conditionBuilder.setMatchesStorageClass(collect);
        }
        conditionBuilder.setMatchesPrefix(condition.getMatchesPrefixList());
        conditionBuilder.setMatchesSuffix(condition.getMatchesSuffixList());
        return new BucketInfo.LifecycleRule(lifecycleAction, conditionBuilder.build());
    }

    private HmacKeyMetadata hmacKeyMetadataEncode(HmacKey.HmacKeyMetadata from) {
        HmacKeyMetadata.Builder to = HmacKeyMetadata.newBuilder();
        Utils.ifNonNull(from.getEtag(), to::setEtag);
        Utils.ifNonNull(from.getId(), to::setId);
        Utils.ifNonNull(from.getAccessId(), to::setAccessId);
        Utils.ifNonNull(from.getProjectId(), Utils.projectNameCodec::encode, to::setProject);
        Utils.ifNonNull(from.getServiceAccount(), ServiceAccount::getEmail, to::setServiceAccountEmail);
        Utils.ifNonNull(from.getState(), Enum::name, to::setState);
        Utils.ifNonNull(from.getCreateTimeOffsetDateTime(), this.timestampCodec::encode, to::setCreateTime);
        Utils.ifNonNull(from.getUpdateTimeOffsetDateTime(), this.timestampCodec::encode, to::setUpdateTime);
        return to.build();
    }

    private HmacKey.HmacKeyMetadata hmacKeyMetadataDecode(HmacKeyMetadata from) {
        HmacKey.HmacKeyMetadata.Builder to = HmacKey.HmacKeyMetadata.newBuilder(ServiceAccount.of(from.getServiceAccountEmail())).setAccessId(from.getAccessId()).setCreateTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getCreateTime())).setId(from.getId()).setProjectId((String)Utils.projectNameCodec.decode(from.getProject())).setState(HmacKey.HmacKeyState.valueOf(from.getState())).setUpdateTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getUpdateTime()));
        if (!from.getEtag().isEmpty()) {
            to.setEtag(from.getEtag());
        }
        return to.build();
    }

    private com.google.storage.v2.ServiceAccount serviceAccountEncode(ServiceAccount from) {
        return com.google.storage.v2.ServiceAccount.newBuilder().setEmailAddress(from.getEmail()).build();
    }

    private ServiceAccount serviceAccountDecode(com.google.storage.v2.ServiceAccount from) {
        return ServiceAccount.of(from.getEmailAddress());
    }

    private CustomerEncryption customerEncryptionEncode(BlobInfo.CustomerEncryption from) {
        return CustomerEncryption.newBuilder().setEncryptionAlgorithm(from.getEncryptionAlgorithm()).setKeySha256Bytes(ByteString.copyFrom(BaseEncoding.base64().decode(from.getKeySha256()))).build();
    }

    private BlobInfo.CustomerEncryption customerEncryptionDecode(CustomerEncryption from) {
        return new BlobInfo.CustomerEncryption(from.getEncryptionAlgorithm(), BaseEncoding.base64().encode(from.getKeySha256Bytes().toByteArray()));
    }

    private Object blobIdEncode(BlobId from) {
        Object.Builder to = Object.newBuilder();
        Utils.ifNonNull(from.getBucket(), Utils.bucketNameCodec::encode, to::setBucket);
        Utils.ifNonNull(from.getName(), to::setName);
        Utils.ifNonNull(from.getGeneration(), to::setGeneration);
        return to.build();
    }

    private BlobId blobIdDecode(Object from) {
        String bucketName = (String)Utils.bucketNameCodec.decode(from.getBucket());
        return BlobId.of(bucketName, from.getName(), from.getGeneration());
    }

    private Object blobInfoEncode(BlobInfo from) {
        Object.Builder toBuilder = Object.newBuilder();
        Utils.ifNonNull(from.getBucket(), Utils.bucketNameCodec::encode, toBuilder::setBucket);
        Utils.ifNonNull(from.getName(), toBuilder::setName);
        Utils.ifNonNull(from.getGeneration(), toBuilder::setGeneration);
        Utils.ifNonNull(from.getCacheControl(), toBuilder::setCacheControl);
        Utils.ifNonNull(from.getSize(), toBuilder::setSize);
        Utils.ifNonNull(from.getContentType(), toBuilder::setContentType);
        Utils.ifNonNull(from.getContentEncoding(), toBuilder::setContentEncoding);
        Utils.ifNonNull(from.getContentDisposition(), toBuilder::setContentDisposition);
        Utils.ifNonNull(from.getContentLanguage(), toBuilder::setContentLanguage);
        Utils.ifNonNull(from.getComponentCount(), toBuilder::setComponentCount);
        if (from.getMd5() != null || from.getCrc32c() != null) {
            ObjectChecksums.Builder objectChecksums = ObjectChecksums.newBuilder();
            if (from.getMd5() != null) {
                objectChecksums.setMd5Hash(ByteString.copyFrom(BaseEncoding.base64().decode(from.getMd5())));
            }
            if (from.getCrc32c() != null) {
                objectChecksums.setCrc32C((Integer)Utils.crc32cCodec.decode(from.getCrc32c()));
            }
            toBuilder.setChecksums(objectChecksums.build());
        }
        Utils.ifNonNull(from.getMetageneration(), toBuilder::setMetageneration);
        Utils.ifNonNull(from.getDeleteTimeOffsetDateTime(), this.timestampCodec::encode, toBuilder::setDeleteTime);
        Utils.ifNonNull(from.getUpdateTimeOffsetDateTime(), this.timestampCodec::encode, toBuilder::setUpdateTime);
        Utils.ifNonNull(from.getCreateTimeOffsetDateTime(), this.timestampCodec::encode, toBuilder::setCreateTime);
        Utils.ifNonNull(from.getCustomTimeOffsetDateTime(), this.timestampCodec::encode, toBuilder::setCustomTime);
        Utils.ifNonNull(from.getCustomerEncryption(), this.customerEncryptionCodec::encode, toBuilder::setCustomerEncryption);
        Utils.ifNonNull(from.getStorageClass(), StringEnumValue::toString, toBuilder::setStorageClass);
        Utils.ifNonNull(from.getTimeStorageClassUpdatedOffsetDateTime(), this.timestampCodec::encode, toBuilder::setUpdateStorageClassTime);
        Utils.ifNonNull(from.getKmsKeyName(), this::removeKmsVersion, toBuilder::setKmsKey);
        Utils.ifNonNull(from.getEventBasedHold(), toBuilder::setEventBasedHold);
        Utils.ifNonNull(from.getTemporaryHold(), toBuilder::setTemporaryHold);
        Utils.ifNonNull(from.getRetentionExpirationTimeOffsetDateTime(), this.timestampCodec::encode, toBuilder::setRetentionExpireTime);
        Utils.ifNonNull(from.getEtag(), toBuilder::setEtag);
        Acl.Entity entity = from.getOwner();
        if (entity != null) {
            toBuilder.setOwner(Owner.newBuilder().setEntity(this.entityEncode(entity)).build());
        }
        Utils.ifNonNull(from.getMetadata(), this::removeNullValues, toBuilder::putAllMetadata);
        Utils.ifNonNull(from.getAcl(), Utils.toImmutableListOf(this.objectAcl()::encode), toBuilder::addAllAcl);
        return toBuilder.build();
    }

    private BlobInfo blobInfoDecode(Object from) {
        Owner owner;
        String storageClass;
        BlobInfo.Builder toBuilder = BlobInfo.newBuilder(BlobId.of((String)Utils.bucketNameCodec.decode(from.getBucket()), from.getName(), from.getGeneration()));
        Utils.ifNonNull(from.getCacheControl(), toBuilder::setCacheControl);
        Utils.ifNonNull(from.getSize(), toBuilder::setSize);
        Utils.ifNonNull(from.getContentType(), toBuilder::setContentType);
        Utils.ifNonNull(from.getContentEncoding(), toBuilder::setContentEncoding);
        Utils.ifNonNull(from.getContentDisposition(), toBuilder::setContentDisposition);
        Utils.ifNonNull(from.getContentLanguage(), toBuilder::setContentLanguage);
        Utils.ifNonNull(from.getComponentCount(), toBuilder::setComponentCount);
        if (from.hasChecksums()) {
            ByteString md5Hash;
            ObjectChecksums checksums = from.getChecksums();
            if (checksums.hasCrc32C()) {
                toBuilder.setCrc32c((String)Utils.crc32cCodec.encode(checksums.getCrc32C()));
            }
            if (!(md5Hash = checksums.getMd5Hash()).isEmpty()) {
                toBuilder.setMd5(BaseEncoding.base64().encode(md5Hash.toByteArray()));
            }
        }
        Utils.ifNonNull(from.getMetageneration(), toBuilder::setMetageneration);
        if (from.hasDeleteTime()) {
            toBuilder.setDeleteTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getDeleteTime()));
        }
        if (from.hasUpdateTime()) {
            toBuilder.setUpdateTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getUpdateTime()));
        }
        if (from.hasCreateTime()) {
            toBuilder.setCreateTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getCreateTime()));
        }
        if (from.hasCustomTime()) {
            toBuilder.setCustomTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getCustomTime()));
        }
        if (from.hasCustomerEncryption()) {
            toBuilder.setCustomerEncryption((BlobInfo.CustomerEncryption)this.customerEncryptionCodec.decode(from.getCustomerEncryption()));
        }
        if (!(storageClass = from.getStorageClass()).isEmpty()) {
            toBuilder.setStorageClass(StorageClass.valueOf(storageClass));
        }
        if (from.hasUpdateStorageClassTime()) {
            toBuilder.setTimeStorageClassUpdatedOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getUpdateStorageClassTime()));
        }
        if (!from.getKmsKey().isEmpty()) {
            toBuilder.setKmsKeyName(from.getKmsKey());
        }
        if (from.hasEventBasedHold()) {
            toBuilder.setEventBasedHold(from.getEventBasedHold());
        }
        toBuilder.setTemporaryHold(from.getTemporaryHold());
        if (from.hasRetentionExpireTime()) {
            toBuilder.setRetentionExpirationTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getRetentionExpireTime()));
        }
        if (!from.getMetadataMap().isEmpty()) {
            toBuilder.setMetadata(from.getMetadataMap());
        }
        if (from.hasOwner() && !(owner = from.getOwner()).getEntity().isEmpty()) {
            toBuilder.setOwner(this.entityDecode(owner.getEntity()));
        }
        if (!from.getEtag().isEmpty()) {
            toBuilder.setEtag(from.getEtag());
        }
        Utils.ifNonNull(from.getAclList(), Utils.toImmutableListOf(this.objectAcl()::decode), toBuilder::setAcl);
        return toBuilder.build();
    }

    private Notification notificationEncode(NotificationInfo from) {
        return (Notification)GrpcConversions.todo();
    }

    private NotificationInfo notificationDecode(Notification from) {
        return (NotificationInfo)GrpcConversions.todo();
    }

    private com.google.iam.v1.Policy policyEncode(Policy from) {
        Policy.Builder to = com.google.iam.v1.Policy.newBuilder();
        Utils.ifNonNull(from.getEtag(), ByteString::copyFromUtf8, to::setEtag);
        Utils.ifNonNull(from.getVersion(), to::setVersion);
        from.getBindingsList().stream().map(this.bindingCodec::encode).forEach(to::addBindings);
        return to.build();
    }

    private Policy policyDecode(com.google.iam.v1.Policy from) {
        Policy.Builder to = Policy.newBuilder();
        ByteString etag = from.getEtag();
        if (!etag.isEmpty()) {
            to.setEtag(etag.toStringUtf8());
        }
        to.setVersion(from.getVersion());
        List<com.google.iam.v1.Binding> bindingsList = from.getBindingsList();
        if (!bindingsList.isEmpty()) {
            ImmutableList<Binding> bindings = bindingsList.stream().map(this.bindingCodec::decode).collect(ImmutableList.toImmutableList());
            to.setBindings(bindings);
        }
        return to.build();
    }

    private com.google.iam.v1.Binding bindingEncode(Binding from) {
        Binding.Builder to = com.google.iam.v1.Binding.newBuilder();
        Utils.ifNonNull(from.getRole(), to::setRole);
        ImmutableList<String> members = from.getMembers();
        if (!members.isEmpty()) {
            to.addAllMembers(members);
        }
        Utils.ifNonNull(from.getCondition(), this.iamConditionCodec::encode, to::setCondition);
        return to.build();
    }

    private Binding bindingDecode(com.google.iam.v1.Binding from) {
        ProtocolStringList membersList;
        Binding.Builder to = Binding.newBuilder();
        String role = from.getRole();
        if (!role.isEmpty()) {
            to.setRole(role);
        }
        if (!(membersList = from.getMembersList()).isEmpty()) {
            to.setMembers(membersList);
        }
        if (from.hasCondition()) {
            to.setCondition((Condition)this.iamConditionCodec.decode(from.getCondition()));
        }
        return to.build();
    }

    private Expr conditionEncode(Condition from) {
        Expr.Builder to = Expr.newBuilder();
        Utils.ifNonNull(from.getExpression(), to::setExpression);
        Utils.ifNonNull(from.getTitle(), to::setTitle);
        Utils.ifNonNull(from.getDescription(), to::setDescription);
        return to.build();
    }

    private Condition conditionDecode(Expr from) {
        String description;
        String title;
        Condition.Builder to = Condition.newBuilder();
        String expression = from.getExpression();
        if (!expression.isEmpty()) {
            to.setExpression(expression);
        }
        if (!(title = from.getTitle()).isEmpty()) {
            to.setTitle(title);
        }
        if (!(description = from.getDescription()).isEmpty()) {
            to.setDescription(description);
        }
        return to.build();
    }

    private Map<String, String> removeNullValues(Map<String, String> from) {
        HashMap<String, String> to = new HashMap<String, String>(from);
        to.values().removeAll(Collections.singleton(null));
        return to;
    }

    private String removeKmsVersion(String from) {
        PathTemplate versionedKmsTemplate = PathTemplate.createWithoutUrlEncoding("projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{version}");
        if (versionedKmsTemplate.matches(from)) {
            Map<String, String> res = versionedKmsTemplate.match(from);
            return CryptoKeyName.format(res.get("project"), res.get("location"), res.get("key_ring"), res.get("crypto_key"));
        }
        return from;
    }

    private static <T> T todo() {
        throw new IllegalStateException("Not yet implemented");
    }
}

