/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.ReadChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedReadableByteChannelSession;
import com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageV2ProtoUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

final class GrpcBlobReadChannel
implements ReadChannel {
    private final LazyReadChannel lazyReadChannel = new LazyReadChannel(() -> {
        ReadObjectRequest req = StorageV2ProtoUtils.seekReadObjectRequest(request, this.position, GrpcBlobReadChannel.sub(this.limit, this.position));
        return ResumableMedia.gapic().read().byteChannel(read).setHasher(Hasher.noop()).setAutoGzipDecompression(autoGzipDecompression).buffered(BufferHandle.allocate(this.chunkSize)).setReadObjectRequest(req).build();
    });
    private Long position;
    private Long limit;
    private int chunkSize = 0x1000000;

    GrpcBlobReadChannel(ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read, ReadObjectRequest request, boolean autoGzipDecompression) {
    }

    @Override
    public void setChunkSize(int chunkSize) {
        Preconditions.checkState(!this.isOpen(), "Unable to change chunkSize after read");
        this.chunkSize = chunkSize;
    }

    @Override
    public boolean isOpen() {
        return this.lazyReadChannel.isOpen() && this.lazyReadChannel.getChannel().isOpen();
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            try {
                this.lazyReadChannel.getChannel().close();
            }
            catch (IOException e) {
                throw StorageException.coalesce(e);
            }
        }
    }

    @Override
    public void seek(long position) throws IOException {
        Preconditions.checkArgument(position >= 0L, "position must be >= 0");
        Preconditions.checkState(!this.isOpen(), "Unable to change position after read");
        this.position = position;
    }

    @Override
    public RestorableState<ReadChannel> capture() {
        return (RestorableState)GrpcStorageImpl.throwHttpJsonOnly(ReadChannel.class, "capture");
    }

    @Override
    public ReadChannel limit(long limit) {
        Preconditions.checkArgument(limit >= 0L, "limit must be >= 0");
        Preconditions.checkState(!this.isOpen(), "Unable to change limit after read");
        this.limit = limit;
        return this;
    }

    @Override
    public long limit() {
        return this.limit != null ? this.limit : Long.MAX_VALUE;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        Long diff = GrpcBlobReadChannel.sub(this.limit, this.position);
        if (diff != null && diff <= 0L) {
            this.close();
            return -1;
        }
        try {
            return this.lazyReadChannel.getChannel().read(dst);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(StorageException.coalesce(e));
        }
    }

    ApiFuture<com.google.storage.v2.Object> getResults() {
        return ((BufferedReadableByteChannelSession)this.lazyReadChannel.session.get()).getResult();
    }

    private static @Nullable Long sub(@Nullable Long l, @Nullable Long r) {
        if (l == null || r == null) {
            return null;
        }
        return l - r;
    }

    private static final class LazyReadChannel {
        private final Supplier<BufferedReadableByteChannelSession<com.google.storage.v2.Object>> session;
        private final Supplier<BufferedReadableByteChannelSession.BufferedReadableByteChannel> channel;
        private boolean open = false;

        public LazyReadChannel(Supplier<BufferedReadableByteChannelSession<com.google.storage.v2.Object>> session) {
            this.session = session;
            this.channel = Suppliers.memoize(() -> {
                this.open = true;
                return (BufferedReadableByteChannelSession.BufferedReadableByteChannel)((BufferedReadableByteChannelSession)session.get()).open();
            });
        }

        public BufferedReadableByteChannelSession.BufferedReadableByteChannel getChannel() {
            return this.channel.get();
        }

        public boolean isOpen() {
            return this.open;
        }
    }
}

