/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.SettableApiFuture;
import com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.storage.WriteCtx;
import com.google.cloud.storage.WriteFlushStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.ObjectChecksums;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;

final class GapicUnbufferedWritableByteChannel<RequestFactoryT extends WriteCtx.WriteObjectRequestBuilderFactory>
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final SettableApiFuture<WriteObjectResponse> resultFuture;
    private final ChunkSegmenter chunkSegmenter;
    private final WriteCtx<RequestFactoryT> writeCtx;
    private final WriteFlushStrategy.Flusher flusher;
    private boolean open = true;
    private boolean finished = false;

    GapicUnbufferedWritableByteChannel(SettableApiFuture<WriteObjectResponse> resultFuture, ChunkSegmenter chunkSegmenter, RequestFactoryT requestFactory, WriteFlushStrategy.FlusherFactory flusherFactory) {
        this.resultFuture = resultFuture;
        this.chunkSegmenter = chunkSegmenter;
        this.writeCtx = new WriteCtx<RequestFactoryT>(requestFactory);
        this.flusher = flusherFactory.newFlusher(requestFactory.bucketName(), this.writeCtx.getConfirmedBytes()::set, resultFuture::set);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return Math.toIntExact(this.write(new ByteBuffer[]{src}));
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public long write(ByteBuffer[] srcs, int srcsOffset, int srcLength) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        ChunkSegmenter.ChunkSegment[] data = this.chunkSegmenter.segmentBuffers(srcs, srcsOffset, srcLength);
        ArrayList<WriteObjectRequest> messages = new ArrayList<WriteObjectRequest>();
        int bytesConsumed = 0;
        for (ChunkSegmenter.ChunkSegment datum : data) {
            Crc32cValue.Crc32cLengthKnown crc32c = datum.getCrc32c();
            ByteString b = datum.getB();
            int contentSize = b.size();
            long offset = this.writeCtx.getTotalSentBytes().getAndAdd(contentSize);
            Crc32cValue.Crc32cLengthKnown cumulative = this.writeCtx.getCumulativeCrc32c().accumulateAndGet(crc32c, this.chunkSegmenter.getHasher()::nullSafeConcat);
            ChecksummedData.Builder checksummedData = ChecksummedData.newBuilder().setContent(b);
            if (crc32c != null) {
                checksummedData.setCrc32C(crc32c.getValue());
            }
            WriteObjectRequest.Builder builder = this.writeCtx.newRequestBuilder().setWriteOffset(offset).setChecksummedData(checksummedData.build());
            if (!datum.isOnlyFullBlocks()) {
                builder.setFinishWrite(true);
                if (cumulative != null) {
                    builder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(cumulative.getValue()).build());
                }
                this.finished = true;
            }
            WriteObjectRequest build = builder.build();
            messages.add(build);
            bytesConsumed += contentSize;
        }
        try {
            this.flusher.flush(messages);
        }
        catch (RuntimeException e) {
            this.resultFuture.setException(e);
            throw e;
        }
        return bytesConsumed;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (!this.finished) {
            long offset = this.writeCtx.getTotalSentBytes().get();
            Crc32cValue.Crc32cLengthKnown crc32cValue = this.writeCtx.getCumulativeCrc32c().get();
            WriteObjectRequest.Builder b = this.writeCtx.newRequestBuilder().setFinishWrite(true).setWriteOffset(offset);
            if (crc32cValue != null) {
                b.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(crc32cValue.getValue()).build());
            }
            WriteObjectRequest message = b.build();
            try {
                this.flusher.close(message);
                this.finished = true;
            }
            catch (RuntimeException e) {
                this.resultFuture.setException(e);
                throw e;
            }
        } else {
            this.flusher.close(null);
        }
        this.open = false;
    }

    @VisibleForTesting
    WriteCtx<RequestFactoryT> getWriteCtx() {
        return this.writeCtx;
    }
}

