/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;

public final class BlobId
implements Serializable {
    private static final long serialVersionUID = 8201580858265557469L;
    private final String bucket;
    private final String name;
    private final Long generation;

    private BlobId(String bucket, String name, Long generation) {
        this.bucket = bucket;
        this.name = name;
        this.generation = generation;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getName() {
        return this.name;
    }

    public Long getGeneration() {
        return this.generation;
    }

    public String toGsUtilUri() {
        return "gs://" + this.bucket + "/" + this.name;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("bucket", this.getBucket()).add("name", this.getName()).add("generation", this.getGeneration()).toString();
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.name, this.generation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(BlobId.class)) {
            return false;
        }
        BlobId other = (BlobId)obj;
        return Objects.equals(this.bucket, other.bucket) && Objects.equals(this.name, other.name) && Objects.equals(this.generation, other.generation);
    }

    public static BlobId of(String bucket, String name) {
        return new BlobId(Preconditions.checkNotNull(bucket), Preconditions.checkNotNull(name), null);
    }

    public static BlobId of(String bucket, String name, Long generation) {
        return new BlobId(Preconditions.checkNotNull(bucket), Preconditions.checkNotNull(name), generation);
    }

    public static BlobId fromGsUtilUri(String gsUtilUri) {
        if (!Pattern.matches("gs://.*/.*", gsUtilUri)) {
            throw new IllegalArgumentException(gsUtilUri + " is not a valid gsutil URI (i.e. \"gs://bucket/blob\")");
        }
        int blobNameStartIndex = gsUtilUri.indexOf(47, 5);
        String bucketName = gsUtilUri.substring(5, blobNameStartIndex);
        String blobName = gsUtilUri.substring(blobNameStartIndex + 1);
        return BlobId.of(bucketName, blobName);
    }
}

