/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFunction;
import com.google.cloud.StringEnumType;
import com.google.cloud.StringEnumValue;
import com.google.cloud.storage.Conversions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class Acl
implements Serializable {
    private static final long serialVersionUID = -1000021464049679956L;
    private final Entity entity;
    private final Role role;
    private final String id;
    private final String etag;

    private Acl(Builder builder) {
        this.entity = Preconditions.checkNotNull(builder.entity);
        this.role = Preconditions.checkNotNull(builder.role);
        this.id = builder.id;
        this.etag = builder.etag;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Role getRole() {
        return this.role;
    }

    public String getId() {
        return this.id;
    }

    public String getEtag() {
        return this.etag;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Acl of(Entity entity, Role role) {
        return Acl.newBuilder(entity, role).build();
    }

    public static Builder newBuilder(Entity entity, Role role) {
        return new Builder(entity, role);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("entity", this.entity).add("role", this.role).add("etag", this.etag).add("id", this.id).toString();
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.role);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Acl other = (Acl)obj;
        return Objects.equals(this.entity, other.entity) && Objects.equals(this.role, other.role) && Objects.equals(this.etag, other.etag) && Objects.equals(this.id, other.id);
    }

    public static final class RawEntity
    extends Entity {
        private static final long serialVersionUID = -3049252571732490102L;

        RawEntity(String entity) {
            super(Entity.Type.UNKNOWN, entity);
        }
    }

    public static final class Project
    extends Entity {
        private static final long serialVersionUID = -743189540406339074L;
        private final ProjectRole projectRole;
        private final String projectId;

        public Project(ProjectRole projectRole, String projectId) {
            super(Entity.Type.PROJECT, projectRole.name().toLowerCase() + "-" + projectId);
            this.projectRole = projectRole;
            this.projectId = projectId;
        }

        public ProjectRole getProjectRole() {
            return this.projectRole;
        }

        public String getProjectId() {
            return this.projectId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Project)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Project project = (Project)o;
            return Objects.equals(this.projectRole, project.projectRole) && Objects.equals(this.projectId, project.projectId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.projectRole, this.projectId);
        }

        public static final class ProjectRole
        extends StringEnumValue {
            private static final long serialVersionUID = 1284991422168016498L;
            private static final ApiFunction<String, ProjectRole> CONSTRUCTOR = ProjectRole::new;
            private static final StringEnumType<ProjectRole> type = new StringEnumType<ProjectRole>(ProjectRole.class, CONSTRUCTOR);
            public static final ProjectRole OWNERS = type.createAndRegister("OWNERS");
            public static final ProjectRole EDITORS = type.createAndRegister("EDITORS");
            public static final ProjectRole VIEWERS = type.createAndRegister("VIEWERS");

            private ProjectRole(String constant) {
                super(constant);
            }

            public static ProjectRole valueOfStrict(String constant) {
                return type.valueOfStrict(constant);
            }

            public static ProjectRole valueOf(String constant) {
                return type.valueOf(constant);
            }

            public static ProjectRole[] values() {
                return type.values();
            }
        }
    }

    public static final class User
    extends Entity {
        private static final long serialVersionUID = -4113630416489429660L;
        static final String ALL_USERS = "allUsers";
        static final String ALL_AUTHENTICATED_USERS = "allAuthenticatedUsers";

        public User(String email) {
            super(Entity.Type.USER, email);
        }

        public String getEmail() {
            return this.getValue();
        }

        public static User ofAllUsers() {
            return new User(ALL_USERS);
        }

        public static User ofAllAuthenticatedUsers() {
            return new User(ALL_AUTHENTICATED_USERS);
        }
    }

    public static final class Group
    extends Entity {
        private static final long serialVersionUID = 5642929747944714384L;

        public Group(String email) {
            super(Entity.Type.GROUP, email);
        }

        public String getEmail() {
            return this.getValue();
        }
    }

    public static final class Domain
    extends Entity {
        private static final long serialVersionUID = 6852649665598880139L;

        public Domain(String domain) {
            super(Entity.Type.DOMAIN, domain);
        }

        public String getDomain() {
            return this.getValue();
        }
    }

    public static abstract class Entity
    implements Serializable {
        private static final long serialVersionUID = 2321254094152522444L;
        private final Type type;
        private final String value;

        Entity(Type type, String value) {
            this.type = type;
            this.value = value;
        }

        public Type getType() {
            return this.type;
        }

        protected String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Entity entity = (Entity)obj;
            return Objects.equals((Object)this.type, (Object)entity.type) && Objects.equals(this.value, entity.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.value});
        }

        public String toString() {
            return (String)Conversions.apiary().entity().encode(this);
        }

        public static enum Type {
            DOMAIN,
            GROUP,
            USER,
            PROJECT,
            UNKNOWN;

        }
    }

    public static class Builder {
        private Entity entity;
        private Role role;
        private String id;
        private String etag;

        private Builder(Entity entity, Role role) {
            this.entity = entity;
            this.role = role;
        }

        private Builder(Acl acl) {
            this.entity = acl.entity;
            this.role = acl.role;
            this.id = acl.id;
            this.etag = acl.etag;
        }

        public Builder setEntity(Entity entity) {
            this.entity = entity;
            return this;
        }

        public Builder setRole(Role role) {
            this.role = role;
            return this;
        }

        Builder setId(String id) {
            this.id = id;
            return this;
        }

        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        public Acl build() {
            return new Acl(this);
        }
    }

    public static final class Role
    extends StringEnumValue {
        private static final long serialVersionUID = 2067949416720207403L;
        private static final ApiFunction<String, Role> CONSTRUCTOR = Role::new;
        private static final StringEnumType<Role> type = new StringEnumType<Role>(Role.class, CONSTRUCTOR);
        public static final Role OWNER = type.createAndRegister("OWNER");
        public static final Role READER = type.createAndRegister("READER");
        public static final Role WRITER = type.createAndRegister("WRITER");

        private Role(String constant) {
            super(constant);
        }

        public static Role valueOfStrict(String constant) {
            return type.valueOfStrict(constant);
        }

        public static Role valueOf(String constant) {
            return type.valueOf(constant);
        }

        public static Role[] values() {
            return type.values();
        }
    }
}

