/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auto.value.AutoBuilder;
import com.google.cloud.NoCredentials;
import com.google.cloud.hadoop.gcsio.AutoBuilder_GoogleCloudStorageClientImpl_Builder;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientWriteChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.util.AccessBoundary;
import com.google.cloud.hadoop.util.ErrorTypeExtractor;
import com.google.cloud.hadoop.util.GrpcErrorTypeExtractor;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import javax.annotation.Nullable;

@VisibleForTesting
public class GoogleCloudStorageClientImpl
extends ForwardingGoogleCloudStorage {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final GoogleCloudStorageOptions storageOptions;
    private final Storage storage;
    private static final ErrorTypeExtractor errorExtractor = GrpcErrorTypeExtractor.INSTANCE;
    private ExecutorService backgroundTasksThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcsio-storage-client-write-channel-pool-%d").setDaemon(true).build());

    GoogleCloudStorageClientImpl(GoogleCloudStorageOptions options, @Nullable Storage clientLibraryStorage, @Nullable Credentials credentials, @Nullable Credential credential, @Nullable com.google.api.services.storage.Storage apiaryClientStorage, @Nullable HttpRequestInitializer httpRequestInitializer, @Nullable Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        super(GoogleCloudStorageClientImpl.getDelegate(httpRequestInitializer, apiaryClientStorage, options, credentials, credential, downscopedAccessTokenFn));
        this.storageOptions = options;
        this.storage = clientLibraryStorage == null ? GoogleCloudStorageClientImpl.createStorage(credentials, options) : clientLibraryStorage;
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("create(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        StorageResourceId resourceIdWithGeneration = resourceId;
        if (!resourceId.hasGenerationId()) {
            resourceIdWithGeneration = new StorageResourceId(resourceId.getBucketName(), resourceId.getObjectName(), this.getWriteGeneration(resourceId, options.isOverwriteExisting()));
        }
        GoogleCloudStorageClientWriteChannel channel = new GoogleCloudStorageClientWriteChannel(this.storage, this.storageOptions, resourceIdWithGeneration, options, this.backgroundTasksThreadPool);
        channel.initialize();
        return channel;
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(%s, %s)", (Object)resourceId, (Object)readOptions);
        return this.open(resourceId, null, readOptions);
    }

    private SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        return new GoogleCloudStorageClientReadChannel(this.storage, itemInfo == null ? this.getItemInfo(resourceId) : itemInfo, readOptions, errorExtractor, this.storageOptions);
    }

    @Override
    public void close() {
        try {
            try {
                super.close();
            }
            finally {
                this.backgroundTasksThreadPool.shutdown();
            }
        }
        finally {
            this.backgroundTasksThreadPool = null;
        }
    }

    private long getWriteGeneration(StorageResourceId resourceId, boolean overwrite) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getWriteGeneration(%s, %s)", (Object)resourceId, overwrite);
        GoogleCloudStorageItemInfo info = this.getItemInfo(resourceId);
        if (!info.exists()) {
            return 0L;
        }
        if (info.exists() && overwrite) {
            long generation = info.getContentGeneration();
            Preconditions.checkState(generation != 0L, "Generation should not be 0 for an existing item");
            return generation;
        }
        throw new FileAlreadyExistsException(String.format("Object %s already exists.", resourceId));
    }

    private static GoogleCloudStorage getDelegate(HttpRequestInitializer httpRequestInitializer, com.google.api.services.storage.Storage storage, GoogleCloudStorageOptions storageOptions, Credentials credentials, Credential credential, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        if (httpRequestInitializer != null) {
            ((GoogleLogger.Api)logger.atWarning()).log("Overriding httpRequestInitializer. ALERT: Use this only for testing");
            return new GoogleCloudStorageImpl(storageOptions, httpRequestInitializer, downscopedAccessTokenFn);
        }
        if (storage != null) {
            ((GoogleLogger.Api)logger.atWarning()).log("Overriding storage. ALERT: Use this only for testing");
            return new GoogleCloudStorageImpl(storageOptions, storage, credentials, downscopedAccessTokenFn);
        }
        return new GoogleCloudStorageImpl(storageOptions, credential);
    }

    private static Storage createStorage(Credentials credentials, GoogleCloudStorageOptions storageOptions) {
        return (Storage)StorageOptions.grpc().setAttemptDirectPath(storageOptions.isDirectPathPreferred()).setHeaderProvider(() -> storageOptions.getHttpRequestHeaders()).setCredentials(credentials != null ? credentials : NoCredentials.getInstance()).build().getService();
    }

    public static Builder builder() {
        return new AutoBuilder_GoogleCloudStorageClientImpl_Builder();
    }

    @AutoBuilder(ofClass=GoogleCloudStorageClientImpl.class)
    public static abstract class Builder {
        public abstract Builder setOptions(GoogleCloudStorageOptions var1);

        public abstract Builder setCredentials(@Nullable Credentials var1);

        public abstract Builder setCredential(@Nullable Credential var1);

        public abstract Builder setApiaryClientStorage(@Nullable com.google.api.services.storage.Storage var1);

        @VisibleForTesting
        public abstract Builder setHttpRequestInitializer(@Nullable HttpRequestInitializer var1);

        public abstract Builder setDownscopedAccessTokenFn(@Nullable Function<List<AccessBoundary>, String> var1);

        @VisibleForTesting
        public abstract Builder setClientLibraryStorage(@Nullable Storage var1);

        public abstract GoogleCloudStorageClientImpl build() throws IOException;
    }
}

