/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.flogger.GoogleLogger;
import com.google.common.flogger.LazyArgs;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;

class GoogleHadoopFSInputStream
extends FSInputStream {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    @VisibleForTesting
    static final String READ_METHOD = "gcsFSRead";
    @VisibleForTesting
    static final String POSITIONAL_READ_METHOD = "gcsFSReadPositional";
    @VisibleForTesting
    static final String SEEK_METHOD = "gcsFSSeek";
    @VisibleForTesting
    static final String CLOSE_METHOD = "gcsFSClose";
    @VisibleForTesting
    static final String DURATION_NS = "durationNs";
    @VisibleForTesting
    static final String BYTES_READ = "bytesRead";
    @VisibleForTesting
    static final String GCS_PATH = "gcsPath";
    @VisibleForTesting
    static final String METHOD = "method";
    @VisibleForTesting
    static final String POSITION = "position";
    @VisibleForTesting
    static final String LENGTH = "length";
    @VisibleForTesting
    static final String OFFSET = "offset";
    private static final Gson gson = new Gson();
    private final boolean isTraceLoggingEnabled;
    private final SeekableByteChannel channel;
    private URI gcsPath;
    private long totalBytesRead;
    private final FileSystem.Statistics statistics;
    private final byte[] singleReadBuf = new byte[1];

    GoogleHadoopFSInputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, GoogleCloudStorageReadOptions readOptions, FileSystem.Statistics statistics) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("GoogleHadoopFSInputStream(gcsPath: %s, readOptions: %s)", (Object)gcsPath, (Object)readOptions);
        this.gcsPath = gcsPath;
        this.statistics = statistics;
        this.totalBytesRead = 0L;
        this.isTraceLoggingEnabled = readOptions.isTraceLogEnabled();
        this.channel = ghfs.getGcsFs().open(gcsPath, readOptions);
    }

    @Override
    public synchronized int read() throws IOException {
        int numRead = this.channel.read(ByteBuffer.wrap(this.singleReadBuf));
        if (numRead == -1) {
            return -1;
        }
        if (numRead != 1) {
            throw new IOException(String.format("Somehow read %d bytes using single-byte buffer for path %s ending in position %d!", numRead, this.gcsPath, this.channel.position()));
        }
        byte b = this.singleReadBuf[0];
        ++this.totalBytesRead;
        this.statistics.incrementBytesRead(1L);
        this.statistics.incrementReadOps(1);
        return b & 0xFF;
    }

    @Override
    public synchronized int read(byte[] buf, int offset, int length) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Preconditions.checkNotNull(buf, "buf must not be null");
        if (offset < 0 || length < 0 || length > buf.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        int numRead = this.channel.read(ByteBuffer.wrap(buf, offset, length));
        this.readAPITrace(READ_METHOD, stopwatch, 0L, offset, length, numRead);
        if (numRead > 0) {
            this.statistics.incrementBytesRead(numRead);
            this.statistics.incrementReadOps(1);
            this.totalBytesRead += (long)numRead;
        }
        return numRead;
    }

    @Override
    public synchronized int read(long position, byte[] buf, int offset, int length) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int result = super.read(position, buf, offset, length);
        this.readAPITrace(POSITIONAL_READ_METHOD, stopwatch, position, offset, length, result);
        if (result > 0) {
            this.statistics.incrementBytesRead(result);
            this.totalBytesRead += (long)result;
        }
        return result;
    }

    @Override
    public synchronized long getPos() throws IOException {
        long pos = this.channel.position();
        ((GoogleLogger.Api)logger.atFiner()).log("getPos(): %d", pos);
        return pos;
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("seek(%d)", pos);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.channel.position(pos);
            this.seekAPITrace(SEEK_METHOD, stopwatch, pos);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    @Override
    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    @Override
    public synchronized void close() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("close(): %s", this.gcsPath);
        Stopwatch stopwatch = Stopwatch.createStarted();
        HashMap apiTraces = new HashMap();
        if (this.channel != null) {
            ((GoogleLogger.Api)logger.atFiner()).log("Closing '%s' file with %d total bytes read", (Object)this.gcsPath, this.totalBytesRead);
            this.channel.close();
            this.closeAPITrace(CLOSE_METHOD, stopwatch);
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        return super.available();
    }

    private void readAPITrace(String method, Stopwatch stopwatch, long position, int offset, int length, int bytesRead) {
        if (this.isTraceLoggingEnabled) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put(METHOD, method);
            jsonMap.put(GCS_PATH, this.gcsPath);
            jsonMap.put(DURATION_NS, stopwatch.elapsed(TimeUnit.NANOSECONDS));
            jsonMap.put(POSITION, position);
            jsonMap.put(OFFSET, offset);
            jsonMap.put(LENGTH, length);
            jsonMap.put(BYTES_READ, bytesRead);
            this.captureAPITraces(jsonMap);
        }
    }

    private void seekAPITrace(String method, Stopwatch stopwatch, long pos) {
        if (this.isTraceLoggingEnabled) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put(METHOD, method);
            jsonMap.put(GCS_PATH, this.gcsPath);
            jsonMap.put(DURATION_NS, stopwatch.elapsed(TimeUnit.NANOSECONDS));
            jsonMap.put(POSITION, pos);
            this.captureAPITraces(jsonMap);
        }
    }

    private void closeAPITrace(String method, Stopwatch stopwatch) {
        if (this.isTraceLoggingEnabled) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put(METHOD, method);
            jsonMap.put(GCS_PATH, this.gcsPath);
            jsonMap.put(DURATION_NS, stopwatch.elapsed(TimeUnit.NANOSECONDS));
            this.captureAPITraces(jsonMap);
        }
    }

    private void captureAPITraces(Map<String, Object> apiTraces) {
        if (this.isTraceLoggingEnabled) {
            ((GoogleLogger.Api)logger.atInfo()).log("%s", LazyArgs.lazy(() -> gson.toJson(apiTraces)));
        }
    }
}

