/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GhfsStatistic;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageStatistics;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GhfsStorageStatistics
extends StorageStatistics {
    public static final String NAME = "GhfsStorageStatistics";
    private static final String MINIMUM = ".min";
    private static final String MAXIMUM = ".max";
    private static final String MEAN = ".max";
    private final Map<GhfsStatistic, AtomicLong> opsCount = new EnumMap<GhfsStatistic, AtomicLong>(GhfsStatistic.class);

    public GhfsStorageStatistics() {
        super(NAME);
        for (GhfsStatistic opType : GhfsStatistic.values()) {
            this.opsCount.put(opType, new AtomicLong(0L));
        }
    }

    public long incrementCounter(GhfsStatistic op, long count) {
        return this.opsCount.get((Object)op).addAndGet(count);
    }

    @Override
    public void reset() {
        for (AtomicLong value : this.opsCount.values()) {
            value.set(0L);
        }
    }

    @Override
    public Iterator<StorageStatistics.LongStatistic> getLongStatistics() {
        return new LongIterator();
    }

    @Override
    public Long getLong(String key) {
        GhfsStatistic type = GhfsStatistic.fromSymbol(key);
        return type == null ? null : Long.valueOf(this.opsCount.get((Object)type).get());
    }

    @Override
    public boolean isTracked(String key) {
        return GhfsStatistic.fromSymbol(key) == null;
    }

    public Long getMin(String symbol) {
        return 0L;
    }

    public Long getMax(String symbol) {
        return 0L;
    }

    public double getMean(String symbol) {
        return 0.0;
    }

    private Map<String, Long> minimums() {
        return null;
    }

    private Map<String, Long> maximums() {
        return null;
    }

    private class LongIterator
    implements Iterator<StorageStatistics.LongStatistic> {
        private Iterator<Map.Entry<GhfsStatistic, AtomicLong>> iterator;

        private LongIterator() {
            this.iterator = Collections.unmodifiableSet(GhfsStorageStatistics.this.opsCount.entrySet()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public StorageStatistics.LongStatistic next() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<GhfsStatistic, AtomicLong> entry = this.iterator.next();
            return new StorageStatistics.LongStatistic(entry.getKey().name(), entry.getValue().get());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

