/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.fs.RefCountedFileWithStream;
import org.apache.flink.core.fs.RefCountedTmpFileCreator;
import org.apache.flink.fs.osshadoop.OSSAccessor;
import org.apache.flink.fs.osshadoop.common.HadoopFileSystem;
import org.apache.flink.fs.osshadoop.writer.OSSRecoverableWriter;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.hadoop.fs.FileSystem;

public class FlinkOSSFileSystem
extends HadoopFileSystem {
    public static final long MULTIPART_UPLOAD_PART_SIZE_MIN = 0xA00000L;
    private long ossUploadPartSize;
    private int maxConcurrentUploadsPerStream;
    private final Executor uploadThreadPool;
    private String localTmpDir;
    private final FunctionWithException<File, RefCountedFileWithStream, IOException> cachedFileCreator;
    private OSSAccessor ossAccessor;

    public FlinkOSSFileSystem(FileSystem fileSystem, long ossUploadPartSize, int maxConcurrentUploadsPerStream, String localTmpDirectory, OSSAccessor ossAccessor) {
        super(fileSystem);
        Preconditions.checkArgument((ossUploadPartSize >= 0xA00000L ? 1 : 0) != 0);
        this.ossUploadPartSize = ossUploadPartSize;
        this.maxConcurrentUploadsPerStream = maxConcurrentUploadsPerStream;
        this.uploadThreadPool = Executors.newCachedThreadPool();
        this.localTmpDir = (String)Preconditions.checkNotNull((Object)localTmpDirectory);
        this.cachedFileCreator = RefCountedTmpFileCreator.inDirectories((File[])new File[]{new File(localTmpDirectory)});
        this.ossAccessor = ossAccessor;
    }

    @Override
    public FileSystemKind getKind() {
        return FileSystemKind.OBJECT_STORE;
    }

    @Override
    public RecoverableWriter createRecoverableWriter() throws IOException {
        return new OSSRecoverableWriter(this.ossAccessor, this.ossUploadPartSize, this.maxConcurrentUploadsPerStream, this.uploadThreadPool, this.cachedFileCreator);
    }

    public String getLocalTmpDir() {
        return this.localTmpDir;
    }
}

