/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.utils;

import com.aliyun.oss.ServiceException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogUtils {
    private static final Log log = LogFactory.getLog("com.aliyun.oss");
    private static List<String> errorCodeFilterList = new ArrayList<String>();

    public static Log getLog() {
        return log;
    }

    public static <ExType> void logException(String messagePrefix, ExType ex) {
        LogUtils.logException(messagePrefix, ex, true);
    }

    public static <ExType> void logException(String messagePrefix, ExType ex, boolean logEnabled) {
        assert (ex instanceof Exception);
        String detailMessage = messagePrefix + ((Exception)ex).getMessage();
        if (ex instanceof ServiceException && errorCodeFilterList.contains(((ServiceException)ex).getErrorCode())) {
            if (logEnabled) {
                log.debug(detailMessage);
            }
        } else if (logEnabled) {
            log.warn(detailMessage);
        }
    }

    static {
        errorCodeFilterList.add("NoSuchBucket");
        errorCodeFilterList.add("NoSuchKey");
        errorCodeFilterList.add("NoSuchUpload");
        errorCodeFilterList.add("NoSuchCORSConfiguration");
        errorCodeFilterList.add("NoSuchWebsiteConfiguration");
        errorCodeFilterList.add("NoSuchLifecycle");
    }
}

