/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.clustering;

import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.examples.java.clustering.util.KMeansData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMeans {
    private static final Logger LOGGER = LoggerFactory.getLogger(KMeans.class);

    public static void main(String[] args) throws Exception {
        LOGGER.warn("All Flink DataSet APIs are deprecated since Flink 1.18 and will be removed in a future Flink major version. You can still build your application in DataSet, but you should move to either the DataStream and/or Table API. This class is retained for testing purposes. See Also: https://cwiki.apache.org/confluence/pages/viewpage.action?pageId=158866741");
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        DataSet<Point> points = KMeans.getPointDataSet(params, env);
        DataSet<Centroid> centroids = KMeans.getCentroidDataSet(params, env);
        IterativeDataSet loop = centroids.iterate(params.getInt("iterations", 10));
        MapOperator newCentroids = ((MapOperator)points.map((MapFunction)new SelectNearestCenter()).withBroadcastSet((DataSet)loop, "centroids")).map((MapFunction)new CountAppender()).groupBy(new int[]{0}).reduce((ReduceFunction)new CentroidAccumulator()).map((MapFunction)new CentroidAverager());
        DataSet finalCentroids = loop.closeWith((DataSet)newCentroids);
        SingleInputUdfOperator clusteredPoints = points.map((MapFunction)new SelectNearestCenter()).withBroadcastSet(finalCentroids, "centroids");
        if (params.has("output")) {
            clusteredPoints.writeAsCsv(params.get("output"), "\n", " ");
            env.execute("KMeans Example");
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            clusteredPoints.print();
        }
    }

    private static DataSet<Centroid> getCentroidDataSet(ParameterTool params, ExecutionEnvironment env) {
        DataSource centroids;
        if (params.has("centroids")) {
            centroids = env.readCsvFile(params.get("centroids")).fieldDelimiter(" ").pojoType(Centroid.class, new String[]{"id", "x", "y"});
        } else {
            System.out.println("Executing K-Means example with default centroid data set.");
            System.out.println("Use --centroids to specify file input.");
            centroids = KMeansData.getDefaultCentroidDataSet(env);
        }
        return centroids;
    }

    private static DataSet<Point> getPointDataSet(ParameterTool params, ExecutionEnvironment env) {
        DataSource points;
        if (params.has("points")) {
            points = env.readCsvFile(params.get("points")).fieldDelimiter(" ").pojoType(Point.class, new String[]{"x", "y"});
        } else {
            System.out.println("Executing K-Means example with default point data set.");
            System.out.println("Use --points to specify file input.");
            points = KMeansData.getDefaultPointDataSet(env);
        }
        return points;
    }

    @FunctionAnnotation.ForwardedFields(value={"0->id"})
    public static final class CentroidAverager
    implements MapFunction<Tuple3<Integer, Point, Long>, Centroid> {
        public Centroid map(Tuple3<Integer, Point, Long> value) {
            return new Centroid((Integer)value.f0, ((Point)value.f1).div((Long)value.f2));
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    public static final class CentroidAccumulator
    implements ReduceFunction<Tuple3<Integer, Point, Long>> {
        public Tuple3<Integer, Point, Long> reduce(Tuple3<Integer, Point, Long> val1, Tuple3<Integer, Point, Long> val2) {
            return new Tuple3(val1.f0, (Object)((Point)val1.f1).add((Point)val2.f1), (Object)((Long)val1.f2 + (Long)val2.f2));
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0;f1"})
    public static final class CountAppender
    implements MapFunction<Tuple2<Integer, Point>, Tuple3<Integer, Point, Long>> {
        public Tuple3<Integer, Point, Long> map(Tuple2<Integer, Point> t) {
            return new Tuple3(t.f0, t.f1, (Object)1L);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->1"})
    public static final class SelectNearestCenter
    extends RichMapFunction<Point, Tuple2<Integer, Point>> {
        private Collection<Centroid> centroids;

        public void open(Configuration parameters) throws Exception {
            this.centroids = this.getRuntimeContext().getBroadcastVariable("centroids");
        }

        public Tuple2<Integer, Point> map(Point p) throws Exception {
            double minDistance = Double.MAX_VALUE;
            int closestCentroidId = -1;
            for (Centroid centroid : this.centroids) {
                double distance = p.euclideanDistance(centroid);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                closestCentroidId = centroid.id;
            }
            return new Tuple2((Object)closestCentroidId, (Object)p);
        }
    }

    public static class Centroid
    extends Point {
        public int id;

        public Centroid() {
        }

        public Centroid(int id, double x, double y) {
            super(x, y);
            this.id = id;
        }

        public Centroid(int id, Point p) {
            super(p.x, p.y);
            this.id = id;
        }

        @Override
        public String toString() {
            return this.id + " " + super.toString();
        }
    }

    public static class Point
    implements Serializable {
        public double x;
        public double y;

        public Point() {
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public Point add(Point other) {
            this.x += other.x;
            this.y += other.y;
            return this;
        }

        public Point div(long val) {
            this.x /= (double)val;
            this.y /= (double)val;
            return this;
        }

        public double euclideanDistance(Point other) {
            return Math.sqrt((this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y));
        }

        public void clear() {
            this.y = 0.0;
            this.x = 0.0;
        }

        public String toString() {
            return this.x + " " + this.y;
        }
    }
}

