/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.open.example;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import java.io.IOException;
import java.util.Iterator;

public class WordCount {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: WordCount <in_table> <out_table>");
            System.exit(2);
        }
        JobConf job = new JobConf();
        job.setMapperClass(TokenizerMapper.class);
        job.setCombinerClass(SumCombiner.class);
        job.setReducerClass(SumReducer.class);
        job.setMapOutputKeySchema(SchemaUtils.fromString((String)"word:string"));
        job.setMapOutputValueSchema(SchemaUtils.fromString((String)"count:bigint"));
        InputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[0]).build(), (JobConf)job);
        OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[1]).build(), (JobConf)job);
        JobClient.runJob((JobConf)job);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SumReducer
    extends ReducerBase {
        private Record result = null;

        public void setup(Reducer.TaskContext context) throws IOException {
            this.result = context.createOutputRecord();
        }

        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            long count = 0L;
            while (values.hasNext()) {
                Record val = values.next();
                count += ((Long)val.get(0)).longValue();
            }
            this.result.set(0, key.get(0));
            this.result.set(1, (Object)count);
            context.write(this.result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SumCombiner
    extends ReducerBase {
        private Record count;

        public void setup(Reducer.TaskContext context) throws IOException {
            this.count = context.createMapOutputValueRecord();
        }

        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            long c = 0L;
            while (values.hasNext()) {
                Record val = values.next();
                c += ((Long)val.get(0)).longValue();
            }
            this.count.set(0, (Object)c);
            context.write(key, this.count);
        }
    }

    public static class TokenizerMapper
    extends MapperBase {
        private Record word;
        private Record one;

        public void setup(Mapper.TaskContext context) throws IOException {
            this.word = context.createMapOutputKeyRecord();
            this.one = context.createMapOutputValueRecord();
            this.one.set(new Object[]{1L});
            System.out.println("TaskID:" + context.getTaskID().toString());
        }

        public void map(long recordNum, Record record, Mapper.TaskContext context) throws IOException {
            for (int i = 0; i < record.getColumnCount(); ++i) {
                this.word.set(new Object[]{record.get(i).toString()});
                context.write(this.word, this.one);
            }
        }
    }
}

