/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.open.example;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;

public class Sort {
    static int printUsage() {
        System.out.println("sort <input> <output>");
        return -1;
    }

    public static void main(String[] args) throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.setMapperClass(IdentityMapper.class);
        jobConf.setReducerClass(IdentityReducer.class);
        jobConf.setNumReduceTasks(1);
        jobConf.setMapOutputKeySchema(SchemaUtils.fromString((String)"key:bigint"));
        jobConf.setMapOutputValueSchema(SchemaUtils.fromString((String)"value:bigint"));
        InputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[0]).build(), (JobConf)jobConf);
        OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[1]).build(), (JobConf)jobConf);
        Date startTime = new Date();
        System.out.println("Job started: " + startTime);
        JobClient.runJob((JobConf)jobConf);
        Date end_time = new Date();
        System.out.println("Job ended: " + end_time);
        System.out.println("The job took " + (end_time.getTime() - startTime.getTime()) / 1000L + " seconds.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IdentityReducer
    extends ReducerBase {
        private Record result = null;

        public void setup(Reducer.TaskContext context) throws IOException {
            this.result = context.createOutputRecord();
        }

        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            this.result.set(0, key.get(0));
            while (values.hasNext()) {
                Record val = values.next();
                this.result.set(1, val.get(0));
                context.write(this.result);
            }
        }
    }

    public static class IdentityMapper
    extends MapperBase {
        private Record key;
        private Record value;

        public void setup(Mapper.TaskContext context) throws IOException {
            this.key = context.createMapOutputKeyRecord();
            this.value = context.createMapOutputValueRecord();
        }

        public void map(long recordNum, Record record, Mapper.TaskContext context) throws IOException {
            this.key.set(new Object[]{(Long)record.get(0)});
            this.value.set(new Object[]{(Long)record.get(1)});
            context.write(this.key, this.value);
        }
    }
}

