/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.local.common.utils;

import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.IntervalDayTime;
import com.aliyun.odps.data.IntervalYearMonth;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.io.ArrayWritable;
import com.aliyun.odps.io.BigDecimalWritable;
import com.aliyun.odps.io.BooleanWritable;
import com.aliyun.odps.io.ByteWritable;
import com.aliyun.odps.io.BytesWritable;
import com.aliyun.odps.io.CharWritable;
import com.aliyun.odps.io.DateWritable;
import com.aliyun.odps.io.DatetimeWritable;
import com.aliyun.odps.io.DoubleWritable;
import com.aliyun.odps.io.FloatWritable;
import com.aliyun.odps.io.IntWritable;
import com.aliyun.odps.io.IntervalDayTimeWritable;
import com.aliyun.odps.io.IntervalYearMonthWritable;
import com.aliyun.odps.io.LongWritable;
import com.aliyun.odps.io.MapWritable;
import com.aliyun.odps.io.ShortWritable;
import com.aliyun.odps.io.StructWritable;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.TimestampWritable;
import com.aliyun.odps.io.VarcharWritable;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.local.common.utils.TypeConvertUtils;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.CharTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.aliyun.odps.type.VarcharTypeInfo;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LocalWritableUtils {
    public static Writable[] convert(Object[] args, List<TypeInfo> types) {
        if (args == null) {
            return null;
        }
        Writable[] result = new Writable[args.length];
        for (int i = 0; i < args.length; ++i) {
            TypeInfo typeInfo = types != null && types.size() > i ? types.get(i) : null;
            result[i] = LocalWritableUtils.convert(args[i], typeInfo);
        }
        return result;
    }

    public static Writable convert(Object arg0, TypeInfo typeInfo) {
        if (arg0 == null) {
            return null;
        }
        if (typeInfo == TypeInfoFactory.STRING || arg0 instanceof String) {
            if (arg0 instanceof String) {
                return new Text((String)arg0);
            }
            byte[] bytes = (byte[])arg0;
            return new Text(bytes);
        }
        if (typeInfo == TypeInfoFactory.TINYINT || arg0 instanceof Byte) {
            return new ByteWritable(((Byte)arg0).byteValue());
        }
        if (typeInfo == TypeInfoFactory.SMALLINT || arg0 instanceof Short) {
            return new ShortWritable(((Short)arg0).shortValue());
        }
        if (typeInfo == TypeInfoFactory.INT || arg0 instanceof Integer) {
            return new IntWritable(((Integer)arg0).intValue());
        }
        if (typeInfo == TypeInfoFactory.BIGINT || arg0 instanceof Long) {
            return new LongWritable(((Long)arg0).longValue());
        }
        if (typeInfo == TypeInfoFactory.BOOLEAN || arg0 instanceof Boolean) {
            return new BooleanWritable(((Boolean)arg0).booleanValue());
        }
        if (typeInfo == TypeInfoFactory.FLOAT || arg0 instanceof Float) {
            return new FloatWritable(((Float)arg0).floatValue());
        }
        if (typeInfo == TypeInfoFactory.DOUBLE || arg0 instanceof Double) {
            return new DoubleWritable(((Double)arg0).doubleValue());
        }
        if (typeInfo == TypeInfoFactory.DECIMAL || arg0 instanceof BigDecimal) {
            return new BigDecimalWritable((BigDecimal)arg0);
        }
        if (typeInfo == TypeInfoFactory.DATETIME || arg0 instanceof java.util.Date) {
            return new DatetimeWritable(((java.util.Date)arg0).getTime());
        }
        if (typeInfo == TypeInfoFactory.TIMESTAMP || arg0 instanceof Timestamp) {
            TimestampWritable temp = new TimestampWritable();
            temp.setTimestamp((Timestamp)arg0);
            return temp;
        }
        if (typeInfo == TypeInfoFactory.DATE || arg0 instanceof Date) {
            return new DateWritable(((Date)arg0).getTime() / 1000L);
        }
        if (typeInfo instanceof CharTypeInfo || arg0 instanceof Char) {
            return new CharWritable((Char)arg0);
        }
        if (typeInfo instanceof VarcharTypeInfo || arg0 instanceof Varchar) {
            return new VarcharWritable((Varchar)arg0);
        }
        if (typeInfo == TypeInfoFactory.BINARY || arg0 instanceof Binary) {
            return new BytesWritable(((Binary)arg0).data());
        }
        if (typeInfo == TypeInfoFactory.INTERVAL_DAY_TIME || arg0 instanceof IntervalDayTime) {
            return new IntervalDayTimeWritable((IntervalDayTime)arg0);
        }
        if (typeInfo == TypeInfoFactory.INTERVAL_YEAR_MONTH || arg0 instanceof IntervalYearMonth) {
            return new IntervalYearMonthWritable((IntervalYearMonth)arg0);
        }
        if (typeInfo instanceof ArrayTypeInfo) {
            TypeInfo subType = ((ArrayTypeInfo)typeInfo).getElementTypeInfo();
            List list = (List)arg0;
            Writable[] writables = new Writable[list.size()];
            for (int i = 0; i < writables.length; ++i) {
                Object ele = list.get(i);
                writables[i] = LocalWritableUtils.convert(ele, subType);
            }
            Class subClazz = LocalWritableUtils.getWritableClass(subType);
            return new ArrayWritable(subClazz, writables);
        }
        if (typeInfo instanceof MapTypeInfo) {
            TypeInfo keyType = ((MapTypeInfo)typeInfo).getKeyTypeInfo();
            TypeInfo valueType = ((MapTypeInfo)typeInfo).getValueTypeInfo();
            Map map = (Map)arg0;
            MapWritable result = new MapWritable();
            Iterator ele = map.entrySet().iterator();
            while (ele.hasNext()) {
                Map.Entry entry;
                Map.Entry mapEntry = entry = ele.next();
                Writable key = LocalWritableUtils.convert(mapEntry.getKey(), keyType);
                Writable value = null;
                if (mapEntry.getValue() != null) {
                    value = LocalWritableUtils.convert(mapEntry.getValue(), valueType);
                }
                result.put(key, value);
            }
            return result;
        }
        if (typeInfo instanceof StructTypeInfo) {
            List fieldTypes = ((StructTypeInfo)typeInfo).getFieldTypeInfos();
            List fieldValues = ((SimpleStruct)arg0).getFieldValues();
            assert (fieldTypes.size() == fieldValues.size());
            ArrayList<Writable> writables = new ArrayList<Writable>();
            for (int i = 0; i < fieldValues.size(); ++i) {
                Object val = fieldValues.get(i);
                TypeInfo type = (TypeInfo)fieldTypes.get(i);
                writables.add(LocalWritableUtils.convert(val, type));
            }
            return new StructWritable(writables);
        }
        throw new IllegalArgumentException("unsupported data type:" + arg0.getClass().getName());
    }

    public static Object convert(Writable arg0, TypeInfo typeInfo) {
        if (arg0 == null) {
            return null;
        }
        if (typeInfo == TypeInfoFactory.STRING || arg0 instanceof Text) {
            Text text = (Text)arg0;
            return new String(text.getBytes(), 0, text.getLength(), TypeConvertUtils.UTF8);
        }
        if (typeInfo == TypeInfoFactory.TINYINT || arg0 instanceof ByteWritable) {
            return ((ByteWritable)arg0).get();
        }
        if (typeInfo == TypeInfoFactory.SMALLINT || arg0 instanceof ShortWritable) {
            return ((ShortWritable)arg0).get();
        }
        if (typeInfo == TypeInfoFactory.INT || arg0 instanceof IntWritable) {
            return ((IntWritable)arg0).get();
        }
        if (typeInfo == TypeInfoFactory.BIGINT || arg0 instanceof LongWritable) {
            return ((LongWritable)arg0).get();
        }
        if (typeInfo == TypeInfoFactory.BOOLEAN || arg0 instanceof BooleanWritable) {
            return ((BooleanWritable)arg0).get();
        }
        if (typeInfo == TypeInfoFactory.FLOAT || arg0 instanceof FloatWritable) {
            return Float.valueOf(((FloatWritable)arg0).get());
        }
        if (typeInfo == TypeInfoFactory.DOUBLE || arg0 instanceof DoubleWritable) {
            return ((DoubleWritable)arg0).get();
        }
        if (typeInfo == TypeInfoFactory.DECIMAL || arg0 instanceof BigDecimalWritable) {
            return ((BigDecimalWritable)arg0).get();
        }
        if (typeInfo == TypeInfoFactory.DATETIME || arg0 instanceof DatetimeWritable) {
            return ((DatetimeWritable)arg0).getDatetime();
        }
        if (typeInfo == TypeInfoFactory.TIMESTAMP || arg0 instanceof TimestampWritable) {
            return ((TimestampWritable)arg0).getTimestamp();
        }
        if (typeInfo == TypeInfoFactory.DATE || arg0 instanceof DateWritable) {
            return ((DateWritable)arg0).getDate();
        }
        if (typeInfo instanceof CharTypeInfo || arg0 instanceof CharWritable) {
            return ((CharWritable)arg0).get();
        }
        if (typeInfo instanceof VarcharTypeInfo || arg0 instanceof VarcharWritable) {
            return ((VarcharWritable)arg0).get();
        }
        if (typeInfo == TypeInfoFactory.BINARY || arg0 instanceof BytesWritable) {
            BytesWritable tmp = (BytesWritable)arg0;
            byte[] bytes = Arrays.copyOfRange(tmp.getBytes(), 0, tmp.getLength());
            return new Binary(bytes);
        }
        if (typeInfo == TypeInfoFactory.INTERVAL_DAY_TIME || arg0 instanceof IntervalDayTimeWritable) {
            return ((IntervalDayTimeWritable)arg0).get();
        }
        if (typeInfo == TypeInfoFactory.INTERVAL_YEAR_MONTH || arg0 instanceof IntervalYearMonthWritable) {
            return ((IntervalYearMonthWritable)arg0).get();
        }
        if (typeInfo instanceof ArrayTypeInfo) {
            TypeInfo subType = ((ArrayTypeInfo)typeInfo).getElementTypeInfo();
            ArrayList<Object> res = new ArrayList<Object>();
            for (Writable writable : ((ArrayWritable)arg0).get()) {
                res.add(LocalWritableUtils.convert(writable, subType));
            }
            return res;
        }
        if (typeInfo instanceof MapTypeInfo) {
            TypeInfo keyType = ((MapTypeInfo)typeInfo).getKeyTypeInfo();
            TypeInfo valueType = ((MapTypeInfo)typeInfo).getValueTypeInfo();
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Map.Entry entry : ((MapWritable)arg0).entrySet()) {
                Object key = LocalWritableUtils.convert((Writable)entry.getKey(), keyType);
                Object value = LocalWritableUtils.convert((Writable)entry.getValue(), valueType);
                map.put(key, value);
            }
            return map;
        }
        if (typeInfo instanceof StructTypeInfo) {
            List fieldTypes = ((StructTypeInfo)typeInfo).getFieldTypeInfos();
            List writables = ((StructWritable)arg0).get();
            assert (fieldTypes.size() == writables.size());
            ArrayList<Object> elements = new ArrayList<Object>(writables.size());
            for (int i = 0; i < writables.size(); ++i) {
                Writable val = (Writable)writables.get(i);
                TypeInfo type = (TypeInfo)fieldTypes.get(i);
                elements.add(LocalWritableUtils.convert(val, type));
            }
            return new SimpleStruct((StructTypeInfo)typeInfo, elements);
        }
        throw new IllegalArgumentException("unsupported data type:" + arg0.getClass().getName());
    }

    public static Class getWritableClass(TypeInfo typeInfo) {
        if (typeInfo == TypeInfoFactory.STRING) {
            return Text.class;
        }
        if (typeInfo == TypeInfoFactory.TINYINT) {
            return ByteWritable.class;
        }
        if (typeInfo == TypeInfoFactory.SMALLINT) {
            return ShortWritable.class;
        }
        if (typeInfo == TypeInfoFactory.INT) {
            return IntWritable.class;
        }
        if (typeInfo == TypeInfoFactory.BIGINT) {
            return LongWritable.class;
        }
        if (typeInfo == TypeInfoFactory.BOOLEAN) {
            return BooleanWritable.class;
        }
        if (typeInfo == TypeInfoFactory.FLOAT) {
            return FloatWritable.class;
        }
        if (typeInfo == TypeInfoFactory.DOUBLE) {
            return DoubleWritable.class;
        }
        if (typeInfo == TypeInfoFactory.DECIMAL) {
            return BigDecimalWritable.class;
        }
        if (typeInfo == TypeInfoFactory.DATETIME) {
            return DatetimeWritable.class;
        }
        if (typeInfo == TypeInfoFactory.TIMESTAMP) {
            return TimestampWritable.class;
        }
        if (typeInfo == TypeInfoFactory.DATE) {
            return DateWritable.class;
        }
        if (typeInfo instanceof CharTypeInfo) {
            return CharWritable.class;
        }
        if (typeInfo instanceof VarcharTypeInfo) {
            return VarcharWritable.class;
        }
        if (typeInfo == TypeInfoFactory.BINARY) {
            return BytesWritable.class;
        }
        if (typeInfo == TypeInfoFactory.INTERVAL_DAY_TIME) {
            return IntervalDayTimeWritable.class;
        }
        if (typeInfo == TypeInfoFactory.INTERVAL_YEAR_MONTH) {
            return IntervalYearMonth.class;
        }
        if (typeInfo instanceof ArrayTypeInfo) {
            return ArrayWritable.class;
        }
        if (typeInfo instanceof MapTypeInfo) {
            return MapWritable.class;
        }
        if (typeInfo instanceof StructTypeInfo) {
            return StructWritable.class;
        }
        throw new IllegalArgumentException("unsupported data type:" + typeInfo.getTypeName());
    }
}

