/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.local.common.utils;

import com.aliyun.odps.Column;
import com.aliyun.odps.Table;
import com.aliyun.odps.local.common.TableMeta;
import com.aliyun.odps.local.common.WareHouse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class LocalRunUtils {
    public static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    public static String getCurrentTime() {
        return LocalRunUtils.getDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(new Date());
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void checkArgument(String name, int value, int lower_bound, int upper_bound) {
        if (value < lower_bound || value > upper_bound) {
            throw new RuntimeException("Local Run: Value of " + name + " out of bound, must be in range [" + lower_bound + "," + upper_bound + "].");
        }
    }

    public static DateFormat getDateFormat(String formateStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(formateStr);
        return dateFormat;
    }

    public static List<File> listEmptyDirectory(File dir) {
        File[] subDirs;
        ArrayList<File> dataFiles = new ArrayList<File>();
        for (File file : subDirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.isHidden();
            }
        })) {
            if (!file.isDirectory()) continue;
            LocalRunUtils.listEmptyDirectory(file, dataFiles);
        }
        return dataFiles;
    }

    private static void listEmptyDirectory(File dir, List<File> dataFiles) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] subDirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isHidden();
            }
        });
        if (subDirs.length == 0) {
            System.out.println(dir.getAbsolutePath());
            dataFiles.add(dir);
            return;
        }
        for (File f : subDirs) {
            if (!f.isDirectory()) continue;
            LocalRunUtils.listEmptyDirectory(f, dataFiles);
        }
    }

    public static List<File> listDataFiles(File dir) {
        ArrayList<File> dataFiles = new ArrayList<File>();
        for (File file : dir.listFiles()) {
            if ("__schema__".equals(file.getName()) || !file.isFile()) continue;
            dataFiles.add(file);
        }
        return dataFiles;
    }

    public static void listAllDataFiles(File srcFile, List<File> result) {
        if (srcFile.isDirectory()) {
            Collection list = FileUtils.listFiles((File)srcFile, (IOFileFilter)HiddenFileFilter.VISIBLE, (IOFileFilter)HiddenFileFilter.VISIBLE);
            for (File f : list) {
                LocalRunUtils.listAllDataFiles(f, result);
            }
        } else if (!"__schema__".equals(srcFile.getName())) {
            result.add(srcFile);
        }
    }

    public static void removeDataFiles(File dir) {
        for (File file : LocalRunUtils.listDataFiles(dir)) {
            file.delete();
        }
    }

    public static List<Integer> genReadColsIndexes(TableMeta meta, String[] readCols) {
        if (readCols == null || readCols.length == 0 || readCols[0] == null || readCols[0].trim().length() == 0) {
            return null;
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (String col : readCols) {
            boolean found = false;
            for (int j = 0; j < meta.getCols().length; ++j) {
                if (!meta.getCols()[j].getName().equals(col)) continue;
                indexes.add(j);
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("ODPS-0720021: Column does not exist - " + col + " in table " + meta.getProjName() + "." + meta.getTableName());
        }
        return indexes;
    }

    public static Column[] getInputTableFields(TableMeta meta, String[] cols) {
        if (cols == null || cols[0].length() == 0) {
            return meta.getCols();
        }
        ArrayList<Column> fields = new ArrayList<Column>();
        for (String col : cols) {
            for (Column field : meta.getCols()) {
                if (!col.equals(field.getName())) continue;
                fields.add(field);
            }
        }
        return fields.toArray(new Column[fields.size()]);
    }

    public static Column[] getInputTableFields(Table table, String[] cols) {
        List schema = table.getSchema().getColumns();
        if (cols == null || cols.length == 0) {
            return null;
        }
        Column[] fields = new Column[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            for (Column field : schema) {
                if (!((Column)schema.get(i)).getName().equals(field.getName())) continue;
                fields[i] = (Column)schema.get(i);
            }
        }
        return fields;
    }

    public static List<String> parseResourceName(String resourceName, String defaultProject) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        if ((resourceName = resourceName.trim()).isEmpty()) {
            throw new IllegalArgumentException("ODPS-0720031: Cache resource between comma must not be empty");
        }
        String[] arr = resourceName.split("/");
        if (arr.length == 1) {
            ret.add(defaultProject);
            ret.add(arr[0]);
        } else if (arr.length == 3) {
            if (!arr[1].equals("resources")) {
                throw new IllegalArgumentException("ODPS-0720041: Resource not found - '" + resourceName + "'");
            }
            ret.add(arr[0]);
            ret.add(arr[2]);
        } else {
            throw new IllegalArgumentException("ODPS-0720041: Resource not found - '" + resourceName + "'");
        }
        return ret;
    }

    public static String getDownloadErrorMsg(String tableInfo) {
        return "\nTable '" + tableInfo + "' is not exists in local warehouse, and download failed! Please check the following information:\n1. Endpoint/accessId/accessKey\n2. Project/Table/Partition name\n3. Local warehouse table __schema__ file infomation.\n4. If remote server has this table.\nDownload Mode:" + WareHouse.getInstance().getDownloadMode().toString();
    }

    private static void checkParent(File parent, String relativePath) {
        try {
            File child;
            if (!child.exists()) {
                throw new IOException("ODPS-0140171: must set a correct realtive path:" + relativePath);
            }
            for (child = new File(parent, relativePath); child != null && !child.getCanonicalFile().equals(parent.getCanonicalFile()); child = child.getParentFile()) {
                if (!FileUtils.isSymlink((File)child)) continue;
                throw new IOException("ODPS-0140171: not allow symlink in archive files:" + child.getName());
            }
            if (child == null) {
                throw new IOException("ODPS-0140171: not correct parameter of relative path in getCacheArchive... :" + relativePath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            IOException tmp_e = new IOException("ODPS-0140171: permission denied to read archive resource '" + parent.getName() + "' with relative path :" + relativePath);
            throw new RuntimeException(tmp_e);
        }
    }

    public static Collection<File> listFiles(final File dir, final String relativePath) throws IOException {
        try {
            return (Collection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    File relativeDir = new File(dir, relativePath);
                    LocalRunUtils.checkParent(dir, relativePath);
                    if (relativeDir.isDirectory()) {
                        return FileUtils.listFiles((File)relativeDir, (IOFileFilter)new InternalIOFilter(), (IOFileFilter)new InternalIOFilter());
                    }
                    LinkedList<File> files = new LinkedList<File>();
                    files.add(relativeDir);
                    return files;
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public static String toReadableString(byte[] b) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream printableos = MimeUtility.encode((OutputStream)baos, (String)"base64");
        printableos.write(b);
        printableos.close();
        return new String(baos.toByteArray(), Charset.forName("UTF-8"));
    }

    public static byte[] fromReadableString(String str) throws Exception {
        byte[] b = str.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        InputStream printableis = MimeUtility.decode((InputStream)bais, (String)"base64");
        byte[] tmp = new byte[b.length];
        int n = printableis.read(tmp);
        byte[] res = new byte[n];
        System.arraycopy(tmp, 0, res, 0, n);
        return res;
    }

    public static boolean validateTunnelEndpoint(String tunnelEndpoint) {
        try {
            URI url = new URI(tunnelEndpoint);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private static class InternalIOFilter
    implements IOFileFilter {
        public boolean accept(File dir, String name) {
            return this.accept(new File(dir, name));
        }

        public boolean accept(File file) {
            try {
                if (FileUtils.isSymlink((File)file)) {
                    throw new IOException("ODPS-0140171: not allow symlink in archive files:" + file.getName());
                }
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

