/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.example.text.withclone;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.io.InputStreamSet;
import com.aliyun.odps.io.SourceInputStream;
import com.aliyun.odps.udf.DataAttributes;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.udf.Extractor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class TextExtractorWithClone
extends Extractor {
    private InputStreamSet inputs;
    private int cloneCopy;
    private SourceInputStream currentInput;

    public void setup(ExecutionContext ctx, InputStreamSet inputs, DataAttributes attributes) {
        this.inputs = inputs;
        this.currentInput = null;
        this.cloneCopy = 10;
        try {
            ArrayList<BufferedReader> cloneReaders;
            while ((cloneReaders = this.moveToNextFile()) != null) {
                int idx = 0;
                for (BufferedReader reader : cloneReaders) {
                    System.out.println("reading a line from cloned stream # " + idx++);
                    System.out.println(reader.readLine());
                }
            }
            long skippBytes = this.currentInput.skip(100L);
            BufferedReader sourceReader = new BufferedReader(new InputStreamReader((InputStream)this.currentInput));
            System.out.println("line content after skipping: " + (skippBytes += this.currentInput.skip(200L)) + " bytes.");
            System.out.println(sourceReader.readLine());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Record extract() throws IOException {
        return null;
    }

    public void close() {
        try {
            this.currentInput.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ArrayList<BufferedReader> moveToNextFile() throws IOException {
        ArrayList<BufferedReader> bufferedReaders = new ArrayList<BufferedReader>();
        SourceInputStream stream = this.inputs.next();
        if (stream == null) {
            return null;
        }
        if (this.currentInput != null) {
            this.currentInput.close();
        }
        this.currentInput = stream;
        System.out.println("--------------------------------------------------");
        System.out.println("Processing file " + this.currentInput.getFileName());
        for (int i = 0; i < this.cloneCopy; ++i) {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.currentInput.cloneStream()));
            for (int j = 0; j < i; ++j) {
                reader.readLine();
            }
            bufferedReaders.add(reader);
        }
        return bufferedReaders;
    }
}

