/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.auth;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import java.io.PrintStream;

public class GetSecurityPolicyCommand
extends AbstractCommand {
    private static final String REGEX = "GET\\s+SECURITY\\s+POLICY";
    public static final String[] HELP_TAGS = new String[]{"GET", "SECURITY", "POLICY"};

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: GET SECURITY POLICY");
    }

    public GetSecurityPolicyCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        SecurityManager sm = odps.projects().get().getSecurityManager();
        String policy = sm.getSecurityPolicy();
        DefaultOutputWriter outputWriter = this.getContext().getOutputWriter();
        outputWriter.writeResult(policy);
    }

    public static GetSecurityPolicyCommand parse(String commandText, ExecutionContext context) {
        if ((commandText = commandText.trim().toUpperCase()).matches(REGEX)) {
            return new GetSecurityPolicyCommand(commandText, context);
        }
        return null;
    }
}

