/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import com.aliyun.openservices.odps.console.ODPSConsoleException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang.WordUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CopyCommands;
import org.apache.hadoop.fs.shell.Count;
import org.apache.hadoop.fs.shell.Delete;
import org.apache.hadoop.fs.shell.Display;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.Mkdir;
import org.apache.hadoop.fs.shell.MoveCommands;
import org.apache.hadoop.fs.shell.SetReplication;
import org.apache.hadoop.fs.shell.Tail;
import org.apache.hadoop.fs.shell.Test;
import org.apache.hadoop.fs.shell.TouchCommands;
import org.apache.hadoop.fs.shell.VfsLsCommand;
import org.apache.hadoop.fs.shell.find.Find;
import org.apache.hadoop.tools.TableListing;

public class FilteredFsShell
extends FsShell {
    private static final int MAX_LINE_WIDTH = 80;
    private static final String usagePrefix = "Usage: vfs ";

    public FilteredFsShell(Configuration conf) {
        super(conf);
    }

    protected void init() {
        this.getConf().setQuietMode(true);
        if (this.commandFactory == null) {
            this.commandFactory = new CommandFactory(this.getConf());
            this.commandFactory.addObject((Command)new Help(), new String[]{"-help"});
            this.commandFactory.addObject((Command)new Usage(), new String[]{"-usage"});
            this.registerCommands(this.commandFactory);
        }
    }

    public void printUsage(PrintStream out, String cmd) {
        this.printInfo(out, cmd, false);
    }

    private void printHelp(PrintStream out) {
        this.printInfo(out, null, true);
    }

    public void printInfo(PrintStream out, String cmd, boolean showHelp) {
        if (cmd != null) {
            Command instance = this.commandFactory.getInstance("-" + cmd);
            if (instance == null) {
                throw new IllegalArgumentException(cmd);
            }
            if (showHelp) {
                this.printInstanceHelp(out, instance);
            } else {
                out.println(usagePrefix + instance.getUsage());
            }
        } else {
            out.println(usagePrefix);
            ArrayList<Command> instances = new ArrayList<Command>();
            for (String name : this.commandFactory.getNames()) {
                Command instance = this.commandFactory.getInstance(name);
                if (instance.isDeprecated()) continue;
                out.println("\t[" + instance.getUsage() + "]");
                instances.add(instance);
            }
            if (showHelp) {
                for (Command instance : instances) {
                    out.println();
                    this.printInstanceHelp(out, instance);
                }
            }
            out.println();
        }
    }

    private void displayError(String cmd, String message) {
        for (String line : message.split("\n")) {
            System.err.println(cmd + ": " + line);
            if (cmd.charAt(0) == '-') continue;
            Command instance = null;
            instance = this.commandFactory.getInstance("-" + cmd);
            if (instance == null) continue;
            System.err.println("Did you mean -" + cmd + "?  This command begins with a dash.");
        }
    }

    public int run(String[] argv) {
        this.init();
        int exitCode = -1;
        if (argv.length < 1) {
            this.printUsage(System.err);
        } else {
            String cmd = argv[0];
            Command instance = null;
            try {
                instance = this.commandFactory.getInstance(cmd);
                if (instance == null) {
                    throw new ODPSConsoleException("Unknown command: " + cmd);
                }
                if (instance instanceof VfsLsCommand) {
                    this.getConf().set("odps.restclient.retrytime", "0");
                }
                exitCode = instance.run(Arrays.copyOfRange(argv, 1, argv.length));
            }
            catch (IllegalArgumentException e) {
                this.displayError(cmd, e.getLocalizedMessage());
                if (instance != null) {
                    this.printInstanceUsage(System.err, instance);
                }
            }
            catch (Exception e) {
                this.displayError(cmd, "Fatal internal error");
                e.printStackTrace(System.err);
            }
        }
        return exitCode;
    }

    private void printUsage(PrintStream out) {
        this.printInfo(out, null, false);
    }

    public void printInstanceUsage(PrintStream out, Command instance) {
        out.println(usagePrefix + instance.getUsage());
    }

    private void printInstanceHelp(PrintStream out, Command instance) {
        out.println(instance.getUsage() + " :");
        TableListing listing = null;
        String prefix = "  ";
        for (String line : instance.getDescription().split("\n")) {
            String[] segments;
            if (line.matches("^[ \t]*[-<].*$") && (segments = line.split(":")).length == 2) {
                if (listing == null) {
                    listing = new TableListing.Builder().addField("").addField("", true).wrapWidth(80).build();
                }
                listing.addRow(new String[]{segments[0].trim(), segments[1].trim()});
                continue;
            }
            if (listing != null) {
                for (String listingLine : listing.toString().split("\n")) {
                    out.println("  " + listingLine);
                }
                listing = null;
            }
            for (String descLine : WordUtils.wrap((String)line, (int)80, (String)"\n", (boolean)true).split("\n")) {
                out.println("  " + descLine);
            }
        }
        if (listing != null) {
            for (String listingLine : listing.toString().split("\n")) {
                out.println("  " + listingLine);
            }
        }
    }

    private void printHelp(PrintStream out, String cmd) {
        this.printInfo(out, cmd, true);
    }

    protected void registerCommands(CommandFactory factory) {
        factory.addClass(CopyCommands.Merge.class, new String[]{"-getmerge"});
        factory.addClass(CopyCommands.Cp.class, new String[]{"-cp"});
        factory.addClass(CopyCommands.CopyFromLocal.class, new String[]{"-copyFromLocal"});
        factory.addClass(CopyCommands.CopyToLocal.class, new String[]{"-copyToLocal"});
        factory.addClass(CopyCommands.Get.class, new String[]{"-get"});
        factory.addClass(CopyCommands.Put.class, new String[]{"-put"});
        factory.addClass(Count.class, new String[]{"-count"});
        factory.addClass(Delete.Rm.class, new String[]{"-rm"});
        factory.addClass(Delete.Rmdir.class, new String[]{"-rmdir"});
        factory.addClass(Delete.Rmr.class, new String[]{"-rmr"});
        factory.addClass(Display.Cat.class, new String[]{"-cat"});
        factory.addClass(Display.Text.class, new String[]{"-text"});
        factory.addClass(Find.class, new String[]{"-find"});
        factory.addClass(VfsLsCommand.class, new String[]{"-ls"});
        factory.addClass(VfsLsCommand.VfsLsr.class, new String[]{"-lsr"});
        factory.addClass(Mkdir.class, new String[]{"-mkdir"});
        factory.addClass(MoveCommands.MoveFromLocal.class, new String[]{"-moveFromLocal"});
        factory.addClass(MoveCommands.MoveToLocal.class, new String[]{"-moveToLocal"});
        factory.addClass(MoveCommands.Rename.class, new String[]{"-mv"});
        factory.addClass(SetReplication.class, new String[]{"-setrep"});
        factory.addClass(Tail.class, new String[]{"-tail"});
        factory.addClass(Test.class, new String[]{"-test"});
        factory.addClass(TouchCommands.Touchz.class, new String[]{"-touchz"});
    }

    protected class Help
    extends FsCommand {
        public static final String NAME = "help";
        public static final String USAGE = "[cmd ...]";
        public static final String DESCRIPTION = "Displays help for given command or all commands if none is specified.";

        protected Help() {
        }

        protected void processRawArguments(LinkedList<String> args) {
            if (args.isEmpty()) {
                FilteredFsShell.this.printHelp(System.out, null);
            } else {
                for (String arg : args) {
                    FilteredFsShell.this.printHelp(System.out, arg);
                }
            }
        }
    }

    protected class Usage
    extends FsCommand {
        public static final String NAME = "usage";
        public static final String USAGE = "[cmd ...]";
        public static final String DESCRIPTION = "Displays the usage for given command or all commands if none is specified.";

        protected Usage() {
        }

        protected void processRawArguments(LinkedList<String> args) {
            if (args.isEmpty()) {
                FilteredFsShell.this.printUsage(System.out, null);
            } else {
                for (String arg : args) {
                    FilteredFsShell.this.printUsage(System.out, arg);
                }
            }
        }
    }
}

