/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.utils;

import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.TaskContext;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;

public class MapReduceUtils {
    static Method getOverriddenMethod(Class<?> clz, String methodName, Class<?> ... args) {
        List methods = null;
        while (clz != null) {
            methods = ReflectionUtils.findUserClassMethods(clz, (String)methodName);
            for (Method m : methods) {
                if (m == null || !MapReduceUtils.isAssignable(m.getParameterTypes(), args)) continue;
                return m;
            }
            clz = clz.getSuperclass();
        }
        return null;
    }

    private static boolean isAssignable(Class<?>[] parameterTypes, Class<?>[] args) {
        if (parameterTypes == null || args == null || parameterTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (args[i].isAssignableFrom(parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static void handleException(InvocationTargetException e) throws IOException {
        if (e.getTargetException() instanceof IOException) {
            throw (IOException)e.getTargetException();
        }
        if (e.getTargetException() instanceof Error) {
            throw (Error)e.getTargetException();
        }
        if (e.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)e.getTargetException();
        }
        throw new RuntimeException(e.getTargetException());
    }

    public static void runMapper(Class<Mapper> clz, Mapper.TaskContext ctx) throws IOException {
        Mapper mapper = (Mapper)ReflectionUtils.newInstance(clz, (Configuration)ctx.getJobConf());
        try {
            Method m;
            if (ctx.getJobConf().getBoolean("odps.mapred.run.interface.enable", false) && (m = MapReduceUtils.getOverriddenMethod(clz, "run", TaskContext.class)) != null) {
                m.invoke((Object)mapper, ctx);
                return;
            }
            m = MapReduceUtils.getOverriddenMethod(clz, "setup", TaskContext.class);
            if (m != null) {
                m.invoke((Object)mapper, ctx);
            }
            if ((m = MapReduceUtils.getOverriddenMethod(clz, "map", Long.TYPE, Record.class, TaskContext.class)) != null) {
                while (ctx.nextRecord()) {
                    m.invoke((Object)mapper, ctx.getCurrentRecordNum(), ctx.getCurrentRecord(), ctx);
                }
            }
            if ((m = MapReduceUtils.getOverriddenMethod(clz, "cleanup", TaskContext.class)) != null) {
                m.invoke((Object)mapper, ctx);
            }
        }
        catch (InvocationTargetException e) {
            MapReduceUtils.handleException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void runReducer(Class<Reducer> clz, Reducer.TaskContext ctx) throws IOException {
        Reducer combiner = (Reducer)ReflectionUtils.newInstance(clz, (Configuration)ctx.getJobConf());
        try {
            Method m;
            if (ctx.getJobConf().getBoolean("odps.mapred.run.interface.enable", false) && (m = MapReduceUtils.getOverriddenMethod(clz, "run", TaskContext.class)) != null) {
                m.invoke((Object)combiner, ctx);
                return;
            }
            m = MapReduceUtils.getOverriddenMethod(clz, "setup", TaskContext.class);
            if (m != null) {
                m.invoke((Object)combiner, ctx);
            }
            if ((m = MapReduceUtils.getOverriddenMethod(clz, "reduce", Record.class, Iterator.class, TaskContext.class)) != null) {
                while (ctx.nextKeyValue()) {
                    m.invoke((Object)combiner, ctx.getCurrentKey(), ctx.getValues(), ctx);
                }
            }
            if ((m = MapReduceUtils.getOverriddenMethod(clz, "cleanup", TaskContext.class)) != null) {
                m.invoke((Object)combiner, ctx);
            }
        }
        catch (InvocationTargetException e) {
            MapReduceUtils.handleException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean partSpecInclusive(TableInfo desc, TableInfo existing) {
        if (!desc.getProjectName().equalsIgnoreCase(existing.getProjectName()) || !desc.getTableName().equalsIgnoreCase(existing.getTableName())) {
            return false;
        }
        if (desc.getPartitionSpec() != null) {
            for (String key : desc.getPartSpec().keySet()) {
                if (((String)desc.getPartSpec().get(key)).equals(existing.getPartSpec().get(key))) continue;
                return false;
            }
        }
        return true;
    }
}

