/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.type;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.mapred.bridge.type.ComparatorFactory;
import java.util.Comparator;

public class NaturalRecordComparator
implements Comparator<Object[]> {
    protected Comparator[] comparators;

    public NaturalRecordComparator(Column[] schema) {
        this.comparators = new Comparator[schema.length];
        for (int i = 0; i < schema.length; ++i) {
            OdpsType type = schema[i].getType();
            this.comparators[i] = ComparatorFactory.getComparator(type);
        }
    }

    @Override
    public int compare(Object[] l, Object[] r) {
        int result = 0;
        for (int i = 0; i < l.length; ++i) {
            if (r.length < i) {
                return -1;
            }
            result = this.compare(l[i], r[i], this.comparators[i]);
            if (result == 0) continue;
            return result;
        }
        if (r.length > l.length) {
            return 1;
        }
        return 0;
    }

    protected int compare(Object l, Object r, Comparator comparator) {
        return comparator.compare(l, r);
    }
}

