/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.streaming;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.TaskContext;
import com.aliyun.odps.mapred.bridge.streaming.PipeMapRed;
import com.aliyun.odps.mapred.bridge.streaming.io.InputWriter;
import com.aliyun.odps.mapred.bridge.streaming.io.OutputReader;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.UTF8ByteArrayUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;

public class PipeReducer
extends PipeMapRed
implements Reducer {
    private byte[] reduceOutFieldSeparator;
    private byte[] reduceInputFieldSeparator;
    private int numOfReduceOutputKeyFields = 1;
    private boolean skipping = false;

    @Override
    String getPipeCommand(JobConf job) {
        String str = job.get("stream.reduce.streamprocessor");
        if (str == null) {
            return str;
        }
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("stream.reduce.streamprocessor in jobconf not found");
            return null;
        }
    }

    @Override
    boolean getDoPipe() {
        String argv = this.getPipeCommand(this.job_);
        return argv != null && !"NONE".equals(argv);
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        try {
            this.reduceOutFieldSeparator = UTF8ByteArrayUtils.unescapeSeparator((String)this.job_.get("stream.reduce.output.field.separator", "\t")).getBytes("UTF-8");
            this.reduceInputFieldSeparator = UTF8ByteArrayUtils.unescapeSeparator((String)this.job_.get("stream.reduce.input.field.separator", "\t")).getBytes("UTF-8");
            this.numOfReduceOutputKeyFields = this.job_.getInt("stream.num.reduce.output.key.fields", 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("The current system does not support UTF-8 encoding!", e);
        }
    }

    public void setup(Reducer.TaskContext context) throws IOException {
        this.configure(context.getJobConf());
    }

    public void cleanup(Reducer.TaskContext context) throws IOException {
        this.close();
    }

    public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
        if (this.doPipe_ && this.outThread_ == null) {
            this.startOutputThreads((TaskContext)context);
        }
        try {
            while (values.hasNext()) {
                Record val = values.next();
                ++this.numRecRead_;
                this.maybeLogRecord();
                if (this.doPipe_) {
                    if (this.outerrThreadsThrowable != null) {
                        this.mapRedFinished();
                        throw new IOException("MROutput/MRErrThread failed:", this.outerrThreadsThrowable);
                    }
                    this.inWriter_.writeKey(key.get(0));
                    this.inWriter_.writeValue(val.get(0));
                    continue;
                }
                Record record = context.createOutputRecord();
                record.setString(0, key.getString(0));
                record.setString(1, val.getString(0));
                context.write(record);
            }
            if (this.doPipe_ && this.skipping) {
                this.clientOut_.flush();
            }
        }
        catch (IOException io) {
            String extraInfo = "";
            try {
                int exitVal = this.sim.exitValue();
                extraInfo = exitVal == 0 ? "subprocess exited successfully\n" : "subprocess exited with error code " + exitVal + "\n";
            }
            catch (IllegalThreadStateException e) {
                extraInfo = "subprocess still running\n";
            }
            this.mapRedFinished();
            throw new IOException(extraInfo + this.getContext() + io.getMessage());
        }
    }

    public void close() {
        this.mapRedFinished();
    }

    @Override
    public byte[] getInputSeparator() {
        return this.reduceInputFieldSeparator;
    }

    @Override
    public byte[] getFieldSeparator() {
        return this.reduceOutFieldSeparator;
    }

    @Override
    public int getNumOfKeyFields() {
        return this.numOfReduceOutputKeyFields;
    }

    @Override
    InputWriter createInputWriter() throws IOException {
        return super.createInputWriter(this.reduceInputWriterClass_);
    }

    @Override
    OutputReader createOutputReader() throws IOException {
        return super.createOutputReader(this.reduceOutputReaderClass_);
    }
}

