/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.mapred.bridge.WritableRecord;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class GroupingRecordIterator
implements Iterator<Record> {
    private WritableRecord key;
    private WritableRecord value;
    private Object[] prefetch;
    private boolean hasNext;
    private Comparator<Object[]> keyGroupingComparator;
    private Queue<Object[]> queue;

    public GroupingRecordIterator(Queue<Object[]> queue, WritableRecord key, WritableRecord value, Comparator<Object[]> keyGroupingComparator) {
        this.queue = queue;
        this.key = key;
        this.value = value;
        this.keyGroupingComparator = keyGroupingComparator;
    }

    private void fillKeyValue(Object[] objs) {
        this.key.set(Arrays.copyOf(objs, this.key.getColumnCount()));
        this.value.set(Arrays.copyOfRange(objs, this.key.getColumnCount(), objs.length));
    }

    @Override
    public boolean hasNext() {
        if (this.prefetch != null) {
            return this.hasNext;
        }
        this.prefetch = this.queue.poll();
        if (this.prefetch == null || this.keyGroupingComparator.compare(this.key.toWritableArray(), this.prefetch) != 0) {
            this.hasNext = false;
        } else {
            this.hasNext = true;
            this.fillKeyValue(this.prefetch);
        }
        return this.hasNext;
    }

    public boolean reset() {
        if (this.prefetch != null) {
            this.hasNext = true;
            this.fillKeyValue(this.prefetch);
            return true;
        }
        return false;
    }

    @Override
    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.prefetch = null;
        return this.value;
    }

    @Override
    public void remove() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.prefetch = null;
    }
}

