/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Resource;
import com.aliyun.odps.Task;
import com.aliyun.odps.mapred.BridgeJobRunner;
import com.aliyun.odps.mapred.bridge.LOTGenerator;
import com.aliyun.odps.mapred.bridge.sqlgen.SqlGenerator;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.conf.JobHintTranslator;
import com.aliyun.odps.mapred.conf.SessionState;
import com.aliyun.odps.pipeline.Pipeline;
import com.aliyun.odps.task.LOTTask;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.util.HashMap;

public class LotBridgeJobRunner
extends BridgeJobRunner {
    @Override
    protected Instance submitInternal() throws OdpsException {
        Pipeline pipeline = Pipeline.fromJobConf((JobConf)this.job);
        byte[] lotPlan = new LOTGenerator(this.metaExplorer.getDefaultProject(), this.job, pipeline).generate();
        String planTempResource = this.metaExplorer.addTempResourceWithRetry(new ByteArrayInputStream(lotPlan), "lotplan_mr_" + this.jobId, Resource.Type.FILE);
        LOTTask task = new LOTTask();
        LOTTask.Plan plan = new LOTTask.Plan();
        plan.setResourceName(planTempResource);
        plan.setProject(this.metaExplorer.getDefaultProject());
        task.setPlan(plan);
        task.setName(this.taskName);
        try {
            task.setQuery(SqlGenerator.generate(this.job, this.jobId, this.metaExplorer, this.aliasToTempResource));
        }
        catch (Exception e) {
            task.setProperty("odps.mr.sql.error", e.getMessage());
            e.printStackTrace();
        }
        try {
            String json = new GsonBuilder().disableHtmlEscaping().create().toJson(JobHintTranslator.apply(this.job));
            task.setProperty("settings", json);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), (Throwable)e);
        }
        try {
            HashMap aliases = new HashMap();
            aliases.putAll(this.aliasToTempResource);
            aliases.putAll(SessionState.get().getAliases());
            String json = new GsonBuilder().disableHtmlEscaping().create().toJson(aliases);
            task.setProperty("aliases", json);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), (Throwable)e);
        }
        String commandText = SessionState.get().getCommandText();
        if (commandText.length() > 0) {
            task.setProperty("commandText", commandText);
        }
        if (SessionState.get().isCostMode()) {
            task.setProperty("odps.task.cost.estimate", "true");
        }
        return this.metaExplorer.createInstance((Task)task, this.job.getInstancePriority());
    }
}

