/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.local.message;

import com.aliyun.odps.graph.local.RuntimeContext;
import com.aliyun.odps.graph.local.message.SuperStepBuffer;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableComparable;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MsgManager {
    private static Log LOG = LogFactory.getLog(MsgManager.class);
    private SuperStepBuffer curBuffer = new SuperStepBuffer(-1L);
    private SuperStepBuffer nextBuffer = new SuperStepBuffer(0L);

    public void pushMsg(RuntimeContext context, long superStep, WritableComparable<?> vertexId, Writable msg) {
        if (superStep != this.nextBuffer.getSuperStep()) {
            throw new RuntimeException("Internal error, super step is inconsistent, expected " + this.nextBuffer.getSuperStep() + ", but " + superStep);
        }
        this.nextBuffer.pushMsg(vertexId, msg);
    }

    public boolean hasMessageForVertex(RuntimeContext context, long superStep, WritableComparable<?> vertexId) {
        if (superStep != this.curBuffer.getSuperStep()) {
            throw new RuntimeException("Internal error, super step is inconsistent, expected " + this.curBuffer.getSuperStep() + ", but " + superStep);
        }
        return this.curBuffer.hasMsg(vertexId);
    }

    public Iterable<Writable> popMsges(RuntimeContext context, long superStep, WritableComparable<?> vertexId) {
        if (superStep != this.curBuffer.getSuperStep()) {
            throw new RuntimeException("Internal error, super step is inconsistent, expected " + this.curBuffer.getSuperStep() + ", but " + superStep);
        }
        return this.curBuffer.popMsges(vertexId);
    }

    public void nextSuperStep(RuntimeContext context) throws IOException {
        this.nextBuffer.dump(context);
        this.curBuffer = this.nextBuffer;
        this.nextBuffer = new SuperStepBuffer(this.curBuffer.getSuperStep() + 1L);
    }

    public Set<WritableComparable<?>> getVertexIDList() {
        return this.curBuffer.getVertexIDList();
    }

    public boolean hasNextStepMessages() {
        return this.nextBuffer.hasMessages();
    }
}

