/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.local;

import com.aliyun.odps.utils.CommonUtils;
import com.aliyun.odps.utils.StringUtils;
import java.io.File;
import java.nio.charset.Charset;

public class LocalRunContext {
    private static LocalRunContext instance = null;
    private int recordLimit = 100;
    private int maxMapTasks = 100;
    private int maxReduceTasks = 1;
    private Charset encoding = null;
    private File wareHouse = new File("./warehouse");
    private boolean cleanJobDir = false;
    private boolean cleanUtDir = true;

    private LocalRunContext() {
        String s = System.getProperty("odps.mapred.local.record.limit");
        if (!StringUtils.isEmpty((String)s)) {
            this.recordLimit = Integer.parseInt(s);
            CommonUtils.checkArgument((String)"'input record limit'", (int)this.recordLimit, (int)0, (int)10000);
        }
        if (!StringUtils.isEmpty((String)(s = System.getProperty("odps.mapred.local.map.max.tasks")))) {
            this.maxMapTasks = Integer.parseInt(s);
            CommonUtils.checkArgument((String)"'max map tasks'", (int)this.maxMapTasks, (int)0, (int)100);
        }
        if (!StringUtils.isEmpty((String)(s = System.getProperty("odps.mapred.local.reduce.max.tasks")))) {
            this.maxReduceTasks = Integer.parseInt(s);
            CommonUtils.checkArgument((String)"'max reduce tasks'", (int)this.maxReduceTasks, (int)0, (int)100);
        }
        if (!StringUtils.isEmpty((String)(s = System.getProperty("odps.mapred.local.job.clean")))) {
            this.cleanJobDir = Boolean.parseBoolean(s);
        }
        if (!StringUtils.isEmpty((String)(s = System.getProperty("odps.mapred.ut.clean")))) {
            this.cleanUtDir = Boolean.parseBoolean(s);
        }
        this.encoding = !StringUtils.isEmpty((String)(s = System.getProperty("odps.mapred.local.file.encoding"))) ? Charset.forName(s) : Charset.forName("UTF-8");
        s = System.getProperty("odps.mapred.local.warehouse");
        if (!StringUtils.isEmpty((String)s)) {
            this.wareHouse = new File(s);
        }
        this.wareHouse.mkdirs();
    }

    public static synchronized LocalRunContext getInstance() {
        if (instance == null) {
            instance = new LocalRunContext();
        }
        return instance;
    }

    public int getRecordLimit() {
        return this.recordLimit;
    }

    public int getMaxMapTasks() {
        return this.maxMapTasks;
    }

    public int getMaxReduceTasks() {
        return this.maxReduceTasks;
    }

    public boolean isCleanJobDir() {
        return this.cleanJobDir;
    }

    public boolean isCleanUtDir() {
        return this.cleanUtDir;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public File getWareHouse() {
        return this.wareHouse;
    }
}

