/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.local;

import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.data.VolumeInfo;
import com.aliyun.odps.mapred.Partitioner;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.TaskId;
import com.aliyun.odps.mapred.bridge.ErrorCode;
import com.aliyun.odps.mapred.bridge.WritableRecord;
import com.aliyun.odps.mapred.bridge.type.ColumnBasedRecordComparator;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.local.DriverBase;
import com.aliyun.odps.mapred.local.JobCounter;
import com.aliyun.odps.mapred.local.LocalGroupingRecordIterator;
import com.aliyun.odps.mapred.local.LocalTaskContext;
import com.aliyun.odps.mapred.local.MapOutputBuffer;
import com.aliyun.odps.utils.ReflectionUtils;
import com.aliyun.odps.volume.FileSystem;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReduceDriver
extends DriverBase {
    public static final Log LOG = LogFactory.getLog(ReduceDriver.class);
    private final Reducer.TaskContext reduceContext;
    MapOutputBuffer inputBuffer;
    MapOutputBuffer outputBuffer;

    public ReduceDriver(BridgeJobConf job, MapOutputBuffer inputBuffer, MapOutputBuffer outputBuffer, TaskId id, Counters counters, int partitionIndex) throws IOException {
        super(job, id, counters);
        this.inputBuffer = inputBuffer;
        this.outputBuffer = outputBuffer;
        this.reduceContext = new ReduceContextImpl(job, this.taskId, counters, inputBuffer.getPartitionQueue(partitionIndex), outputBuffer);
    }

    @Override
    public void run() throws IOException {
        Reducer reducer = ((LocalTaskContext)this.reduceContext).createReducer();
        reducer.setup(this.reduceContext);
        while (this.reduceContext.nextKeyValue()) {
            reducer.reduce(this.reduceContext.getCurrentKey(), this.reduceContext.getValues(), this.reduceContext);
        }
        reducer.cleanup(this.reduceContext);
        ((ReduceContextImpl)this.reduceContext).close();
    }

    class ReduceContextImpl
    extends LocalTaskContext
    implements Reducer.TaskContext,
    Closeable {
        private Record key;
        private Comparator<Object[]> keyGroupingComparator;
        private LocalGroupingRecordIterator itr;
        private Queue<Object[]> queue;
        private MapOutputBuffer outputBuffer;
        private Partitioner partitioner;
        private Counters counters;

        public ReduceContextImpl(BridgeJobConf job, TaskId taskId, Counters counters, Queue<Object[]> queue, MapOutputBuffer outputBuffer) throws IOException {
            super(job, taskId, counters);
            Class partitionerClass = null;
            if (this.pipeMode) {
                this.conf.setReducerClass(this.pipeNode.getTransformClass());
                this.key = new WritableRecord(this.pipeNode.getInputKeySchema());
                this.keyGroupingComparator = new ColumnBasedRecordComparator(this.pipeNode.getInputGroupingColumns(), this.key.getColumns());
                partitionerClass = this.pipeNode.getPartitionerClass();
            } else {
                this.key = new WritableRecord(this.conf.getMapOutputKeySchema());
                this.keyGroupingComparator = new ColumnBasedRecordComparator(this.conf.getOutputGroupingColumns(), this.key.getColumns());
            }
            if (partitionerClass != null) {
                this.partitioner = (Partitioner)ReflectionUtils.newInstance(partitionerClass, (Configuration)this.getJobConf());
                this.partitioner.configure((JobConf)this.conf);
            }
            this.queue = queue;
            this.outputBuffer = outputBuffer;
            this.counters = counters;
        }

        public void write(Record record) throws IOException {
            this.write(record, "__default__");
        }

        public void write(Record record, String label) throws IOException {
            if (this.outputBuffer != null) {
                this.outputBuffer.add(record, label);
            }
            ((RecordWriter)this.recordWriters.get(label)).write(record);
            this.counters.findCounter((Enum)JobCounter.__EMPTY_OUTPUT_RECORD_COUNT).increment(1L);
        }

        public boolean nextKeyValue() {
            if (this.itr == null) {
                Object[] init = this.queue.peek();
                if (init == null) {
                    return false;
                }
                WritableRecord value = this.pipeMode ? new WritableRecord(this.pipeNode.getInputValueSchema()) : new WritableRecord(this.conf.getMapOutputValueSchema());
                this.itr = new LocalGroupingRecordIterator(this.queue, (WritableRecord)this.key, value, this.keyGroupingComparator, true, this.counters);
                this.key.set(Arrays.copyOf(init, this.key.getColumnCount()));
            } else {
                while (this.itr.hasNext()) {
                    this.itr.remove();
                }
                if (!this.itr.reset()) {
                    return false;
                }
            }
            return true;
        }

        public Record getCurrentKey() {
            return this.key;
        }

        public Iterator<Record> getValues() {
            return this.itr;
        }

        public void write(Record key, Record value) {
            if (!this.pipeMode || this.pipeNode == null) {
                throw new UnsupportedOperationException(ErrorCode.INTERMEDIATE_OUTPUT_IN_REDUCER.toString());
            }
            if (this.partitioner != null) {
                int part = this.partitioner.getPartition(key, value, this.getNumReduceTasks());
                if (part < 0 || part >= this.getNumReduceTasks()) {
                    throw new RuntimeException("partitioner return invalid partition value:" + part);
                }
                this.outputBuffer.add(key, value, part);
            } else {
                this.outputBuffer.add(key, value);
            }
            this.counters.findCounter((Enum)JobCounter.__EMPTY_OUTPUT_RECORD_COUNT).increment(1L);
        }

        @Override
        public void close() throws IOException {
            this.closeWriters();
        }

        public VolumeInfo getInputVolumeInfo() throws IOException {
            return null;
        }

        public VolumeInfo getInputVolumeInfo(String label) throws IOException {
            return null;
        }

        public VolumeInfo getOutputVolumeInfo() throws IOException {
            return null;
        }

        public VolumeInfo getOutputVolumeInfo(String label) throws IOException {
            return null;
        }

        public FileSystem getInputVolumeFileSystem() throws IOException {
            return null;
        }

        public FileSystem getInputVolumeFileSystem(String label) throws IOException {
            return null;
        }

        public FileSystem getOutputVolumeFileSystem() throws IOException {
            return null;
        }

        public FileSystem getOutputVolumeFileSystem(String label) throws IOException {
            return null;
        }
    }
}

