/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.local;

import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordPack;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.local.common.utils.TypeConvertUtils;
import com.aliyun.odps.type.TypeInfo;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class CSVRecordWriter
implements RecordWriter {
    private CsvWriter writer;
    private boolean closed = false;
    private File outputFile;
    private Counter recordCounter;
    private Counter byteCounter;
    private long count = 0L;

    public CSVRecordWriter(File file, Counter recordCounter, Counter byteCounter, char outputColumnSeperator) {
        this.recordCounter = recordCounter;
        this.byteCounter = byteCounter;
        this.outputFile = new File(file.getAbsolutePath());
        Charset encoding = Charset.forName("UTF-8");
        this.writer = new CsvWriter(file.getAbsolutePath(), outputColumnSeperator, encoding);
    }

    public void write(Record record) throws IOException {
        Object[] fields = record.toArray();
        String[] vals = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String rawVal;
            vals[i] = rawVal = TypeConvertUtils.toString((Object)record.get(i), (TypeInfo)record.getColumns()[i].getTypeInfo());
        }
        this.writer.writeRecord(vals);
        ++this.count;
    }

    public void write(RecordPack pack) throws IOException {
        Record record;
        RecordReader reader = pack.getRecordReader();
        while ((record = reader.read()) != null) {
            this.write(record);
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.writer.close();
            if (this.recordCounter != null) {
                this.recordCounter.increment(this.count);
            }
            if (this.byteCounter != null) {
                this.byteCounter.increment(this.getLen());
            }
        }
    }

    public long getLen() throws IOException {
        return this.outputFile.length();
    }
}

