/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred;

import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.counter.CounterGroup;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.local.common.DownloadMode;
import com.aliyun.odps.local.common.FileSplit;
import com.aliyun.odps.local.common.JobDirecotry;
import com.aliyun.odps.local.common.TableMeta;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.local.common.security.ApplicatitionType;
import com.aliyun.odps.local.common.security.SecurityClient;
import com.aliyun.odps.local.common.utils.DownloadUtils;
import com.aliyun.odps.local.common.utils.LocalRunUtils;
import com.aliyun.odps.local.common.utils.PartitionUtils;
import com.aliyun.odps.local.common.utils.SchemaUtils;
import com.aliyun.odps.mapred.JobRunner;
import com.aliyun.odps.mapred.JobStatus;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.RunningJob;
import com.aliyun.odps.mapred.TaskId;
import com.aliyun.odps.mapred.bridge.utils.Validator;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.conf.SessionState;
import com.aliyun.odps.mapred.local.JobCounter;
import com.aliyun.odps.mapred.local.LocalRunningJob;
import com.aliyun.odps.mapred.local.LocalTaskId;
import com.aliyun.odps.mapred.local.MapDriver;
import com.aliyun.odps.mapred.local.MapOutputBuffer;
import com.aliyun.odps.mapred.local.ReduceDriver;
import com.aliyun.odps.mapred.local.StageStatic;
import com.aliyun.odps.mapred.local.utils.LocalMRUtils;
import com.aliyun.odps.mapred.local.utils.LocalValidatorFactory;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.pipeline.Pipeline;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalJobRunner
implements JobRunner {
    private List<FileSplit> inputs;
    private WareHouse wareHouse;
    private JobDirecotry jobDirecotry;
    private Counters counters;
    private Odps odps;
    private BridgeJobConf conf;
    private Map<FileSplit, TableInfo> splitToTableInfo;
    private List<StageStatic> stageStaticList;
    private static final Log LOG = LogFactory.getLog(LocalJobRunner.class);
    public static Counter EMPTY_COUNTER;
    private Pipeline pipeline;

    public void initialize() {
        this.odps = SessionState.get().getOdps();
        String warehouseDir = System.getProperty("odps.runner.warehouseDir");
        this.wareHouse = StringUtils.isNotBlank((String)warehouseDir) ? WareHouse.getInstance((String)warehouseDir) : WareHouse.getInstance();
        WareHouse.init((Odps)this.odps, (Configuration)this.conf);
        LocalMRUtils.generateLocalMrTaskName();
        this.inputs = new ArrayList<FileSplit>();
        this.counters = new Counters();
        this.splitToTableInfo = new HashMap<FileSplit, TableInfo>();
        this.stageStaticList = new LinkedList<StageStatic>();
        this.jobDirecotry = new JobDirecotry();
        EMPTY_COUNTER = this.counters.findCounter((Enum)JobCounter.__EMPTY_WILL_NOT_SHOW);
        this.initSecurity();
    }

    private void initSecurity() {
        LinkedList<String> codeBase = new LinkedList<String>();
        String path = LocalJobRunner.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        path = path.substring(path.indexOf(":") + 1);
        codeBase.add(path);
        path = MapperBase.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        path = path.substring(path.indexOf(":") + 1);
        codeBase.add(path);
        path = BridgeJobConf.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        path = path.substring(path.indexOf(":") + 1);
        codeBase.add(path);
        HashMap<String, String> replacement = new HashMap<String, String>();
        replacement.put("\\$TEMP_HOME\\$", WareHouse.getInstance().getJobDirStr() + File.separator + "-");
        replacement.put("\\$WAREHOUSE_HOME\\$", WareHouse.getInstance().getWarehouseDir().getAbsolutePath() + File.separator + "-");
        boolean isSecurityEnabled = this.conf.getBoolean("odps.local.security.enable", false);
        boolean isJNIEnabled = this.conf.getBoolean("odps.local.security.jni.enable", false);
        String userDefinePolicy = this.conf.get("odps.local.user.define.policy", "");
        SecurityClient.init((ApplicatitionType)ApplicatitionType.MR, codeBase, replacement, (boolean)isSecurityEnabled, (boolean)isJNIEnabled, (String)userDefinePolicy);
    }

    public RunningJob submit() {
        try {
            this.initialize();
            this.runJob();
            return new LocalRunningJob(this.wareHouse.getJobName(), JobStatus.SUCCEEDED, this.counters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void runJob() throws IOException, OdpsException {
        this.pipeline = Pipeline.fromJobConf((JobConf)this.conf);
        LOG.info((Object)("Run mapreduce job in local mode, Type: " + (this.pipeline == null ? "MR" : "MRR") + ", Job ID: " + this.wareHouse.getJobName()));
        FileOutputStream fos = new FileOutputStream(this.jobDirecotry.getJobFile());
        this.conf.writeXml((OutputStream)fos);
        fos.close();
        LOG.info((Object)"Start to process input tables");
        this.processInputs();
        LOG.info((Object)"Finished process input tables");
        LOG.info((Object)"Start to process output tables");
        this.processOutputs();
        LOG.info((Object)"Finished process output tables");
        LOG.info((Object)"Start to process resources");
        this.processResources();
        LOG.info((Object)"Finished process resources");
        LOG.info((Object)"Start to fill tableInfo");
        this.fillTableInfo();
        LOG.info((Object)"Finished fill tableInfo");
        LOG.info((Object)"Start to validate configuration");
        Validator validator = LocalValidatorFactory.getValidator(this.conf);
        validator.validate();
        LOG.info((Object)"Finished validate configuration");
        try {
            SecurityClient.open();
            if (this.pipeline != null) {
                this.handlePipeMode();
            } else {
                this.handleNonPipeMode();
            }
        }
        catch (Exception ex) {
            throw new OdpsException(ex);
        }
        finally {
            SecurityClient.close();
        }
        this.moveOutputs();
        try {
            if (!this.wareHouse.isRetainTempData()) {
                FileUtils.deleteDirectory((File)this.jobDirecotry.getJobDir());
            }
        }
        catch (Exception exception) {
            LOG.warn((Object)exception.getMessage());
        }
        System.err.println();
        System.err.println("Summary:");
        this.printInputOutput();
        this.printStageStatic();
        this.printCounters();
        System.err.println("\nOK");
    }

    private void handlePipeMode() throws IOException {
        int mapCopyNum = 0;
        int reduceCopyNum = 0;
        mapCopyNum = this.inputs.size() > 0 ? this.inputs.size() : this.conf.getInt("odps.stage.mapper.num", 1);
        Pipeline.TransformNode pipeNode = this.pipeline.getFirstNode();
        reduceCopyNum = this.computeReduceNum(mapCopyNum, pipeNode);
        LOG.info((Object)("Start to run mappers, num: " + mapCopyNum));
        LocalTaskId taskId = new LocalTaskId("M1", 0, this.odps.getDefaultProject());
        StageStatic stageStatic = this.createStageStatic(taskId);
        stageStatic.setWorkerCount(mapCopyNum);
        MapOutputBuffer inputBuffer = new MapOutputBuffer((JobConf)this.conf, this.pipeline, taskId.getTaskId(), reduceCopyNum);
        for (int mapId = 0; mapId < mapCopyNum; ++mapId) {
            FileSplit split = this.inputs.size() > 0 ? this.inputs.get(mapId) : FileSplit.NullSplit;
            taskId = new LocalTaskId("M1", 0, this.odps.getDefaultProject());
            LOG.info((Object)("Start to run mapper, TaskId: " + (Object)((Object)taskId) + ", Input: " + this.splitToTableInfo.get(split)));
            MapDriver mapDriver = new MapDriver(this.conf, split, taskId, inputBuffer, this.counters, this.splitToTableInfo.get(split));
            mapDriver.run();
            this.setInputOutputRecordCount(stageStatic);
            LOG.info((Object)("Fininshed run mapper, TaskId: " + (Object)((Object)taskId) + ", Input: " + this.splitToTableInfo.get(split)));
        }
        LOG.info((Object)("Fininshed run all mappers, num: " + mapCopyNum));
        int reduceNodeCount = this.pipeline.getNodeNum() - 1;
        if (reduceNodeCount > 0) {
            int i;
            LOG.info((Object)("Start to run reduces, num: " + reduceNodeCount));
            stageStatic.setNextTaskId("R2_1");
            for (i = 0; i < reduceNodeCount; ++i) {
                taskId = new LocalTaskId("R" + (i + 2) + "_" + (i + 1), 0, this.odps.getDefaultProject());
                LOG.info((Object)("Start to run reduce, taskId: " + (Object)((Object)taskId)));
                stageStatic.setNextTaskId("R" + (i + 2) + "_" + (i + 1));
                stageStatic = this.createStageStatic(taskId);
                stageStatic.setWorkerCount(reduceCopyNum);
                int nextReduceCopyNum = this.computeReduceNum(reduceCopyNum, this.pipeline.getNode(i + 1));
                MapOutputBuffer outputBuffer = new MapOutputBuffer((JobConf)this.conf, this.pipeline, taskId.getTaskId(), nextReduceCopyNum);
                for (int j = 0; j < reduceCopyNum; ++j) {
                    taskId = new LocalTaskId("R" + (i + 2) + "_" + (i + 1), j, this.odps.getDefaultProject());
                    ReduceDriver reduceDriver = new ReduceDriver(this.conf, inputBuffer, outputBuffer, taskId, this.counters, j);
                    reduceDriver.run();
                    this.setInputOutputRecordCount(stageStatic);
                }
                inputBuffer = outputBuffer;
                reduceCopyNum = nextReduceCopyNum;
                LOG.info((Object)("Finished run reduce, taskId: " + (Object)((Object)taskId)));
            }
            stageStatic.setNextTaskId("R" + (i + 1) + "_" + i + "FS_9");
            LOG.info((Object)("Fininshed run all reduces, num: " + reduceNodeCount));
        } else {
            stageStatic.setNextTaskId("M1");
            LOG.info((Object)"This is a MapOnly job");
        }
    }

    private void handleNonPipeMode() throws IOException {
        int mapCopyNum = 0;
        int reduceCopyNum = 0;
        mapCopyNum = this.inputs.size() > 0 ? this.inputs.size() : this.conf.getInt("odps.stage.mapper.num", 1);
        reduceCopyNum = this.computeReduceNum(mapCopyNum, null);
        MapOutputBuffer buffer = new MapOutputBuffer((JobConf)this.conf, reduceCopyNum);
        LOG.info((Object)("Start to run mappers, num: " + mapCopyNum));
        LocalTaskId taskId = new LocalTaskId("M1", 0, this.odps.getDefaultProject());
        StageStatic stageStatic = this.createStageStatic(taskId);
        stageStatic.setWorkerCount(mapCopyNum);
        for (int mapId = 0; mapId < mapCopyNum; ++mapId) {
            FileSplit split = this.inputs.size() > 0 ? this.inputs.get(mapId) : FileSplit.NullSplit;
            taskId = new TaskId("M", mapId + 1);
            LOG.info((Object)("Start to run mapper, TaskId: " + (Object)((Object)taskId) + ", Input: " + this.splitToTableInfo.get(split)));
            MapDriver mapDriver = new MapDriver(this.conf, split, taskId, buffer, this.counters, this.splitToTableInfo.get(split));
            mapDriver.run();
            this.setInputOutputRecordCount(stageStatic);
            LOG.info((Object)("Fininshed run mapper, TaskId: " + (Object)((Object)taskId) + ", Input: " + this.splitToTableInfo.get(split)));
        }
        LOG.info((Object)("Fininshed run all mappers, num: " + mapCopyNum));
        if (reduceCopyNum > 0) {
            LOG.info((Object)("Start to run reduces, num: " + reduceCopyNum));
            taskId = new LocalTaskId("R2_1", 0, this.odps.getDefaultProject());
            stageStatic.setNextTaskId("R2_1");
            stageStatic = this.createStageStatic(taskId);
            stageStatic.setWorkerCount(reduceCopyNum);
            for (int reduceId = 0; reduceId < reduceCopyNum; ++reduceId) {
                taskId = new TaskId("R", reduceId);
                LOG.info((Object)("Start to run reduce, taskId: " + (Object)((Object)taskId)));
                ReduceDriver reduceDriver = new ReduceDriver(this.conf, buffer, null, taskId, this.counters, reduceId);
                reduceDriver.run();
                this.setInputOutputRecordCount(stageStatic);
                LOG.info((Object)("Finished run reduce, taskId: " + (Object)((Object)taskId)));
            }
            stageStatic.setNextTaskId("R2_1FS_9");
            LOG.info((Object)("Fininshed run all reduces, num: " + reduceCopyNum));
        } else {
            stageStatic.setNextTaskId("M1");
            LOG.info((Object)"This is a MapOnly job");
        }
    }

    private StageStatic createStageStatic(TaskId taskId) {
        StageStatic stageStatic = new StageStatic();
        this.stageStaticList.add(stageStatic);
        stageStatic.setTaskId(taskId.toString());
        return stageStatic;
    }

    private void setInputOutputRecordCount(StageStatic stageStatic) {
        stageStatic.setInputRecordCount(this.counters.findCounter((Enum)JobCounter.__EMPTY_INPUT_RECORD_COUNT).getValue());
        stageStatic.setOutputRecordCount(this.counters.findCounter((Enum)JobCounter.__EMPTY_OUTPUT_RECORD_COUNT).getValue());
        this.counters.findCounter((Enum)JobCounter.__EMPTY_INPUT_RECORD_COUNT).setValue(0L);
        this.counters.findCounter((Enum)JobCounter.__EMPTY_OUTPUT_RECORD_COUNT).setValue(0L);
    }

    private void processInput(TableInfo tableInfo) throws IOException, OdpsException {
        block9: {
            File tempDataDir;
            Column[] whReadFields;
            TableMeta whTblMeta;
            String[] readCols;
            block8: {
                if (tableInfo == null || StringUtils.isBlank((String)tableInfo.getTableName())) {
                    throw new RuntimeException("Invalid TableInfo: " + tableInfo);
                }
                if (StringUtils.isEmpty((String)tableInfo.getProjectName())) {
                    tableInfo.setProjectName(this.wareHouse.getOdps().getDefaultProject());
                }
                readCols = tableInfo.getCols();
                PartitionSpec expectParts = tableInfo.getPartitionSpec();
                if (!this.wareHouse.existsPartition(tableInfo.getProjectName(), tableInfo.getTableName(), expectParts) || this.wareHouse.getDownloadMode() == DownloadMode.ALWAYS) {
                    DownloadUtils.downloadTableSchemeAndData((Odps)this.odps, (TableInfo)tableInfo, (int)this.wareHouse.getLimitDownloadRecordCount(), (char)this.wareHouse.getInputColumnSeperator());
                    if (!this.wareHouse.existsPartition(tableInfo.getProjectName(), tableInfo.getTableName(), expectParts)) {
                        throw new RuntimeException(LocalRunUtils.getDownloadErrorMsg((String)tableInfo.toString()));
                    }
                }
                whTblMeta = this.wareHouse.getTableMeta(tableInfo.getProjectName(), tableInfo.getTableName());
                whReadFields = LocalRunUtils.getInputTableFields((TableMeta)whTblMeta, (String[])readCols);
                List whParts = this.wareHouse.getPartitions(tableInfo.getProjectName(), tableInfo.getTableName());
                if (whParts.size() <= 0) break block8;
                for (PartitionSpec partSpec : whParts) {
                    File whSrcDir;
                    if (!PartitionUtils.match((PartitionSpec)expectParts, (PartitionSpec)partSpec) || LocalRunUtils.listDataFiles((File)(whSrcDir = this.wareHouse.getPartitionDir(whTblMeta.getProjName(), whTblMeta.getTableName(), partSpec))).size() <= 0) continue;
                    File tempDataDir2 = this.jobDirecotry.getInputDir(this.wareHouse.getRelativePath(whTblMeta.getProjName(), whTblMeta.getTableName(), partSpec, new Object[0]));
                    File tempSchemeDir = this.jobDirecotry.getInputDir(this.wareHouse.getRelativePath(whTblMeta.getProjName(), whTblMeta.getTableName(), null, new Object[0]));
                    this.wareHouse.copyTable(whTblMeta.getProjName(), whTblMeta.getTableName(), partSpec, readCols, tempSchemeDir, this.wareHouse.getLimitDownloadRecordCount(), this.wareHouse.getInputColumnSeperator());
                    for (File file : LocalRunUtils.listDataFiles((File)tempDataDir2)) {
                        FileSplit split = new FileSplit(file, whReadFields, 0L, file.length());
                        this.splitToTableInfo.put(split, tableInfo);
                        this.inputs.add(split);
                    }
                }
                break block9;
            }
            if (tableInfo.getPartSpec() != null && tableInfo.getPartSpec().size() > 0) {
                throw new IOException("ODPS-0720121: Invalid table partSpectable " + tableInfo.getProjectName() + "." + tableInfo.getTableName() + " is not partitioned table");
            }
            File whSrcDir = this.wareHouse.getTableDir(whTblMeta.getProjName(), whTblMeta.getTableName());
            if (LocalRunUtils.listDataFiles((File)whSrcDir).size() <= 0) break block9;
            File tempSchemeDir = tempDataDir = this.jobDirecotry.getInputDir(this.wareHouse.getRelativePath(whTblMeta.getProjName(), whTblMeta.getTableName(), null, new Object[0]));
            this.wareHouse.copyTable(whTblMeta.getProjName(), whTblMeta.getTableName(), null, readCols, tempSchemeDir, this.wareHouse.getLimitDownloadRecordCount(), this.wareHouse.getInputColumnSeperator());
            for (File file : LocalRunUtils.listDataFiles((File)tempDataDir)) {
                FileSplit split = new FileSplit(file, whReadFields, 0L, file.length());
                this.splitToTableInfo.put(split, tableInfo);
                this.inputs.add(split);
            }
        }
    }

    private void processInputs() throws IOException, OdpsException {
        TableInfo[] inputTableInfos = InputUtils.getTables((JobConf)this.conf);
        if (inputTableInfos == null) {
            LOG.debug((Object)"No input tables to process");
            return;
        }
        for (TableInfo tableInfo : inputTableInfos) {
            LOG.debug((Object)("Start to process input table: " + tableInfo));
            this.processInput(tableInfo);
            LOG.debug((Object)("Finished process input table: " + tableInfo));
        }
        if (this.inputs.isEmpty()) {
            this.inputs.add(FileSplit.NullSplit);
        }
    }

    private void processResources() throws IOException, OdpsException {
        Object[] resources = this.conf.getResources();
        if (resources == null || resources.length == 0) {
            LOG.debug((Object)"No resources to process");
            return;
        }
        HashSet<String> names = new HashSet<String>(Arrays.asList(resources));
        LOG.info((Object)("Start to process resources: " + StringUtils.join((Object[])resources, (char)',')));
        URLClassLoader loader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        ArrayList<URL> cp = new ArrayList<URL>(Arrays.asList(loader.getURLs()));
        String curProjName = this.wareHouse.getOdps().getDefaultProject();
        File resDir = this.jobDirecotry.getResourceDir();
        for (String name : names) {
            String resName;
            List res = LocalRunUtils.parseResourceName((String)name, (String)curProjName);
            String projName = (String)res.get(0);
            if (!this.wareHouse.existsResource(projName, resName = (String)res.get(1)) || this.wareHouse.getDownloadMode() == DownloadMode.ALWAYS) {
                DownloadUtils.downloadResource((Odps)this.odps, (String)projName, (String)resName, (int)this.wareHouse.getLimitDownloadRecordCount(), (char)this.wareHouse.getInputColumnSeperator());
            }
            this.wareHouse.copyResource(projName, resName, resDir, this.wareHouse.getLimitDownloadRecordCount(), this.wareHouse.getInputColumnSeperator());
            cp.add(new File(resDir, resName).toURI().toURL());
        }
        URLClassLoader newLoader = new URLClassLoader(cp.toArray(new URL[0]), (ClassLoader)loader);
        Thread.currentThread().setContextClassLoader(newLoader);
        this.conf.setClassLoader((ClassLoader)newLoader);
    }

    private void processOutputs() throws IOException {
        TableInfo[] outputs = OutputUtils.getTables((JobConf)this.conf);
        if (outputs == null || outputs.length == 0) {
            LOG.debug((Object)"No output tables to process");
            return;
        }
        for (TableInfo tableInfo : outputs) {
            if (StringUtils.isBlank((String)tableInfo.getProjectName())) {
                tableInfo.setProjectName(this.wareHouse.getOdps().getDefaultProject());
            }
            File tableDirInJobDir = this.jobDirecotry.getOutputDir(tableInfo.getLabel());
            tableDirInJobDir.mkdirs();
            TableMeta tblMeta = null;
            if (this.wareHouse.existsTable(tableInfo.getProjectName(), tableInfo.getTableName()) && this.wareHouse.getDownloadMode() != DownloadMode.ALWAYS) {
                tblMeta = this.wareHouse.getTableMeta(tableInfo.getProjectName(), tableInfo.getTableName());
            } else {
                tblMeta = DownloadUtils.downloadTableInfo((Odps)this.odps, (TableInfo)tableInfo);
                File tableDirInWarehouse = this.wareHouse.getTableDir(tableInfo.getProjectName(), tableInfo.getTableName());
                tableDirInWarehouse.mkdirs();
                SchemaUtils.generateSchemaFile((TableMeta)tblMeta, null, (File)tableDirInWarehouse);
            }
            SchemaUtils.generateSchemaFile((TableMeta)tblMeta, null, (File)tableDirInJobDir);
            this.conf.setOutputSchema(tblMeta.getCols(), tableInfo.getLabel());
        }
    }

    private void fillTableInfo() throws IOException {
        String colName;
        int k;
        Column[] columns;
        Column[] schema;
        TableInfo info;
        TableInfo[] infos = new TableInfo[this.splitToTableInfo.size()];
        this.splitToTableInfo.values().toArray(infos);
        String project = this.wareHouse.getOdps().getDefaultProject();
        for (FileSplit key : this.splitToTableInfo.keySet()) {
            info = this.splitToTableInfo.get(key);
            if (info.getProjectName() == null) {
                info.setProjectName(project);
            }
            schema = this.wareHouse.getTableMeta(info.getProjectName(), info.getTableName()).getCols();
            if (info.getCols() == null) {
                this.conf.setInputSchema(info, schema);
                info.setCols(SchemaUtils.getColumnNames((Column[])schema));
                continue;
            }
            columns = new Column[info.getCols().length];
            block1: for (k = 0; k < info.getCols().length; ++k) {
                colName = info.getCols()[k];
                for (Column c : schema) {
                    if (!c.getName().equalsIgnoreCase(colName)) continue;
                    columns[k] = c;
                    continue block1;
                }
            }
            this.conf.setInputSchema(info, columns);
        }
        infos = InputUtils.getTables((JobConf)this.conf);
        if (infos != null) {
            boolean changed = false;
            for (int i = 0; i < infos.length; ++i) {
                info = infos[i];
                if (info.getProjectName() == null) {
                    changed = true;
                    info.setProjectName(project);
                }
                schema = this.wareHouse.getTableMeta(info.getProjectName(), info.getTableName()).getCols();
                if (info.getCols() == null) {
                    changed = true;
                    this.conf.setInputSchema(info, schema);
                    info.setCols(SchemaUtils.getColumnNames((Column[])schema));
                } else {
                    columns = new Column[info.getCols().length];
                    block4: for (k = 0; k < info.getCols().length; ++k) {
                        colName = info.getCols()[k];
                        for (Column c : schema) {
                            if (!c.getName().equalsIgnoreCase(colName)) continue;
                            columns[k] = c;
                            continue block4;
                        }
                    }
                    this.conf.setInputSchema(info, columns);
                }
                infos[i] = info;
            }
            if (changed) {
                InputUtils.setTables((TableInfo[])infos, (JobConf)this.conf);
            }
        }
        if ((infos = OutputUtils.getTables((JobConf)this.conf)) == null) {
            this.conf.setOutputSchema(new Column[]{new Column("nil", OdpsType.STRING)}, "__default__");
        } else {
            for (TableInfo info2 : infos) {
                if (info2.getProjectName() == null) {
                    info2.setProjectName(project);
                }
                Column[] schema2 = this.wareHouse.getTableMeta(info2.getProjectName(), info2.getTableName()).getCols();
                info2.setCols(SchemaUtils.getColumnNames((Column[])schema2));
                this.conf.setOutputSchema(schema2, info2.getLabel());
            }
            OutputUtils.setTables((TableInfo[])infos, (JobConf)this.conf);
        }
    }

    private void moveOutputs() throws IOException {
        TableInfo[] output = OutputUtils.getTables((JobConf)this.conf);
        if (output == null) {
            return;
        }
        for (TableInfo table : output) {
            String label = table.getLabel();
            String projName = table.getProjectName();
            if (projName == null) {
                projName = this.wareHouse.getOdps().getDefaultProject();
            }
            String tblName = table.getTableName();
            LinkedHashMap partSpec = table.getPartSpec();
            File tempTblDir = this.jobDirecotry.getOutputDir(table.getLabel());
            File whOutputDir = this.wareHouse.createPartitionDir(projName, tblName, PartitionUtils.convert((Map)partSpec));
            if (this.wareHouse.existsTable(projName, tblName)) {
                LOG.info((Object)("Reload warehouse table:" + tblName));
                LocalRunUtils.removeDataFiles((File)whOutputDir);
                this.wareHouse.copyDataFiles(tempTblDir, null, whOutputDir, this.wareHouse.getInputColumnSeperator());
                continue;
            }
            LOG.info((Object)("Copy output to warehouse: label=" + label + " -> " + whOutputDir.getAbsolutePath()));
            File whOutputTableDir = this.wareHouse.getTableDir(projName, tblName);
            FileUtils.copyDirectory((File)tempTblDir, (File)whOutputTableDir, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String filename = pathname.getName();
                    return filename.equals("__schema__");
                }
            });
            FileUtils.copyDirectory((File)tempTblDir, (File)whOutputDir, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String filename = pathname.getName();
                    return !filename.equals("__schema__");
                }
            });
        }
    }

    private int computeReduceNum(int mapNum, Pipeline.TransformNode pipeNode) throws IOException {
        int reduceNum = 1;
        reduceNum = pipeNode != null ? (pipeNode.getNextNode() != null ? pipeNode.getNextNode().getNumTasks() : pipeNode.getNumTasks()) : (this.wareHouse.caintainsKey("odps.stage.reducer.num") ? this.conf.getNumReduceTasks() : Math.max(1, mapNum / 4));
        if (reduceNum < 0) {
            throw new IOException("ODPS-0720251: Num of reduce instance is invalid - reduce num cann't be less than 0");
        }
        if (reduceNum != this.conf.getNumReduceTasks()) {
            LOG.info((Object)("change reduce num from " + this.conf.getNumReduceTasks() + " to " + reduceNum));
        }
        this.conf.setNumReduceTasks(reduceNum);
        return reduceNum;
    }

    private void printInputOutput() {
        String parts;
        StringBuffer sb = new StringBuffer();
        System.err.println("Inputs:");
        TableInfo[] tableInfos = InputUtils.getTables((JobConf)this.conf);
        if (tableInfos != null) {
            for (TableInfo tableInfo : tableInfos) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (tableInfo.getProjectName() != null) {
                    sb.append(tableInfo.getProjectName());
                } else {
                    sb.append(this.odps.getDefaultProject());
                }
                sb.append(".");
                sb.append(tableInfo.getTableName());
                parts = tableInfo.getPartPath();
                if (parts == null || parts.trim().isEmpty()) continue;
                sb.append("/");
                if (parts.endsWith("/")) {
                    parts = parts.substring(0, parts.length() - 1);
                }
                sb.append(parts);
            }
        }
        if (sb.length() > 0) {
            System.err.println("\t" + sb.toString());
            sb.delete(0, sb.length());
        }
        System.err.println("Outputs:");
        tableInfos = OutputUtils.getTables((JobConf)this.conf);
        if (tableInfos != null) {
            for (TableInfo tableInfo : tableInfos) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (tableInfo.getProjectName() != null) {
                    sb.append(tableInfo.getProjectName());
                } else {
                    sb.append(this.odps.getDefaultProject());
                }
                sb.append(".");
                sb.append(tableInfo.getTableName());
                parts = tableInfo.getPartPath();
                if (parts == null || parts.trim().isEmpty()) continue;
                sb.append("/");
                if (parts.endsWith("/")) {
                    parts = parts.substring(0, parts.length() - 1);
                }
                sb.append(parts);
            }
        }
        if (sb.length() > 0) {
            System.err.println("\t" + sb.toString());
            sb.delete(0, sb.length());
        }
    }

    private void printStageStatic() {
        StringBuilder sb = new StringBuilder();
        for (StageStatic item : this.stageStaticList) {
            sb.append("\n" + item.getTaskId());
            sb.append("\n\tWorker Count: " + item.getWorkerCount());
            sb.append("\n\tInput Records: ");
            sb.append("\n\t\tinput: ");
            sb.append(item.getTotalInputRecords());
            sb.append(" (min: ");
            sb.append(item.getMinInputRecords());
            sb.append(", max: ");
            sb.append(item.getMaxInputRecords());
            sb.append(", avg: ");
            sb.append(item.getAvgInputRecords());
            sb.append(")");
            sb.append("\n\tOutput Records: ");
            sb.append("\n\t\t");
            sb.append(item.getNextTaskId());
            sb.append(": ");
            sb.append(item.getTotalOutputRecords());
            sb.append(" (min: ");
            sb.append(item.getMinOutputRecords());
            sb.append(", max: ");
            sb.append(item.getMaxOutputRecords());
            sb.append(", avg: ");
            sb.append(item.getAvgOutputRecords());
            sb.append(")");
        }
        System.err.println(sb.toString());
    }

    private void printCounters() {
        int totalCount = 0;
        int frameWorkCounterCount = 0;
        int jobCounterCount = 0;
        int userCounterCount = 0;
        for (CounterGroup group : this.counters) {
            for (Counter counter : group) {
                if (counter.getDisplayName().startsWith("__EMPTY_")) continue;
                if (group.getDisplayName().equals(JobCounter.class.getName())) {
                    ++frameWorkCounterCount;
                } else if (group.getDisplayName().equals("com.aliyun.odps.mapred.local.Counter.JobCounter")) {
                    ++jobCounterCount;
                } else {
                    ++userCounterCount;
                }
                ++totalCount;
            }
        }
        StringBuilder sb = new StringBuilder("Counters: " + totalCount);
        sb.append("\n\tMap-Reduce Framework: " + frameWorkCounterCount);
        for (CounterGroup group : this.counters) {
            if (!group.getDisplayName().equals(JobCounter.class.getName())) continue;
            for (Counter counter : group) {
                if (counter.getDisplayName().startsWith("__EMPTY_")) continue;
                sb.append("\n\t\t" + counter.getDisplayName() + "=" + counter.getValue());
            }
        }
        sb.append("\n\tUser Defined Counters: " + userCounterCount);
        for (CounterGroup group : this.counters) {
            if (group.getDisplayName().equals(JobCounter.class.getName()) || group.getDisplayName().equals("com.aliyun.odps.mapred.local.Counter.JobCounter")) continue;
            sb.append("\n\t\t" + group.getDisplayName());
            for (Counter counter : group) {
                if (counter.getDisplayName().equals(JobCounter.__EMPTY_WILL_NOT_SHOW.toString())) continue;
                sb.append("\n\t\t\t" + counter.getDisplayName() + "=" + counter.getValue());
            }
        }
        System.err.println(sb.toString().toLowerCase());
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = new BridgeJobConf(conf);
    }
}

