/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Partition;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.CommandWithOptionP;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShowPartitionsCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"show", "list", "ls", "partition", "partitions"};
    private Coordinate coordinate;
    private static final Pattern PREFIX = Pattern.compile("\\s*(SHOW|LS|LIST)\\s+PARTITIONS\\s+.*", 34);
    private static final Pattern PATTERN = Pattern.compile("\\s*SHOW\\s+PARTITIONS\\s+" + Coordinate.TABLE_PATTERN, 34);
    private static final Pattern PUBLIC_PATTERN = Pattern.compile("\\s*(LS|LIST)\\s+PARTITIONS\\s+" + Coordinate.PUB_TABLE_PATTERN, 34);
    private static final Pattern PUBLIC_PREFIX_PATTERN = Pattern.compile("\\s*(LS|LIST)\\s+PARTITIONS\\s+(.*)", 34);

    public static void printUsage(PrintStream stream, ExecutionContext ctx) {
        if (ctx.isProjectMode()) {
            stream.println("Usage: show partitions [<project name>.]<table name> [partition(<spec>)]");
        } else {
            stream.println("Usage: show partitions [[<project name>.]<schema name>.]<table name> [partition(<spec>)]");
        }
    }

    public ShowPartitionsCommand(String cmd, ExecutionContext cxt, Coordinate coordinate) {
        super(cmd, cxt);
        this.coordinate = coordinate;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        this.coordinate.interpretByCtx(this.getContext());
        String project = this.coordinate.getProjectName();
        String schema = this.coordinate.getSchemaName();
        String table = this.coordinate.getObjectName();
        String partition = this.coordinate.getPartitionSpec();
        Odps odps = OdpsConnectionFactory.createOdps((ExecutionContext)this.getContext());
        DefaultOutputWriter writer = this.getContext().getOutputWriter();
        odps.projects().get(project).executeIfEpv2(() -> {
            String sql;
            HashMap<String, String> hints = new HashMap<String, String>();
            if (schema == null) {
                sql = "show partitions " + project + "." + table;
            } else {
                hints.put("odps.namespace.schema", "true");
                sql = "show partitions " + project + "." + schema + "." + table;
            }
            if (partition != null) {
                sql = sql + " partition(" + partition + ")";
            }
            Instance instance = SQLTask.run((Odps)odps, (String)odps.getDefaultProject(), (String)(sql + ";"), hints, null);
            instance.waitForSuccess();
            String result = ((Instance.InstanceResultModel.TaskResult)instance.getRawTaskResults().get(0)).getResult().getString();
            writer.writeResult("");
            writer.writeResult(result);
            writer.writeError("\nOK");
            return null;
        }, () -> {
            Table t = odps.tables().get(project, schema, table);
            Iterator parts = partition != null ? t.getPartitionIterator(new PartitionSpec(partition)) : t.getPartitionIterator();
            writer.writeResult("");
            while (parts.hasNext()) {
                ODPSConsoleUtils.checkThreadInterrupted();
                String p = ((Partition)parts.next()).getPartitionSpec().toString();
                p = p.replaceAll("'", "");
                p = p.replaceAll(",", "/");
                writer.writeResult(p);
            }
            writer.writeError("\nOK");
            return null;
        });
    }

    public static ShowPartitionsCommand parse(String cmd, ExecutionContext cxt) throws ODPSConsoleException {
        if (!PREFIX.matcher(cmd).matches()) {
            return null;
        }
        Coordinate coordinate = ShowPartitionsCommand.parseListPartitionsCommand(cmd, cxt);
        if (coordinate == null) {
            Matcher showMatcher = PATTERN.matcher(cmd);
            if (!showMatcher.matches()) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
            }
            coordinate = Coordinate.getTableCoordinate((Matcher)showMatcher, (ExecutionContext)cxt);
        }
        return new ShowPartitionsCommand(cmd, cxt, coordinate);
    }

    public static Coordinate parseListPartitionsCommand(String cmdTxt, ExecutionContext ctx) throws ODPSConsoleException {
        Matcher preMatcher = PUBLIC_PREFIX_PATTERN.matcher(cmdTxt);
        if (!preMatcher.matches()) {
            return null;
        }
        CommandWithOptionP cmd = new CommandWithOptionP(cmdTxt);
        Matcher lsMatcher = PUBLIC_PATTERN.matcher(cmdTxt = cmd.getCmd());
        if (!lsMatcher.matches()) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        }
        String table = lsMatcher.group("table");
        String partitionSpec = lsMatcher.group("partition");
        Coordinate coordinate = Coordinate.getCoordinateABC((String)table);
        if (cmd.hasOptionP() && !table.contains(".")) {
            coordinate = Coordinate.getCoordinateOptionP((String)cmd.getProjectValue(), (String)table);
        }
        coordinate.setPartitionSpec(partitionSpec);
        return coordinate;
    }
}

