/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.BearerTokenAccount;
import com.aliyun.odps.commons.transport.DefaultTransport;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.transport.Transport;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.DirectCommand;
import com.aliyun.openservices.odps.console.utils.ExtProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;

public class HttpSubmitCommand
extends DirectCommand {
    public static final String[] HELP_TAGS = new String[]{"http"};
    String fileName;
    HttpMethod method;
    String url;
    String headerFileName;
    String token;
    Map<String, String> parameters;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: http <method> <url> [-header=file] [-content=file] [-token=logview_token]");
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getHeaderFileName() {
        return this.headerFileName;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public HttpSubmitCommand(String commandText, ExecutionContext context, HttpMethod method, String url) {
        super(commandText, context);
        this.method = method;
        this.url = url;
    }

    static Options initOptions() {
        Options opts = new Options();
        Option header_file = new Option("h", "header", true, "header file name");
        header_file.setRequired(false);
        Option content_file = new Option("c", "content", true, "content file name");
        content_file.setRequired(false);
        Option token = new Option("t", "token", true, "logview token");
        content_file.setRequired(false);
        opts.addOption(header_file);
        opts.addOption(content_file);
        opts.addOption(token);
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws OdpsException, ODPSConsoleException {
        File file;
        RestClient client;
        if (!StringUtils.isNullOrEmpty((String)this.token)) {
            client = new RestClient((Transport)new DefaultTransport());
            client.setEndpoint(this.getContext().getEndpoint());
            client.setAccount((Account)new BearerTokenAccount(this.token));
        } else {
            client = this.getCurrentOdps().getRestClient();
        }
        FileInputStream content = null;
        long contentLength = 0L;
        HashMap<String, String> headers = null;
        if (this.getHeaderFileName() != null) {
            headers = new HashMap<String, String>();
            file = new File(this.getHeaderFileName());
            if (!file.exists()) {
                throw new ODPSConsoleException("file not exist.");
            }
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(file);
                ExtProperties properties = new ExtProperties();
                properties.load(fileInput);
                Enumeration<Object> enuKeys = properties.keys();
                while (enuKeys.hasMoreElements()) {
                    String key = (String)enuKeys.nextElement();
                    String value = properties.getProperty(key);
                    if (StringUtils.isNullOrEmpty((String)key) || StringUtils.isNullOrEmpty((String)value)) continue;
                    headers.put(key, value);
                }
            }
            catch (IOException e) {
                try {
                    throw new ODPSConsoleException("can not read file.");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInput);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fileInput);
        }
        if (this.getFileName() != null) {
            file = new File(this.getFileName());
            if (!file.exists()) {
                throw new ODPSConsoleException("file not exist.");
            }
            contentLength = file.length();
            try {
                content = new FileInputStream(file);
            }
            catch (Exception e) {
                throw new ODPSConsoleException("can not read file.");
            }
        }
        try {
            Response response = client.request(this.url, this.method.toString(), this.parameters, headers, content, contentLength);
            try {
                Map resHeaders = response.getHeaders();
                for (String key : resHeaders.keySet()) {
                    String value = (String)resHeaders.get(key);
                    System.out.println(key + ": " + value);
                }
                System.out.println("");
                System.out.println(new String(response.getBody(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(content);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)content);
    }

    public static HttpSubmitCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        if ((commandString = commandString.trim()).toUpperCase().matches("HTTP[\\s\\S]*")) {
            String[] options = commandString.split("\\s+");
            if (options.length < 3 || options.length > 6) {
                throw new ODPSConsoleException("illegal parameter");
            }
            HttpMethod method = null;
            try {
                method = HttpMethod.valueOf(options[1].toUpperCase());
            }
            catch (Exception e) {
                throw new ODPSConsoleException("illegal http method");
            }
            String[] splits = options[2].split("\\?", 2);
            String url = splits[0];
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (splits.length == 2) {
                String[] paras = splits[1].split("&");
                for (int i = 0; i < paras.length; ++i) {
                    String[] keyValue = paras[i].split("=", 2);
                    parameters.put(keyValue[0], keyValue.length == 1 ? null : keyValue[1]);
                }
            }
            HttpSubmitCommand command = new HttpSubmitCommand(commandString, sessionContext, method, url);
            command.parameters = parameters;
            if (options.length > 3) {
                CommandLine cl;
                Options opts = HttpSubmitCommand.initOptions();
                GnuParser clp = new GnuParser();
                try {
                    cl = clp.parse(opts, options, false);
                }
                catch (Exception e) {
                    throw new ODPSConsoleException("Unknown exception from client - " + e.getMessage(), (Throwable)e);
                }
                if (cl.hasOption("header")) {
                    command.headerFileName = cl.getOptionValue("header");
                }
                if (cl.hasOption("content")) {
                    command.fileName = cl.getOptionValue("content");
                }
                if (cl.hasOption("token")) {
                    command.token = cl.getOptionValue("token");
                }
                if (cl.getArgs().length > 3) {
                    throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. too much parameters");
                }
            }
            return command;
        }
        return null;
    }

    private static enum HttpMethod {
        DELETE,
        GET,
        HEAD,
        POST,
        PUT;

    }
}

