/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Project;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.antlr.AntlrObject;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;

public class DescribeProjectCommand
extends AbstractCommand {
    private final String projectName;
    private boolean extended;
    public static final String[] HELP_TAGS = new String[]{"describe", "desc", "project"};

    public DescribeProjectCommand(String projectName, boolean extended, String cmd, ExecutionContext ctx) {
        super(cmd, ctx);
        this.projectName = projectName;
        this.extended = extended;
    }

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: describe|desc project [-extended] <projectname>");
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("extended", false, "need extended properties");
        return options;
    }

    public static AbstractCommand parse(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        if (cmd == null || ctx == null) {
            return null;
        }
        String[] tokens = new AntlrObject(cmd).getTokenStringArray();
        if (tokens.length < 2) {
            return null;
        }
        if (!"DESC".equalsIgnoreCase(tokens[0]) && !"DESCRIBE".equalsIgnoreCase(tokens[0])) {
            return null;
        }
        if (!"PROJECT".equalsIgnoreCase(tokens[1])) {
            return null;
        }
        CommandLine parser = null;
        try {
            parser = new GnuParser().parse(DescribeProjectCommand.getOptions(), tokens);
        }
        catch (ParseException e) {
            throw new ODPSConsoleException(e.getMessage(), (Throwable)e);
        }
        boolean extended = parser.hasOption("extended");
        if (parser.getArgList().size() != 3) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        }
        String projectName = parser.getArgs()[2];
        return new DescribeProjectCommand(projectName, extended, cmd, ctx);
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        Project prj = odps.projects().get(this.projectName);
        prj.reload();
        ExecutionContext context = this.getContext();
        PrintWriter out = new PrintWriter(System.out);
        String formatPattern = "%-60s%-40s\n";
        out.printf(formatPattern, "Name", prj.getName());
        out.printf(formatPattern, "Description", prj.getComment());
        out.printf(formatPattern, "Type", prj.getType());
        out.printf(formatPattern, "Owner", prj.getOwner());
        out.printf(formatPattern, "CreatedTime", prj.getCreatedTime());
        Map properties = prj.getProperties();
        if (properties != null) {
            out.println("\nProperties:");
            for (Map.Entry e : properties.entrySet()) {
                out.printf(formatPattern, e.getKey(), e.getValue());
            }
        }
        if (this.extended) {
            TreeMap extendedProperties = new TreeMap(prj.getExtendedProperties());
            out.println("\nExtended Properties:");
            if (extendedProperties != null) {
                for (Map.Entry e : extendedProperties.entrySet()) {
                    String humanValue;
                    String value = (String)e.getValue();
                    if (((String)e.getKey()).toLowerCase().endsWith("size") && StringUtils.isNumeric((String)value) && !(humanValue = com.aliyun.odps.utils.StringUtils.humanReadableInt((long)Long.parseLong((String)e.getValue()))).equalsIgnoreCase(value)) {
                        value = String.format("%s (%s)", humanValue, value);
                    }
                    out.printf(formatPattern, e.getKey(), value);
                }
            }
        }
        out.flush();
    }
}

