/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.antlr.AntlrObject;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;

public class DescribeInstanceCommand
extends AbstractCommand {
    private String projectName;
    private String instanceId;
    public static final String[] HELP_TAGS = new String[]{"describe", "desc", "instance"};
    private static Pattern PATTERN = Pattern.compile("\\s*(DESCRIBE|DESC)\\s+INSTANCE(\\s+(.*))?", 2);

    public DescribeInstanceCommand(String instanceId, String projectName, String cmd, ExecutionContext ctx) {
        super(cmd, ctx);
        this.instanceId = instanceId;
        this.projectName = projectName;
    }

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: describe|desc instance <instanceID>");
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("p", "project", true, "user spec project");
        return options;
    }

    private static CommandLine getCommandLine(String[] args) throws ODPSConsoleException {
        try {
            GnuParser parser = new GnuParser();
            return parser.parse(DescribeInstanceCommand.getOptions(), args);
        }
        catch (ParseException e) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  " + e.getMessage(), (Throwable)e);
        }
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        if (this.projectName == null) {
            this.projectName = odps.getDefaultProject();
        }
        if (!odps.instances().exists(this.projectName, this.instanceId)) {
            throw new ODPSConsoleException("Instance not found : " + this.instanceId);
        }
        Instance i = odps.instances().get(this.projectName, this.instanceId);
        PrintWriter out = new PrintWriter(System.out);
        out.printf("%-40s%-40s\n", "ID", i.getId());
        out.printf("%-40s%-40s\n", "Owner", i.getOwner());
        out.printf("%-40s%-40s\n", "StartTime", ODPSConsoleUtils.formatDate((Date)i.getStartTime()));
        if (i.getEndTime() != null) {
            out.printf("%-40s%-40s\n", "EndTime", ODPSConsoleUtils.formatDate((Date)i.getEndTime()));
        }
        out.printf("%-40s%-40s\n", "Status", i.getStatus());
        for (Map.Entry entry : i.getTaskStatus().entrySet()) {
            out.printf("%-40s%-40s\n", entry.getKey(), StringUtils.capitalize((String)((Instance.TaskStatus)entry.getValue()).getStatus().toString().toLowerCase()));
        }
        for (Task task : i.getTasks()) {
            out.printf("%-40s%-40s\n", "Query", task.getCommandText());
        }
        out.flush();
    }

    public static DescribeInstanceCommand parse(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        if (cmd == null || ctx == null) {
            return null;
        }
        Matcher m = PATTERN.matcher(cmd);
        boolean match = m.matches();
        if (!match) {
            return null;
        }
        String input = m.group(3);
        if (input == null) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  need specify one Instance Id.");
        }
        String[] inputs = new AntlrObject(input).getTokenStringArray();
        CommandLine commandLine = DescribeInstanceCommand.getCommandLine(inputs);
        String projectName = null;
        if (commandLine.hasOption("p")) {
            projectName = commandLine.getOptionValue("p");
        }
        if (commandLine.getArgList().size() != 1) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  Invalid Instance Id.");
        }
        String resourceName = commandLine.getArgs()[0];
        return new DescribeInstanceCommand(resourceName, projectName, cmd, ctx);
    }
}

