/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.utils;

import io.netty.channel.Channel;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedNettyChannelPool {
    private static final Logger logger = LoggerFactory.getLogger(FixedNettyChannelPool.class);
    private final Semaphore availableChannels;
    private final ChannelFactory channelFactory;
    private static final int DEFAULT_RETRY_TIMES = 3;
    private final Map<Channel, Integer> channels = new ConcurrentHashMap<Channel, Integer>();
    private int retryTimes = 3;
    private final boolean noLimit;

    public FixedNettyChannelPool(int maxChannels, ChannelFactory channelFactory) {
        this.noLimit = maxChannels <= 0;
        this.availableChannels = new Semaphore(maxChannels, true);
        this.channelFactory = channelFactory;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public Channel acquire(long timeouts, TimeUnit timeUnit) throws InterruptedException, IOException {
        if (this.noLimit) {
            return this.acquireChannel();
        }
        if (this.availableChannels.tryAcquire(timeouts, timeUnit)) {
            try {
                return this.acquireChannel();
            }
            catch (Throwable e) {
                this.availableChannels.release();
                throw e;
            }
        }
        throw new IOException("Failed to acquire an active channel with specified timeout");
    }

    public Channel acquire() throws InterruptedException, IOException {
        if (this.noLimit) {
            return this.acquireChannel();
        }
        this.availableChannels.acquire();
        try {
            return this.acquireChannel();
        }
        catch (Throwable e) {
            this.availableChannels.release();
            throw e;
        }
    }

    private Channel acquireChannel() throws IOException {
        Channel newChannel = this.createChannel();
        if (newChannel != null && newChannel.isActive()) {
            this.channels.put(newChannel, 1);
            return newChannel;
        }
        throw new IOException("Failed to create an active channel");
    }

    private Channel createChannel() {
        for (int retry = 0; retry < this.retryTimes; ++retry) {
            try {
                Channel channel = this.channelFactory.create();
                if (channel == null) continue;
                return channel;
            }
            catch (Throwable e) {
                logger.warn("Attempt {} to create channel failed: {}", (Object)(retry + 1), (Object)e.getMessage());
            }
        }
        return null;
    }

    public void release(Channel channel) {
        if (!this.noLimit && this.channels.remove(channel) != null) {
            this.availableChannels.release();
        }
    }

    public int getAcquiredChannelCount() {
        return this.availableChannels.getQueueLength();
    }

    public static interface ChannelFactory {
        public Channel create() throws Exception;
    }
}

