/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.impl.StreamUploadSessionImpl;
import com.aliyun.odps.tunnel.io.Checksum;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.FlushResultImpl;
import com.aliyun.odps.tunnel.io.ProtobufRecordPack;
import java.io.IOException;

public class StreamRecordPackImpl
implements TableTunnel.StreamRecordPack {
    private ProtobufRecordPack pack;
    private StreamUploadSessionImpl session;
    private boolean flushing = false;

    public StreamRecordPackImpl(StreamUploadSessionImpl session, CompressOption option) throws IOException {
        this.session = session;
        this.pack = new ProtobufRecordPack(session.getSchema(), new Checksum(), 0, option);
    }

    @Override
    public void append(Record record) throws IOException {
        if (this.flushing) {
            throw new IOException(new TunnelException("There's an unsuccessful flush called, you should call flush to retry or call reset to drop the data"));
        }
        this.pack.append(record);
    }

    @Override
    public long getRecordCount() {
        return this.pack.getSize();
    }

    @Override
    public long getDataSize() {
        return this.pack.getTotalBytes();
    }

    @Override
    public String flush() throws IOException {
        return this.flush(new TableTunnel.FlushOption()).getTraceId();
    }

    @Override
    public TableTunnel.FlushResult flush(TableTunnel.FlushOption opt) throws IOException {
        this.flushing = true;
        long recordCount = this.pack.getSize();
        this.pack.checkTransConsistency(false);
        this.pack.complete();
        String id = this.session.writeBlock(this.pack, opt.getTimeout());
        long size = this.pack.getTotalBytes();
        this.reset();
        return new FlushResultImpl(id, size, recordCount);
    }

    @Override
    public void reset() throws IOException {
        this.pack.reset();
        this.flushing = false;
    }
}

