/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.hasher;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.tunnel.hasher.DefaultHashFactory;
import com.aliyun.odps.tunnel.hasher.HasherFactory;
import com.aliyun.odps.tunnel.hasher.LegacyHashFactory;
import com.aliyun.odps.tunnel.hasher.OdpsHasher;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TypeHasher {
    private static final Map<String, HasherFactory> versionsMap = new LinkedHashMap<String, HasherFactory>();
    private static final String defaultVersion = "default";
    private static final String legacyVersion = "legacy";

    public static String getDefaultVersion() {
        return defaultVersion;
    }

    public static String getLegacyVersion() {
        return legacyVersion;
    }

    public static String getVersion(String version) {
        if (version == null || version.isEmpty() || !versionsMap.containsKey(version)) {
            return TypeHasher.getDefaultVersion();
        }
        return version;
    }

    public static int hash(OdpsType type, Object value) {
        OdpsHasher hasher = TypeHasher.getHasher(type, null);
        return hasher.hash(hasher.normalizeType(value));
    }

    public static int hash(OdpsType type, Object value, String version) {
        OdpsHasher hasher = TypeHasher.getHasher(type, version);
        return hasher.hash(hasher.normalizeType(value));
    }

    static OdpsHasher getHasher(OdpsType type) {
        return TypeHasher.getHasher(type, null);
    }

    static OdpsHasher getHasher(OdpsType type, String version) {
        HasherFactory factory;
        if (version == null || version.isEmpty()) {
            version = defaultVersion;
        }
        if ((factory = versionsMap.get(version)) == null) {
            throw new RuntimeException("Not supported hash function version:" + version);
        }
        OdpsHasher hasher = factory.getHasher(type);
        if (hasher == null) {
            throw new RuntimeException("Not supported hash function type:" + type.name());
        }
        return hasher;
    }

    public static int CombineHashVal(int[] hashVals) {
        int combineHashVal = 0;
        for (int hashVal : hashVals) {
            combineHashVal += hashVal;
        }
        return combineHashVal ^ combineHashVal >> 8;
    }

    public static int CombineHashVal(List<Integer> hashVals) {
        int combineHashVal = 0;
        for (int hashVal : hashVals) {
            combineHashVal += hashVal;
        }
        return combineHashVal ^ combineHashVal >> 8;
    }

    static {
        versionsMap.put(defaultVersion, new DefaultHashFactory());
        versionsMap.put(legacyVersion, new LegacyHashFactory());
    }
}

