/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi.utils;

import com.aliyun.odps.sqa.commandapi.antlr.sql.OdpsLexer;
import com.aliyun.odps.sqa.commandapi.antlr.sql.OdpsParser;
import com.aliyun.odps.sqa.commandapi.antlr.sql.OdpsParserBaseListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class SqlParserUtil {
    public static boolean hasResultSet(String sql) {
        SqlParserListener parserListener = SqlParserUtil.getSqlParserListener(sql);
        if (parserListener.isQueryStatement()) {
            if (parserListener.isSelectQueryStatement()) {
                return true;
            }
            if (parserListener.isInsertStatement()) {
                return false;
            }
            if (parserListener.isFromStatement()) {
                if (parserListener.isFromRest()) {
                    return true;
                }
                return !parserListener.isMultiInsertBranch();
            }
        }
        return false;
    }

    public static boolean isSelect(String sql) throws SQLException {
        SqlParserListener parserListener = SqlParserUtil.getSqlParserListener(sql);
        if (parserListener.isQueryStatement()) {
            if (parserListener.isSelectQueryStatement()) {
                return !parserListener.isExplainStatement();
            }
            if (parserListener.isInsertStatement()) {
                return false;
            }
            if (parserListener.isFromStatement()) {
                if (parserListener.isFromRest()) {
                    return true;
                }
                return !parserListener.isMultiInsertBranch();
            }
        }
        return false;
    }

    public static List<Integer> getPlaceholderIndexList(String query) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        ANTLRInputStream input = new ANTLRInputStream(query);
        OdpsLexer lexer = new OdpsLexer((CharStream)input);
        for (Token token : lexer.getAllTokens()) {
            if (token == null || token.getType() != 418) continue;
            res.add(token.getStartIndex());
        }
        return res;
    }

    private static SqlParserListener getSqlParserListener(String sql) {
        ANTLRInputStream input = new ANTLRInputStream(sql);
        OdpsLexer lexer = new OdpsLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        OdpsParser parser = new OdpsParser((TokenStream)tokens);
        SqlParserListener parserListener = new SqlParserListener();
        ParseTreeWalker treeWalker = new ParseTreeWalker();
        treeWalker.walk((ParseTreeListener)parserListener, (ParseTree)parser.script());
        return parserListener;
    }

    static class SqlParserListener
    extends OdpsParserBaseListener {
        private boolean queryStatement;
        private boolean withClause;
        private boolean selectQueryStatement;
        private boolean fromStatement;
        private boolean insertStatement;
        private boolean explainStatement;
        private boolean fromClause;
        private boolean fromRest;
        private boolean multiInsertBranch;

        SqlParserListener() {
        }

        @Override
        public void exitQueryStatement(OdpsParser.QueryStatementContext ctx) {
            this.queryStatement = true;
        }

        @Override
        public void exitWithClause(OdpsParser.WithClauseContext ctx) {
            this.withClause = true;
        }

        @Override
        public void exitSelectQueryStatement(OdpsParser.SelectQueryStatementContext ctx) {
            this.selectQueryStatement = true;
        }

        @Override
        public void exitFromStatement(OdpsParser.FromStatementContext ctx) {
            this.fromStatement = true;
        }

        @Override
        public void exitInsertStatement(OdpsParser.InsertStatementContext ctx) {
            this.insertStatement = true;
        }

        @Override
        public void exitFromClause(OdpsParser.FromClauseContext ctx) {
            this.fromClause = true;
        }

        @Override
        public void exitFromRest(OdpsParser.FromRestContext ctx) {
            this.fromRest = true;
        }

        @Override
        public void enterWithClause(OdpsParser.WithClauseContext ctx) {
            this.withClause = true;
        }

        @Override
        public void enterExplainStatement(OdpsParser.ExplainStatementContext ctx) {
            this.explainStatement = true;
        }

        @Override
        public void exitExplainStatement(OdpsParser.ExplainStatementContext ctx) {
            this.explainStatement = true;
        }

        @Override
        public void exitMultiInsertBranch(OdpsParser.MultiInsertBranchContext ctx) {
            this.multiInsertBranch = true;
        }

        public boolean isQueryStatement() {
            return this.queryStatement;
        }

        public boolean isWithClause() {
            return this.withClause;
        }

        public boolean isSelectQueryStatement() {
            return this.selectQueryStatement;
        }

        public boolean isFromStatement() {
            return this.fromStatement;
        }

        public boolean isInsertStatement() {
            return this.insertStatement;
        }

        public boolean isFromClause() {
            return this.fromClause;
        }

        public boolean isFromRest() {
            return this.fromRest;
        }

        public boolean isMultiInsertBranch() {
            return this.multiInsertBranch;
        }

        public boolean isExplainStatement() {
            return this.explainStatement;
        }
    }
}

