/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi;

import com.aliyun.odps.Instance;
import com.aliyun.odps.InstanceFilter;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ShowInstancesCommand
implements Command {
    private static final Map<String, TypeInfo> instanceMap = new LinkedHashMap<String, TypeInfo>();
    private Date fromDate;
    private Date toDate;
    private Integer number;
    private String project = null;
    private Boolean onlyOwner = true;

    public ShowInstancesCommand(String fromDate, String toDate, String number) {
        this.fromDate = CommandUtil.toDate(fromDate);
        this.toDate = CommandUtil.toDate(toDate);
        this.number = number == null ? null : Integer.valueOf(CommandUtil.getNumberToken(number));
    }

    @Override
    public boolean isSync() {
        return true;
    }

    @Override
    public List<TypeInfo> getResultTypes() {
        return new ArrayList<TypeInfo>(instanceMap.values());
    }

    @Override
    public List<String> getResultHeaders() {
        return new ArrayList<String>(instanceMap.keySet());
    }

    @Override
    public RecordIter<Record> run(Odps odps, CommandInfo commandInfo) throws OdpsException {
        if (this.fromDate != null && this.toDate != null && this.fromDate.equals(this.toDate)) {
            throw new IllegalArgumentException("the date range is act as [from,to), so from and to couldn't be the same day");
        }
        this.project = this.project == null ? odps.getDefaultProject() : this.project;
        this.number = this.number == null ? 50 : this.number;
        this.fromDate = CommandUtil.getTime(this.fromDate, 0);
        this.toDate = CommandUtil.getTime(this.toDate, 0);
        if (this.fromDate == null && this.toDate == null) {
            this.fromDate = CommandUtil.getTime(new Date(), 0);
        }
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        InstanceFilter filter = new InstanceFilter();
        filter.setFromTime(this.fromDate);
        filter.setEndTime(this.toDate);
        filter.setOnlyOwner(this.onlyOwner);
        Iterator<Instance> insListing = odps.instances().iterator(this.project, filter);
        for (int count = 0; insListing.hasNext() && count < this.number; ++count) {
            Instance instance = insListing.next();
            results.add(this.getInstanceInfo(instance));
        }
        return new RecordIter<Record>(CommandUtil.toRecord(results, instanceMap).iterator(), this.getResultHeaders(), this.getResultTypes());
    }

    private Map<String, Object> getInstanceInfo(Instance instance) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("StartTime", instance.getStartTime());
        long runTime = -1L;
        if (instance.getEndTime() != null && instance.getStartTime() != null) {
            runTime = (instance.getEndTime().getTime() - instance.getStartTime().getTime()) / 1000L;
        } else if (instance.getEndTime() == null && instance.getStartTime() != null) {
            runTime = (new Date().getTime() - instance.getStartTime().getTime()) / 1000L;
        }
        map.put("Duration", runTime);
        map.put("TaskStatus", null);
        map.put("InstanceId", instance.getId());
        map.put("InstanceStatus", instance.getStatus().toString());
        map.put("Owner", instance.getOwner());
        StringBuilder sb = new StringBuilder();
        try {
            List<Task> tasks = instance.getTasks();
            for (Task task : tasks) {
                sb.append(task.getCommandText());
                Instance.TaskStatus status = instance.getTaskStatus().get(task.getName());
                map.put("TaskStatus", status == null ? null : status.getStatus().toString());
            }
        }
        catch (OdpsException odpsException) {
            // empty catch block
        }
        map.put("Query", sb.toString());
        return map;
    }

    static {
        instanceMap.put("StartTime", (TypeInfo)TypeInfoFactory.DATETIME);
        instanceMap.put("Duration", (TypeInfo)TypeInfoFactory.BIGINT);
        instanceMap.put("TaskStatus", (TypeInfo)TypeInfoFactory.STRING);
        instanceMap.put("InstanceId", (TypeInfo)TypeInfoFactory.STRING);
        instanceMap.put("InstanceStatus", (TypeInfo)TypeInfoFactory.STRING);
        instanceMap.put("Owner", (TypeInfo)TypeInfoFactory.STRING);
        instanceMap.put("Query", (TypeInfo)TypeInfoFactory.STRING);
    }
}

