/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.sqa.SQLExecutor;
import com.aliyun.odps.sqa.SQLExecutorBuilder;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public class SQLExecutorPool {
    private SQLExecutorBuilder sqlExecutorBuilder = null;
    private int initCount = 1;
    private int currentCount = 0;
    private int maxCount = 1;
    private Queue<SQLExecutor> activeExecutor = new ArrayDeque<SQLExecutor>();
    private Map<String, SQLExecutor> busyExecutor = new HashMap<String, SQLExecutor>();

    static SQLExecutorPool create(int initCount, int maxCount, SQLExecutorBuilder sqlExecutorBuilder) throws OdpsException {
        return new SQLExecutorPool(initCount, maxCount, sqlExecutorBuilder);
    }

    private SQLExecutorPool(int initCount, int maxCount, SQLExecutorBuilder sqlExecutorBuilder) throws OdpsException {
        this.initCount = initCount;
        this.maxCount = maxCount;
        this.sqlExecutorBuilder = sqlExecutorBuilder.setPool(this);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws OdpsException {
        SQLExecutorPool sQLExecutorPool = this;
        synchronized (sQLExecutorPool) {
            while (this.initCount > this.currentCount) {
                SQLExecutor sqlExecutor = this.sqlExecutorBuilder.build();
                ++this.currentCount;
                this.activeExecutor.add(sqlExecutor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SQLExecutorPool sQLExecutorPool = this;
        synchronized (sQLExecutorPool) {
            for (Map.Entry<String, SQLExecutor> entry : this.busyExecutor.entrySet()) {
                try {
                    entry.getValue().getInstance().stop();
                }
                catch (OdpsException odpsException) {}
            }
            while (!this.activeExecutor.isEmpty()) {
                SQLExecutor sqlExecutor = this.activeExecutor.poll();
                try {
                    sqlExecutor.getInstance().stop();
                }
                catch (OdpsException odpsException) {}
            }
            this.currentCount = 0;
            this.activeExecutor.clear();
            this.busyExecutor.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLExecutor getExecutor() throws OdpsException {
        SQLExecutorPool sQLExecutorPool = this;
        synchronized (sQLExecutorPool) {
            SQLExecutor sqlExecutor = null;
            if (!this.activeExecutor.isEmpty()) {
                sqlExecutor = this.activeExecutor.poll();
                if (sqlExecutor != null) {
                    this.busyExecutor.put(sqlExecutor.getId(), sqlExecutor);
                }
                return sqlExecutor;
            }
            if (this.currentCount < this.maxCount) {
                sqlExecutor = this.sqlExecutorBuilder.build();
                ++this.currentCount;
            } else {
                throw new OdpsException("No active executor in pool.");
            }
            this.busyExecutor.put(sqlExecutor.getId(), sqlExecutor);
            return sqlExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExecutor(SQLExecutor executor) {
        SQLExecutorPool sQLExecutorPool = this;
        synchronized (sQLExecutorPool) {
            if (executor != null && this.busyExecutor.containsKey(executor.getId())) {
                SQLExecutor sqlExecutor = this.busyExecutor.remove(executor.getId());
                if (sqlExecutor.isActive()) {
                    this.activeExecutor.add(sqlExecutor);
                } else {
                    --this.currentCount;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        SQLExecutorPool sQLExecutorPool = this;
        synchronized (sQLExecutorPool) {
            return this.activeExecutor.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBusyCount() {
        SQLExecutorPool sQLExecutorPool = this;
        synchronized (sQLExecutorPool) {
            return this.busyExecutor.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExecutorCount() {
        SQLExecutorPool sQLExecutorPool = this;
        synchronized (sQLExecutorPool) {
            return this.currentCount;
        }
    }
}

