/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.transform;

import com.aliyun.odps.simpleframework.xml.transform.Matcher;
import com.aliyun.odps.simpleframework.xml.transform.Transform;
import com.aliyun.odps.simpleframework.xml.util.Cache;
import com.aliyun.odps.simpleframework.xml.util.ConcurrentCache;

public class RegistryMatcher
implements Matcher {
    private final Cache<Transform> transforms = new ConcurrentCache<Transform>();
    private final Cache<Class> types = new ConcurrentCache<Class>();

    public void bind(Class type, Class transform) {
        this.types.cache(type, transform);
    }

    public void bind(Class type, Transform transform) {
        this.transforms.cache(type, transform);
    }

    @Override
    public Transform match(Class type) throws Exception {
        Transform transform = this.transforms.fetch(type);
        if (transform == null) {
            return this.create(type);
        }
        return transform;
    }

    private Transform create(Class type) throws Exception {
        Class factory = this.types.fetch(type);
        if (factory != null) {
            return this.create(type, factory);
        }
        return null;
    }

    private Transform create(Class type, Class factory) throws Exception {
        Object value = factory.newInstance();
        Transform transform = (Transform)value;
        if (transform != null) {
            this.transforms.cache(type, transform);
        }
        return transform;
    }
}

