/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.core.ClassType;
import com.aliyun.odps.simpleframework.xml.core.CollectionFactory;
import com.aliyun.odps.simpleframework.xml.core.Context;
import com.aliyun.odps.simpleframework.xml.core.Instance;
import com.aliyun.odps.simpleframework.xml.core.Label;
import com.aliyun.odps.simpleframework.xml.core.Primitive;
import com.aliyun.odps.simpleframework.xml.core.Repeater;
import com.aliyun.odps.simpleframework.xml.strategy.Type;
import com.aliyun.odps.simpleframework.xml.stream.InputNode;
import com.aliyun.odps.simpleframework.xml.stream.OutputNode;
import java.util.Collection;

class TextList
implements Repeater {
    private final CollectionFactory factory;
    private final Primitive primitive;
    private final Type type = new ClassType(String.class);

    public TextList(Context context, Type list, Label label) {
        this.factory = new CollectionFactory(context, list);
        this.primitive = new Primitive(context, this.type);
    }

    @Override
    public Object read(InputNode node) throws Exception {
        Instance value = this.factory.getInstance(node);
        Object data = value.getInstance();
        if (value.isReference()) {
            return value.getInstance();
        }
        return this.read(node, data);
    }

    @Override
    public Object read(InputNode node, Object result) throws Exception {
        Collection list = (Collection)result;
        Object value = this.primitive.read(node);
        if (value != null) {
            list.add(value);
        }
        return result;
    }

    @Override
    public boolean validate(InputNode node) throws Exception {
        return true;
    }

    @Override
    public void write(OutputNode node, Object object) throws Exception {
        Collection list = (Collection)object;
        OutputNode parent = node.getParent();
        for (Object item : list) {
            this.primitive.write(parent, item);
        }
    }
}

